/*
 * Decompiled with CFR 0.152.
 */
package miniml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Scanner;
import miniml.Node;
import miniml.Stack;
import miniml.UpdateException;

public class Document {
    private static final String EXTENSION = "mnml";
    static final String NODE_END = "__end__";
    static final String VALUE_PREFIX = "=";
    private static final String COMMENT_PREFIX = "//";
    private Node root;
    private final File file;

    public Document(File file) {
        if (file == null) {
            throw new NullPointerException("The file cannot be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The file has to be a file, not a directory.");
        }
        String name = file.getName();
        String extension = name.substring(name.lastIndexOf(46) + 1, name.length());
        if (!extension.contentEquals(EXTENSION)) {
            throw new IllegalArgumentException("The file has to be .mnml file");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The file does not exist.");
        }
        this.file = new File(file.getAbsolutePath());
        this.parseDocument();
    }

    public Document(String path) {
        this(new File(path));
    }

    private void parseDocument() {
        int lineNumber = 0;
        String line = "";
        try {
            Scanner sc = new Scanner(new FileInputStream(this.file));
            try {
                Stack<Node> nodeStack = new Stack<Node>();
                while (sc.hasNextLine()) {
                    line = sc.nextLine().trim();
                    ++lineNumber;
                    if (line.startsWith(COMMENT_PREFIX) || line.startsWith(VALUE_PREFIX) && nodeStack.isEmpty()) continue;
                    if (nodeStack.isEmpty() && this.root != null && !line.contentEquals(NODE_END)) {
                        throw new IllegalStateException("A second root was found on line " + lineNumber + ".");
                    }
                    if (line.startsWith(NODE_END)) {
                        nodeStack.pop();
                        continue;
                    }
                    if (line.startsWith(VALUE_PREFIX)) {
                        ((Node)nodeStack.peek()).values.add(line.substring(VALUE_PREFIX.length()));
                        continue;
                    }
                    if (nodeStack.isEmpty()) {
                        this.root = new Node(line, null, this, false);
                        nodeStack.push(this.root);
                        continue;
                    }
                    nodeStack.push(new Node(line, (Node)nodeStack.peek(), this, false));
                }
                throw new IllegalStateException("The node \"" + ((Node)nodeStack.peek()).getName() + "\" is not closed.");
            }
            catch (Throwable throwable) {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NullPointerException sc) {
        }
        catch (EmptyStackException e) {
            throw new IllegalStateException("A \"__end__\" without a matching node was found on line " + lineNumber + ".");
        }
    }

    void update() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            writer.write(this.root.asString(0));
            writer.flush();
        }
        catch (IOException e) {
            throw new UpdateException("Something went wrong while updating the file.");
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public Node createNode(String name, Node parent) {
        return new Node(name, parent, this, true);
    }
}

