/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.codegen;

import com.github.longdt.vertxorm.annotation.Driver;
import com.github.longdt.vertxorm.annotation.NamingStrategy;
import com.github.longdt.vertxorm.annotation.Repository;
import com.github.longdt.vertxorm.codegen.AnnotationValues;
import com.github.longdt.vertxorm.codegen.AutoValue_RepositoryDeclaration;
import com.github.longdt.vertxorm.codegen.Mirrors;
import com.github.longdt.vertxorm.codegen.PackageAndClass;
import com.github.longdt.vertxorm.repository.CrudRepository;
import com.google.auto.common.MoreElements;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@AutoValue
abstract class RepositoryDeclaration {
    RepositoryDeclaration() {
    }

    abstract TypeElement targetType();

    abstract Element target();

    abstract Optional<String> className();

    abstract TypeElement extendingType();

    abstract Driver driver();

    abstract NamingStrategy namingStrategy();

    abstract AnnotationMirror mirror();

    abstract ImmutableMap<String, AnnotationValue> valuesMap();

    PackageAndClass getRepositoryName() {
        String packageName = MoreElements.getPackage((Element)this.targetType()).getQualifiedName().toString();
        if (this.className().isPresent()) {
            return PackageAndClass.of(packageName, this.className().get());
        }
        StringBuilder builder = new StringBuilder();
        for (String enclosingSimpleName : this.targetEnclosingSimpleNames()) {
            builder.append(enclosingSimpleName).append('_');
        }
        builder.append(this.targetType().getSimpleName()).append("Factory");
        return PackageAndClass.of(packageName, builder.toString());
    }

    private ImmutableList<String> targetEnclosingSimpleNames() {
        ImmutableList.Builder simpleNames = ImmutableList.builder();
        Element element = this.targetType().getEnclosingElement();
        while (!element.getKind().equals((Object)ElementKind.PACKAGE)) {
            simpleNames.add((Object)element.getSimpleName().toString());
            element = element.getEnclosingElement();
        }
        return simpleNames.build().reverse();
    }

    private static TypeElement getAnnotatedType(Element element) {
        Object types = ImmutableList.of();
        while (types.isEmpty()) {
            types = ElementFilter.typesIn(Arrays.asList(element));
            element = element.getEnclosingElement();
        }
        return (TypeElement)Iterables.getOnlyElement((Iterable)types);
    }

    static boolean isValidIdentifier(String identifier) {
        return SourceVersion.isIdentifier(identifier) && !SourceVersion.isKeyword(identifier);
    }

    static boolean isCrudRepository(TypeElement type) {
        return type.getQualifiedName().contentEquals(CrudRepository.class.getName());
    }

    static boolean isValidSupertypeForClass(TypeElement type) {
        if (RepositoryDeclaration.isCrudRepository(type)) {
            return true;
        }
        if (!type.getKind().equals((Object)ElementKind.CLASS)) {
            return false;
        }
        if (type.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        if (!type.getEnclosingElement().getKind().equals((Object)ElementKind.PACKAGE) && !type.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return type.getSimpleName().length() != 0;
    }

    public static class Factory {
        private final Elements elements;
        private final Messager messager;

        Factory(Elements elements, Messager messager) {
            this.elements = elements;
            this.messager = messager;
        }

        Optional<RepositoryDeclaration> createIfValid(Element element) {
            Preconditions.checkNotNull((Object)element);
            AnnotationMirror mirror = Mirrors.getAnnotationMirror(element, Repository.class).get();
            Preconditions.checkArgument((boolean)Mirrors.getQualifiedName(mirror.getAnnotationType()).contentEquals(Repository.class.getName()));
            ImmutableMap<String, AnnotationValue> values = Mirrors.simplifyAnnotationValueMap(this.elements.getElementValuesWithDefaults(mirror));
            Preconditions.checkState((values.size() == 4 ? 1 : 0) != 0);
            AnnotationValue classNameValue = (AnnotationValue)values.get("className");
            String className = classNameValue.getValue().toString();
            if (!className.isEmpty() && !RepositoryDeclaration.isValidIdentifier(className)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("\"%s\" is not a valid Java identifier", className), element, mirror, classNameValue);
                return Optional.empty();
            }
            AnnotationValue extendingValue = (AnnotationValue)Preconditions.checkNotNull((Object)((AnnotationValue)values.get("extending")));
            TypeElement extendingType = AnnotationValues.asType(extendingValue);
            if (extendingType == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find the type: " + extendingValue.getValue(), element, mirror, extendingValue);
                return Optional.empty();
            }
            if (!RepositoryDeclaration.isValidSupertypeForClass(extendingType)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a valid supertype for a factory. Supertypes must be non-final classes.", extendingType.getQualifiedName()), element, mirror, extendingValue);
                return Optional.empty();
            }
            if (!RepositoryDeclaration.isCrudRepository(extendingType)) {
                List noParameterConstructors = ElementFilter.constructorsIn(extendingType.getEnclosedElements()).stream().filter(constructor -> constructor.getParameters().isEmpty()).collect(Collectors.toList());
                if (noParameterConstructors.isEmpty()) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a valid supertype for a factory. Factory supertypes must have a no-arg constructor.", extendingType.getQualifiedName()), element, mirror, extendingValue);
                    return Optional.empty();
                }
                if (noParameterConstructors.size() > 1) {
                    throw new IllegalStateException("Multiple constructors with no parameters??");
                }
            }
            AnnotationValue driverValue = (AnnotationValue)Preconditions.checkNotNull((Object)((AnnotationValue)values.get("driver")));
            Driver driver = AnnotationValues.asEnum(driverValue, Driver.class);
            AnnotationValue namingStrategySValue = (AnnotationValue)Preconditions.checkNotNull((Object)((AnnotationValue)values.get("namingStrategy")));
            NamingStrategy namingStrategy = AnnotationValues.asEnum(namingStrategySValue, NamingStrategy.class);
            return Optional.of(new AutoValue_RepositoryDeclaration(RepositoryDeclaration.getAnnotatedType(element), element, className.isEmpty() ? Optional.empty() : Optional.of(className), extendingType, driver, namingStrategy, mirror, (ImmutableMap<String, AnnotationValue>)ImmutableMap.copyOf(values)));
        }
    }
}

