/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository;

import com.github.longdt.vertxorm.repository.Page;
import com.github.longdt.vertxorm.repository.PageRequest;
import com.github.longdt.vertxorm.repository.query.Query;
import com.github.longdt.vertxorm.repository.query.RawQuery;
import com.github.longdt.vertxorm.util.Futures;
import com.github.longdt.vertxorm.util.SQLHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnection;
import java.util.List;
import java.util.Optional;

public interface CrudRepository<ID, E> {
    default public void save(E entity, Handler<AsyncResult<E>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::save, entity, resultHandler);
    }

    default public Future<E> save(E entity) {
        return Futures.toFuture(this::save, entity);
    }

    public void save(SqlConnection var1, E var2, Handler<AsyncResult<E>> var3);

    default public Future<E> save(SqlConnection conn, E entity) {
        return Futures.toFuture(this::save, conn, entity);
    }

    default public void insert(E entity, Handler<AsyncResult<E>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::insert, entity, resultHandler);
    }

    default public Future<E> insert(E entity) {
        return Futures.toFuture(this::insert, entity);
    }

    public void insert(SqlConnection var1, E var2, Handler<AsyncResult<E>> var3);

    default public Future<E> insert(SqlConnection conn, E entity) {
        return Futures.toFuture(this::insert, conn, entity);
    }

    default public void update(E entity, Handler<AsyncResult<E>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::update, entity, resultHandler);
    }

    default public Future<E> update(E entity) {
        return Futures.toFuture(this::update, entity);
    }

    public void update(SqlConnection var1, E var2, Handler<AsyncResult<E>> var3);

    default public Future<E> update(SqlConnection conn, E entity) {
        return Futures.toFuture(this::update, conn, entity);
    }

    default public void delete(ID id, Handler<AsyncResult<Void>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::delete, id, resultHandler);
    }

    default public Future<Void> delete(ID id) {
        return Futures.toFuture(this::delete, id);
    }

    public void delete(SqlConnection var1, ID var2, Handler<AsyncResult<Void>> var3);

    default public Future<Void> delete(SqlConnection conn, ID id) {
        return Futures.toFuture(this::delete, conn, id);
    }

    default public void find(ID id, Handler<AsyncResult<Optional<E>>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::find, id, resultHandler);
    }

    default public Future<Optional<E>> find(ID id) {
        return Futures.toFuture(this::find, id);
    }

    public void find(SqlConnection var1, ID var2, Handler<AsyncResult<Optional<E>>> var3);

    default public Future<Optional<E>> find(SqlConnection conn, ID id) {
        return Futures.toFuture(this::find, conn, id);
    }

    default public void findAll(Handler<AsyncResult<List<E>>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::findAll, resultHandler);
    }

    default public Future<List<E>> findAll() {
        return Futures.toFuture(this::findAll);
    }

    public void findAll(SqlConnection var1, Handler<AsyncResult<List<E>>> var2);

    default public Future<List<E>> findAll(SqlConnection conn) {
        return Futures.toFuture(this::findAll, conn);
    }

    default public void findAll(Query<E> query, Handler<AsyncResult<List<E>>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::findAll, query, resultHandler);
    }

    default public Future<List<E>> findAll(Query<E> query) {
        return Futures.toFuture(this::findAll, query);
    }

    public void findAll(SqlConnection var1, Query<E> var2, Handler<AsyncResult<List<E>>> var3);

    default public Future<List<E>> findAll(SqlConnection conn, Query<E> query) {
        return Futures.toFuture(this::findAll, conn, query);
    }

    default public void find(Query<E> query, Handler<AsyncResult<Optional<E>>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::find, query, resultHandler);
    }

    default public Future<Optional<E>> find(Query<E> query) {
        return Futures.toFuture(this::find, query);
    }

    public void find(SqlConnection var1, Query<E> var2, Handler<AsyncResult<Optional<E>>> var3);

    default public Future<Optional<E>> find(SqlConnection conn, Query<E> query) {
        return Futures.toFuture(this::find, conn, query);
    }

    default public void findAll(PageRequest pageRequest, Handler<AsyncResult<Page<E>>> resultHandler) {
        this.findAll(new RawQuery(null), pageRequest, resultHandler);
    }

    default public Future<Page<E>> findAll(PageRequest pageRequest) {
        return Futures.toFuture(this::findAll, pageRequest);
    }

    default public void findAll(Query<E> query, PageRequest pageRequest, Handler<AsyncResult<Page<E>>> resultHandler) {
        SQLHelper.inTransactionSingle(this.getPool(), conn -> this.findAll((SqlConnection)conn, query, pageRequest), resultHandler);
    }

    default public Future<Page<E>> findAll(Query<E> query, PageRequest pageRequest) {
        return Futures.toFuture(this::findAll, query, pageRequest);
    }

    default public void findAll(SqlConnection conn, PageRequest pageRequest, Handler<AsyncResult<Page<E>>> resultHandler) {
        this.findAll(conn, new RawQuery(null), pageRequest, resultHandler);
    }

    default public Future<Page<E>> findAll(SqlConnection conn, PageRequest pageRequest) {
        return Futures.toFuture(this::findAll, conn, pageRequest);
    }

    public void findAll(SqlConnection var1, Query<E> var2, PageRequest var3, Handler<AsyncResult<Page<E>>> var4);

    default public Future<Page<E>> findAll(SqlConnection conn, Query<E> query, PageRequest pageRequest) {
        return Futures.toFuture(this::findAll, conn, query, pageRequest);
    }

    default public void count(Query<E> query, Handler<AsyncResult<Long>> resultHandler) {
        SQLHelper.executeInConnection(this.getPool(), this::count, query, resultHandler);
    }

    default public Future<Long> count(Query<E> query) {
        return Futures.toFuture(this::count, query);
    }

    public void count(SqlConnection var1, Query<E> var2, Handler<AsyncResult<Long>> var3);

    default public Future<Long> count(SqlConnection conn, Query<E> query) {
        return Futures.toFuture(this::count, conn, query);
    }

    public Pool getPool();
}

