/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.longdt.vertxorm.repository.base.BuilderImpl;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Row;
import java.math.BigDecimal;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RowMapper<ID, E> {
    public static <ID, E> Builder<ID, E> builder(String tableName, Supplier<E> supplier) {
        return new BuilderImpl(tableName, supplier);
    }

    public E map(Row var1);

    public static interface Builder<ID, E> {
        public Builder<ID, E> pk(String var1, Function<E, ID> var2, BiConsumer<E, ID> var3);

        public Builder<ID, E> pk(String var1, Function<E, ID> var2, BiConsumer<E, ID> var3, boolean var4);

        public <T> Builder<ID, E> pkConverter(Function<ID, T> var1, Function<T, ID> var2);

        public <T> Builder<ID, E> addField(String var1, Function<? super E, T> var2, BiConsumer<? super E, T> var3);

        public <T, D> Builder<ID, E> addField(String var1, Function<? super E, T> var2, BiConsumer<? super E, T> var3, Function<T, D> var4, Function<D, T> var5);

        public Builder<ID, E> addUuidField(String var1, Function<E, UUID> var2, BiConsumer<E, UUID> var3);

        public <T> Builder<ID, E> addJsonField(String var1, Function<E, T> var2, BiConsumer<E, T> var3, Class<T> var4);

        public <T> Builder<ID, E> addJsonField(String var1, Function<E, T> var2, BiConsumer<E, T> var3, TypeReference<T> var4);

        public Builder<ID, E> addDecimalField(String var1, Function<E, BigDecimal> var2, BiConsumer<E, BigDecimal> var3);

        public Builder<ID, E> addJsonObjectField(String var1, Function<E, JsonObject> var2, BiConsumer<E, JsonObject> var3);

        public RowMapper<ID, E> build();
    }
}

