/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.base;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.longdt.vertxorm.repository.RowMapper;
import com.github.longdt.vertxorm.repository.base.FieldMapping;
import com.github.longdt.vertxorm.repository.base.RowMapperImpl;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.JacksonCodec;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class BuilderImpl<ID, E>
implements RowMapper.Builder<ID, E> {
    private final String tableName;
    private final Supplier<E> supplier;
    private String pkName;
    private boolean pkAutoGen;
    private Function<E, ID> pkGetter;
    private BiConsumer<E, ID> pkSetter;
    private FieldMapping<E, ?> pkConverter;
    private Function<ID, ?> pkGetConverter;
    private final Map<String, FieldMapping<E, ?>> mappings;

    public BuilderImpl(String tableName, Supplier<E> supplier) {
        this.tableName = tableName;
        this.supplier = supplier;
        this.mappings = new LinkedHashMap();
    }

    @Override
    public RowMapper.Builder<ID, E> pk(String pkName, Function<E, ID> pkGetter, BiConsumer<E, ID> pkSetter) {
        return this.pk(pkName, pkGetter, pkSetter, false);
    }

    @Override
    public RowMapper.Builder<ID, E> pk(String pkName, Function<E, ID> pkGetter, BiConsumer<E, ID> pkSetter, boolean autogen) {
        this.pkName = pkName;
        this.pkGetter = pkGetter;
        this.pkSetter = pkSetter;
        this.pkAutoGen = autogen;
        this.pkConverter = new FieldMapping<E, ID>(pkName, pkGetter, pkSetter);
        this.pkGetConverter = Function.identity();
        this.mappings.put(pkName, this.pkConverter);
        return this;
    }

    @Override
    public <T> RowMapper.Builder<ID, E> pkConverter(Function<ID, T> pkGetConverter, Function<T, ID> pkSetConverter) {
        Objects.requireNonNull(this.pkName);
        this.pkGetConverter = pkGetConverter;
        this.pkConverter = new FieldMapping<Object, Object>(this.pkName, entity -> pkGetConverter.apply(this.pkGetter.apply(entity)), (entity, value) -> this.pkSetter.accept(entity, pkSetConverter.apply(value)));
        this.mappings.put(this.pkName, this.pkConverter);
        return this;
    }

    @Override
    public <T> RowMapper.Builder<ID, E> addField(String fieldName, Function<? super E, T> getter, BiConsumer<? super E, T> setter) {
        this.mappings.put(fieldName, new FieldMapping<E, T>(fieldName, getter, setter));
        return this;
    }

    @Override
    public <T, D> RowMapper.Builder<ID, E> addField(String fieldName, Function<? super E, T> getter, BiConsumer<? super E, T> setter, Function<T, D> getConverter, Function<D, T> setConverter) {
        this.mappings.put(fieldName, new FieldMapping<Object, Object>(fieldName, entity -> {
            Object v = getter.apply((Object)entity);
            return v != null ? getConverter.apply(v) : null;
        }, (entity, value) -> {
            if (value != null) {
                setter.accept((Object)entity, (Object)setConverter.apply(value));
            }
        }));
        return this;
    }

    @Override
    public RowMapper.Builder<ID, E> addUuidField(String fieldName, Function<E, UUID> getter, BiConsumer<E, UUID> setter) {
        this.mappings.put(fieldName, new FieldMapping<Object, String>(fieldName, entity -> {
            UUID v = (UUID)getter.apply(entity);
            return v != null ? v.toString() : null;
        }, (entity, value) -> {
            if (value != null) {
                setter.accept(entity, UUID.fromString(value));
            }
        }));
        return this;
    }

    @Override
    public <T> RowMapper.Builder<ID, E> addJsonField(String fieldName, Function<E, T> getter, BiConsumer<E, T> setter, Class<T> clazz) {
        this.mappings.put(fieldName, new FieldMapping<Object, String>(fieldName, entity -> {
            Object v = getter.apply(entity);
            return v != null ? Json.encode(v) : null;
        }, (entity, value) -> {
            if (value != null) {
                setter.accept(entity, Json.decodeValue((String)value, (Class)clazz));
            }
        }));
        return this;
    }

    @Override
    public <T> RowMapper.Builder<ID, E> addJsonField(String fieldName, Function<E, T> getter, BiConsumer<E, T> setter, TypeReference<T> type) {
        this.mappings.put(fieldName, new FieldMapping<Object, String>(fieldName, entity -> {
            Object v = getter.apply(entity);
            return v != null ? Json.encode(v) : null;
        }, (entity, value) -> {
            if (value != null) {
                setter.accept(entity, JacksonCodec.fromString((String)value, (TypeReference)type));
            }
        }));
        return this;
    }

    @Override
    public RowMapper.Builder<ID, E> addDecimalField(String fieldName, Function<E, BigDecimal> getter, BiConsumer<E, BigDecimal> setter) {
        this.mappings.put(fieldName, new FieldMapping<Object, String>(fieldName, entity -> {
            BigDecimal v = (BigDecimal)getter.apply(entity);
            return v != null ? v.toString() : null;
        }, (entity, value) -> {
            if (value != null) {
                setter.accept(entity, new BigDecimal((String)value));
            }
        }));
        return this;
    }

    @Override
    public RowMapper.Builder<ID, E> addJsonObjectField(String fieldName, Function<E, JsonObject> getter, BiConsumer<E, JsonObject> setter) {
        this.mappings.put(fieldName, new FieldMapping<Object, String>(fieldName, entity -> {
            JsonObject v = (JsonObject)getter.apply(entity);
            return v != null ? v.toString() : null;
        }, (entity, value) -> {
            if (value != null) {
                setter.accept(entity, new JsonObject(value));
            }
        }));
        return this;
    }

    @Override
    public RowMapper<ID, E> build() {
        return new RowMapperImpl(this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Supplier<E> getSupplier() {
        return this.supplier;
    }

    public String getPkName() {
        return this.pkName;
    }

    public boolean isPkAutoGen() {
        return this.pkAutoGen;
    }

    public Function<E, ID> getPkGetter() {
        return this.pkGetter;
    }

    public BiConsumer<E, ID> getPkSetter() {
        return this.pkSetter;
    }

    public FieldMapping<E, ?> getPkConverter() {
        return this.pkConverter;
    }

    public Function<ID, ?> getPkGetConverter() {
        return this.pkGetConverter;
    }

    public Map<String, FieldMapping<E, ?>> getMappings() {
        return this.mappings;
    }
}

