/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.base;

import com.github.longdt.vertxorm.repository.RowMapper;
import com.github.longdt.vertxorm.repository.base.BuilderImpl;
import com.github.longdt.vertxorm.repository.base.FieldMapping;
import com.github.longdt.vertxorm.util.Tuples;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RowMapperImpl<ID, E>
implements RowMapper<ID, E> {
    private String tableName;
    private Supplier<E> supplier;
    private boolean pkAutoGen;
    private Function<E, ID> pkGetter;
    private FieldMapping<E, ?> pkConverter;
    private Function<ID, ?> pkGetConverter;
    private List<String> columnNames;
    private List<String> columnNamesPlusPK;
    private List<FieldMapping<E, ?>> fieldMappings;
    private List<FieldMapping<E, ?>> mappingsPlusPK;

    public RowMapperImpl(BuilderImpl<ID, E> builder) {
        this.tableName = builder.getTableName();
        this.supplier = builder.getSupplier();
        this.pkAutoGen = builder.isPkAutoGen();
        this.pkGetter = builder.getPkGetter();
        this.pkGetConverter = builder.getPkGetConverter();
        this.pkConverter = builder.getPkConverter();
        String pkName = builder.getPkName();
        this.columnNames = builder.getMappings().keySet().stream().filter(c -> !pkName.equals(c)).collect(Collectors.toList());
        this.columnNamesPlusPK = new ArrayList<String>(this.columnNames.size() + 1);
        this.columnNamesPlusPK.addAll(this.columnNames);
        this.columnNamesPlusPK.add(pkName);
        this.fieldMappings = builder.getMappings().values().stream().filter(m -> !pkName.equals(m.getFieldName())).collect(Collectors.toList());
        this.mappingsPlusPK = new ArrayList(this.fieldMappings.size() + 1);
        this.mappingsPlusPK.addAll(this.fieldMappings);
        this.mappingsPlusPK.add(this.pkConverter);
    }

    public String tableName() {
        return this.tableName;
    }

    public E newInstance() {
        return this.supplier.get();
    }

    public String pkName() {
        return this.pkConverter.getFieldName();
    }

    public boolean isPkAutoGen() {
        return this.pkAutoGen;
    }

    public List<String> getColumnNames() {
        return this.getColumnNames(true);
    }

    public List<String> getColumnNames(boolean includePK) {
        return includePK ? this.columnNamesPlusPK : this.columnNames;
    }

    public List<FieldMapping<E, ?>> getFieldMappings() {
        return this.getMappings(true);
    }

    public List<FieldMapping<E, ?>> getMappings(boolean includePK) {
        return includePK ? this.mappingsPlusPK : this.fieldMappings;
    }

    public ID getId(E entity) {
        return this.pkGetter.apply(entity);
    }

    public Object id2DbValue(ID id) {
        return this.pkGetConverter.apply(id);
    }

    public void setId(E entity, Object id) {
        this.pkConverter.set(entity, id);
    }

    @Override
    public E map(Row rs) {
        E entity = this.supplier.get();
        int i = 0;
        for (FieldMapping<E, ?> m : this.getFieldMappings()) {
            m.set(entity, rs.getValue(i));
            ++i;
        }
        return entity;
    }

    public Tuple toTuple(E entity) {
        return this.toTuple(entity, true);
    }

    public Tuple toTuple(E entity, boolean includePK) {
        List mappings = this.getMappings(includePK);
        return (Tuple)mappings.stream().map((? super T m) -> m.get(entity)).collect(() -> new ArrayTuple(mappings.size()), ArrayTuple::addValue, Tuples::addAll);
    }
}

