/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.postgresql;

import com.github.longdt.vertxorm.repository.CrudRepository;
import com.github.longdt.vertxorm.repository.EntityNotFoundException;
import com.github.longdt.vertxorm.repository.Page;
import com.github.longdt.vertxorm.repository.PageRequest;
import com.github.longdt.vertxorm.repository.RowMapper;
import com.github.longdt.vertxorm.repository.base.RowMapperImpl;
import com.github.longdt.vertxorm.repository.query.Query;
import com.github.longdt.vertxorm.util.Tuples;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractCrudRepository<ID, E>
implements CrudRepository<ID, E> {
    private final Class<ID> idClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected Pool pool;
    protected RowMapperImpl<ID, E> rowMapper;
    private String deleteSql;
    private String upsertSql;
    private String insertSql;
    private String insertPkSql;
    private String updateSql;
    private String querySql;
    private String countSql;

    public void init(Pool pool, RowMapperImpl<ID, E> rowMapper) {
        this.pool = pool;
        this.rowMapper = rowMapper;
        this.deleteSql = "DELETE FROM \"" + rowMapper.tableName() + "\" WHERE \"" + rowMapper.pkName() + "\" = $1";
        this.upsertSql = "INSERT INTO \"" + rowMapper.tableName() + "\" " + rowMapper.getColumnNames().stream().map(c -> "\"" + c + "\"").collect(Collectors.joining(",", "(", ")")) + " VALUES " + IntStream.rangeClosed(1, rowMapper.getColumnNames().size()).mapToObj(idx -> "$" + idx).collect(Collectors.joining(",", "(", ")")) + " ON CONFLICT (\"" + rowMapper.pkName() + "\") DO UPDATE SET " + rowMapper.getColumnNames(false).stream().map(c -> "\"" + c + "\" = EXCLUDED.\"" + c + "\"").collect(Collectors.joining(", "));
        this.insertSql = "INSERT INTO \"" + rowMapper.tableName() + "\" " + rowMapper.getColumnNames(false).stream().map(c -> "\"" + c + "\"").collect(Collectors.joining(",", "(", ")")) + " VALUES " + IntStream.rangeClosed(1, rowMapper.getColumnNames(false).size()).mapToObj(idx -> "$" + idx).collect(Collectors.joining(",", "(", ")")) + " RETURNING \"" + rowMapper.pkName() + "\"";
        this.insertPkSql = "INSERT INTO \"" + rowMapper.tableName() + "\" " + rowMapper.getColumnNames().stream().map(c -> "\"" + c + "\"").collect(Collectors.joining(",", "(", ")")) + " VALUES " + IntStream.rangeClosed(1, rowMapper.getColumnNames().size()).mapToObj(idx -> "$" + idx).collect(Collectors.joining(",", "(", ")"));
        this.updateSql = "UPDATE \"" + rowMapper.tableName() + "\" SET " + IntStream.range(0, rowMapper.getColumnNames(false).size()).mapToObj(idx -> "\"" + rowMapper.getColumnNames(false).get(idx) + "\" = $" + (idx + 1)).collect(Collectors.joining(",")) + " WHERE \"" + rowMapper.pkName() + "\" = $" + rowMapper.getColumnNames().size();
        this.querySql = "SELECT " + rowMapper.getColumnNames().stream().map(c -> "\"" + c + "\"").collect(Collectors.joining(",")) + " FROM \"" + rowMapper.tableName() + "\"";
        this.countSql = "SELECT count(*) FROM \"" + rowMapper.tableName() + "\"";
    }

    @Override
    public void save(SqlConnection conn, E entity, Handler<AsyncResult<E>> resultHandler) {
        if (this.rowMapper.getId(entity) != null) {
            this.upsert(conn, entity, resultHandler);
        } else {
            this.insert(conn, entity, resultHandler);
        }
    }

    @Override
    public void insert(SqlConnection conn, E entity, Handler<AsyncResult<E>> resultHandler) {
        boolean genPk = this.rowMapper.isPkAutoGen() && this.rowMapper.getId(entity) == null;
        Tuple params = this.rowMapper.toTuple(entity, !genPk);
        String sql = genPk ? this.insertSql : this.insertPkSql;
        conn.preparedQuery(sql).execute(params, res -> {
            if (res.succeeded()) {
                try {
                    if (genPk) {
                        this.rowMapper.setId(entity, ((Row)((RowSet)res.result()).iterator().next()).getValue(0));
                    }
                    resultHandler.handle((Object)Future.succeededFuture((Object)entity));
                }
                catch (Exception e) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)new RuntimeException("Can't set id value of entity: " + entity.getClass().getName(), e)));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    private ID cast(Long id) {
        Number value = Long.class == this.idClass ? (Number)id : (Number)(Integer.class == this.idClass ? (Number)id.intValue() : (Number)(Short.class == this.idClass ? (Number)id.shortValue() : (Number)(Byte.class == this.idClass ? (Number)id.byteValue() : (Number)id)));
        return (ID)value;
    }

    @Override
    public void update(SqlConnection conn, E entity, Handler<AsyncResult<E>> resultHandler) {
        Tuple params = this.rowMapper.toTuple(entity);
        conn.preparedQuery(this.updateSql).execute(params, res -> {
            if (res.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)entity));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    private void upsert(SqlConnection conn, E entity, Handler<AsyncResult<E>> resultHandler) {
        Tuple params = this.rowMapper.toTuple(entity);
        conn.preparedQuery(this.upsertSql).execute(params, res -> {
            if (res.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)entity));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    @Override
    public void delete(SqlConnection conn, ID id, Handler<AsyncResult<Void>> resultHandler) {
        conn.preparedQuery(this.deleteSql).execute(Tuple.of((Object)this.rowMapper.id2DbValue(id)), res -> {
            if (res.succeeded()) {
                if (((RowSet)res.result()).rowCount() != 1) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)new EntityNotFoundException("Entity " + id + " is not found")));
                    return;
                }
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    @Override
    public void find(SqlConnection conn, ID id, Handler<AsyncResult<Optional<E>>> resultHandler) {
        String query = this.querySql + " WHERE \"" + this.rowMapper.pkName() + "\"=$1";
        conn.preparedQuery(query).mapping(this.rowMapper::map).execute(Tuple.of((Object)this.rowMapper.id2DbValue(id)), this.toEntity(resultHandler));
    }

    protected Handler<AsyncResult<SqlResult<List<E>>>> toList(Handler<AsyncResult<List<E>>> resultHandler) {
        return res -> {
            if (res.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)((List)((SqlResult)res.result()).value())));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        };
    }

    protected Handler<AsyncResult<RowSet<E>>> toEntity(Handler<AsyncResult<Optional<E>>> resultHandler) {
        return res -> {
            if (res.succeeded()) {
                RowIterator rowIter = ((RowSet)res.result()).iterator();
                Object entity = rowIter.hasNext() ? rowIter.next() : null;
                resultHandler.handle((Object)Future.succeededFuture(Optional.ofNullable(entity)));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        };
    }

    @Override
    public void findAll(SqlConnection conn, Handler<AsyncResult<List<E>>> resultHandler) {
        conn.query(this.querySql).collecting(Collectors.mapping(this.rowMapper::map, Collectors.toList())).execute(this.toList(resultHandler));
    }

    @Override
    public void findAll(SqlConnection conn, Query<E> query, Handler<AsyncResult<List<E>>> resultHandler) {
        String queryStr = this.toSQL(this.querySql, query);
        Tuple params = this.getSqlParams(query);
        conn.preparedQuery(queryStr).collecting(Collectors.mapping(this.rowMapper::map, Collectors.toList())).execute(params, this.toList(resultHandler));
    }

    @Override
    public void find(SqlConnection conn, Query<E> query, Handler<AsyncResult<Optional<E>>> resultHandler) {
        String queryStr = this.toSQL(this.querySql, query);
        Tuple params = this.getSqlParams(query);
        conn.preparedQuery(queryStr).mapping(this.rowMapper::map).execute(params, this.toEntity(resultHandler));
    }

    @Override
    public void findAll(SqlConnection conn, Query<E> query, PageRequest pageRequest, Handler<AsyncResult<Page<E>>> resultHandler) {
        Promise pageResult = Promise.promise();
        query.limit(pageRequest.getSize()).offset(pageRequest.getOffset());
        String queryStr = this.toSQL(this.querySql, query);
        Tuple params = this.getSqlParams(query);
        conn.preparedQuery(queryStr).collecting(Collectors.mapping(this.rowMapper::map, Collectors.toList())).execute(params, (Handler)pageResult);
        pageResult.future().compose(sqlResult -> {
            List content = (List)sqlResult.value();
            if (content.size() < pageRequest.getSize()) {
                return Future.succeededFuture(new Page(pageRequest, pageRequest.getOffset() + (long)content.size(), content));
            }
            return this.count(conn, query).map(cnt -> new Page(pageRequest, (long)cnt, content));
        }).onComplete(resultHandler);
    }

    @Override
    public void count(SqlConnection conn, Query<E> query, Handler<AsyncResult<Long>> resultHandler) {
        conn.preparedQuery(this.where(this.countSql, query)).execute(query.getConditionParams(), res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Row)((RowSet)res.result()).iterator().next()).getLong(0)));
            }
        });
    }

    protected String where(String sql, Query<E> query) {
        String condition = query.getConditionSql();
        if (condition != null) {
            sql = (String)sql + " WHERE " + query.getConditionSql();
        }
        return sql;
    }

    protected String toSQL(String sql, Query<E> query) {
        StringBuilder queryStr = new StringBuilder(sql);
        String condition = query.getConditionSql();
        if (condition != null) {
            queryStr.append(" WHERE ").append(condition);
        }
        if (query.orderBy() != null && !query.orderBy().isEmpty()) {
            queryStr.append(" ORDER BY ");
            query.orderBy().forEach(o -> queryStr.append("\"").append(o.getFieldName()).append("\" ").append(o.isDescending() ? "DESC," : "ASC,"));
            queryStr.deleteCharAt(queryStr.length() - 1);
        }
        int paramIdx = query.getConditionParams().size();
        if (query.limit() >= 0) {
            queryStr.append(" LIMIT $").append(++paramIdx);
        }
        if (query.offset() >= 0L) {
            queryStr.append(" OFFSET $").append(++paramIdx);
        }
        return queryStr.toString();
    }

    protected Tuple getSqlParams(Query<E> query) {
        if (query.limit() < 0 && query.offset() < 0L) {
            return query.getConditionParams();
        }
        Tuple params = query.getConditionParams();
        params = Tuples.addAll((Tuple)new ArrayTuple(params.size() + 2), params);
        if (query.limit() >= 0) {
            params.addInteger(Integer.valueOf(query.limit()));
        }
        if (query.offset() >= 0L) {
            params.addLong(Long.valueOf(query.offset()));
        }
        return params;
    }

    public RowMapper<ID, E> getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }
}

