/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.query;

import com.github.longdt.vertxorm.repository.query.AbstractQuery;
import com.github.longdt.vertxorm.repository.query.Query;
import com.github.longdt.vertxorm.util.Tuples;
import io.vertx.sqlclient.Tuple;
import java.util.Collection;
import java.util.Iterator;

public class Or<E>
extends AbstractQuery<E> {
    private final Collection<Query<E>> childQueries;

    public Or(Collection<Query<E>> childQueries) {
        super(null);
        if (childQueries.size() < 2) {
            throw new IllegalStateException("An 'Or' query cannot have fewer than 2 child queries, " + childQueries.size() + " were supplied");
        }
        this.childQueries = childQueries;
        this.params = childQueries.stream().map(Query::getConditionParams).collect(Tuple::tuple, Tuples::addAll, Tuples::addAll);
    }

    public Collection<Query<E>> getChildQueries() {
        return this.childQueries;
    }

    @Override
    public void buildSQL(StringBuilder sqlBuilder, int startIdx) {
        sqlBuilder.append('(');
        Iterator<Query<E>> iter = this.childQueries.iterator();
        AbstractQuery query = (AbstractQuery)iter.next();
        query.buildSQL(sqlBuilder, startIdx);
        startIdx += query.getConditionParams().size();
        while (iter.hasNext()) {
            sqlBuilder.append(") OR (");
            query = (AbstractQuery)iter.next();
            query.buildSQL(sqlBuilder, startIdx);
            startIdx += query.getConditionParams().size();
        }
        sqlBuilder.append(')');
    }
}

