/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.query;

import com.github.longdt.vertxorm.repository.query.AbstractQuery;
import com.github.longdt.vertxorm.repository.query.QueryFactory;
import io.vertx.sqlclient.Tuple;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RawQuery<E>
extends AbstractQuery<E> {
    private static final Pattern pattern = Pattern.compile("\\?");
    protected String querySql;

    public RawQuery(String querySql) {
        this(querySql, QueryFactory.EMPTY_PARAMS);
    }

    public RawQuery(String querySql, Tuple params) {
        super(params);
        this.querySql = querySql;
    }

    @Override
    public Tuple getConditionParams() {
        return this.params;
    }

    @Override
    public void buildSQL(StringBuilder sqlBuilder, int startIdx) {
        if (this.params.size() == 0) {
            sqlBuilder.append(this.querySql);
            return;
        }
        Matcher matcher = pattern.matcher(this.querySql);
        while (matcher.find()) {
            matcher.appendReplacement(sqlBuilder, "\\$");
            sqlBuilder.append(startIdx++);
        }
        matcher.appendTail(sqlBuilder);
    }
}

