/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.util;

import com.github.longdt.vertxorm.util.Futures;
import com.github.longdt.vertxorm.util.QuadConsumer;
import com.github.longdt.vertxorm.util.TriConsumer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Transaction;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

public class SQLHelper {
    public static <T, V, R> void executeInConnection(Pool pool, QuadConsumer<SqlConnection, T, V, Handler<AsyncResult<R>>> consumer, T arg1, V arg2, Handler<AsyncResult<R>> resultHandler) {
        pool.getConnection(getConn -> {
            if (getConn.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)getConn.cause()));
            } else {
                SqlConnection conn = (SqlConnection)getConn.result();
                consumer.accept(conn, arg1, arg2, res -> {
                    conn.close();
                    resultHandler.handle(res);
                });
            }
        });
    }

    public static <T, R> void executeInConnection(Pool pool, TriConsumer<SqlConnection, T, Handler<AsyncResult<R>>> consumer, T arg, Handler<AsyncResult<R>> resultHandler) {
        pool.getConnection(getConn -> {
            if (getConn.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)getConn.cause()));
            } else {
                SqlConnection conn = (SqlConnection)getConn.result();
                consumer.accept(conn, arg, res -> {
                    conn.close();
                    resultHandler.handle(res);
                });
            }
        });
    }

    public static <T, R> void executeInConnection(Pool pool, BiConsumer<SqlConnection, Handler<AsyncResult<R>>> consumer, Handler<AsyncResult<R>> resultHandler) {
        pool.getConnection(getConn -> {
            if (getConn.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)getConn.cause()));
            } else {
                SqlConnection conn = (SqlConnection)getConn.result();
                consumer.accept(conn, res -> {
                    conn.close();
                    resultHandler.handle(res);
                });
            }
        });
    }

    public static <T> void executeInConnection(Pool pool, Function<SqlConnection, Future<T>> action, Handler<AsyncResult<T>> resultHandler) {
        pool.getConnection(getConn -> {
            if (getConn.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)getConn.cause()));
            } else {
                SqlConnection conn = (SqlConnection)getConn.result();
                ((Future)action.apply(conn)).onComplete(res -> {
                    conn.close();
                    resultHandler.handle(res);
                });
            }
        });
    }

    public static <T> void inTransactionSingle(Pool pool, Function<SqlConnection, Future<T>> action, Handler<AsyncResult<T>> resultHandler) {
        SQLHelper.executeInConnection(pool, (SqlConnection conn) -> {
            Transaction txn = conn.begin();
            return ((Future)action.apply((SqlConnection)conn)).compose(res -> Futures.toFuture(arg_0 -> ((Transaction)txn).commit(arg_0)).map(res));
        }, resultHandler);
    }

    public static Future<RowSet<Row>> query(Pool pool, String query) {
        Promise promise = Promise.promise();
        pool.query(query).execute((Handler)promise);
        return promise.future();
    }

    public static Future<RowSet<Row>> query(SqlConnection conn, String query) {
        Promise promise = Promise.promise();
        conn.query(query).execute((Handler)promise);
        return promise.future();
    }

    public static <R> Future<SqlResult<R>> query(SqlConnection conn, String query, Collector<Row, ?, R> collector) {
        Promise promise = Promise.promise();
        conn.query(query).collecting(collector).execute((Handler)promise);
        return promise.future();
    }
}

