/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.query;

import com.github.longdt.vertxorm.repository.query.AbstractQuery;
import com.github.longdt.vertxorm.repository.query.Query;
import io.vertx.sqlclient.Tuple;
import java.util.Collection;
import java.util.Iterator;

public class And<E>
extends AbstractQuery<E> {
    private final Collection<Query<E>> childQueries;

    public And(Collection<Query<E>> childQueries) {
        super(null);
        if (childQueries.size() < 2) {
            throw new IllegalStateException("An 'And' query cannot have fewer than 2 child queries, " + childQueries.size() + " were supplied");
        }
        this.childQueries = childQueries;
    }

    public Collection<Query<E>> getChildQueries() {
        return this.childQueries;
    }

    @Override
    public int appendQuerySql(StringBuilder sqlBuilder, int index) {
        sqlBuilder.append('(');
        Iterator<Query<E>> iter = this.childQueries.iterator();
        Query<E> query = iter.next();
        index = query.appendQuerySql(sqlBuilder, index);
        while (iter.hasNext()) {
            sqlBuilder.append(") AND (");
            index = iter.next().appendQuerySql(sqlBuilder, index);
        }
        sqlBuilder.append(')');
        return index;
    }

    @Override
    public Tuple getQueryParams() {
        if (this.params == null) {
            this.params = this.appendQueryParams(Tuple.tuple());
        }
        return this.params;
    }

    @Override
    public Tuple appendQueryParams(Tuple tuple) {
        this.childQueries.forEach(q -> q.appendQueryParams(tuple));
        return tuple;
    }
}

