/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.postgresql;

import com.github.longdt.vertxorm.repository.Configuration;
import com.github.longdt.vertxorm.repository.CrudRepository;
import com.github.longdt.vertxorm.repository.EntityNotFoundException;
import com.github.longdt.vertxorm.repository.IdAccessor;
import com.github.longdt.vertxorm.repository.Page;
import com.github.longdt.vertxorm.repository.PageRequest;
import com.github.longdt.vertxorm.repository.postgresql.SqlSupportImpl;
import com.github.longdt.vertxorm.repository.query.Query;
import com.github.longdt.vertxorm.repository.query.QueryFactory;
import com.github.longdt.vertxorm.util.Tuples;
import io.vertx.core.Future;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public abstract class AbstractCrudRepository<ID, E>
implements CrudRepository<ID, E> {
    protected Pool pool;
    private IdAccessor<ID, E> idAccessor;
    protected Function<Row, E> rowMapper;
    protected Function<E, Object[]> parametersMapper;
    protected Collector<Row, ?, List<E>> collector;
    protected SqlSupportImpl sqlSupport;

    public void init(Pool pool, Configuration<ID, E> configuration) {
        this.pool = pool;
        this.rowMapper = Objects.requireNonNull(configuration.getRowMapper());
        this.collector = Collectors.mapping(this.rowMapper, Collectors.toList());
        this.parametersMapper = Objects.requireNonNull(configuration.getParametersMapper());
        this.idAccessor = Objects.requireNonNull(configuration.getIdAccessor());
        this.sqlSupport = new SqlSupportImpl(configuration.getTableName(), configuration.getColumnNames());
    }

    @Override
    public Future<E> save(SqlConnection conn, E entity) {
        if (this.idAccessor.getId(entity) == null) {
            return this.insert(conn, entity, true);
        }
        return this.upsert(conn, entity);
    }

    @Override
    public Future<Collection<E>> saveAll(SqlConnection conn, Collection<E> entities) {
        if (entities.isEmpty()) {
            return Future.succeededFuture();
        }
        E entity = entities.iterator().next();
        if (this.idAccessor.getId(entity) == null) {
            return this.insertAll(conn, entities, true);
        }
        return this.upsertAll(conn, entities);
    }

    @Override
    public Future<E> insert(SqlConnection conn, E entity) {
        boolean genPk = this.idAccessor.getId(entity) == null;
        return this.insert(conn, entity, genPk);
    }

    private Future<E> insert(SqlConnection conn, E entity, boolean genPk) {
        Tuple paramsTuple;
        String sql;
        Object[] params = this.parametersMapper.apply(entity);
        if (genPk) {
            sql = this.sqlSupport.getAutoIdInsertSql();
            paramsTuple = Tuples.shift(params, 1);
        } else {
            sql = this.sqlSupport.getInsertSql();
            paramsTuple = Tuple.wrap((Object[])params);
        }
        return conn.preparedQuery(sql).execute(paramsTuple).map(res -> {
            try {
                if (genPk) {
                    this.idAccessor.setId(entity, this.idAccessor.db2IdValue(((Row)res.iterator().next()).getValue(0)));
                }
                return entity;
            }
            catch (Exception e) {
                throw new RuntimeException("Can't set id value of entity: " + entity.getClass().getName(), e);
            }
        });
    }

    @Override
    public Future<Collection<E>> insertAll(SqlConnection conn, Collection<E> entities) {
        if (entities.isEmpty()) {
            return Future.succeededFuture();
        }
        E entity = entities.iterator().next();
        boolean genPk = this.idAccessor.getId(entity) == null;
        return this.insertAll(conn, entities, genPk);
    }

    private Future<Collection<E>> insertAll(SqlConnection conn, Collection<E> entities, boolean genPk) {
        List<Tuple> batch;
        String sql;
        if (genPk) {
            sql = this.sqlSupport.getAutoIdInsertSql();
            batch = this.toBatch(entities, params -> Tuples.shift(params, 1));
        } else {
            sql = this.sqlSupport.getInsertSql();
            batch = this.toBatch(entities);
        }
        return conn.preparedQuery(sql).executeBatch(batch).map(res -> {
            try {
                if (genPk) {
                    this.setIdAll(entities, (RowSet<Row>)res);
                }
                return entities;
            }
            catch (Exception e) {
                throw new RuntimeException("Can't set id value of entity in batch mode", e);
            }
        });
    }

    private void setIdAll(Collection<E> entities, RowSet<Row> rows) {
        Iterator<E> iter = entities.iterator();
        while (iter.hasNext() && rows != null) {
            this.idAccessor.setId(iter.next(), this.idAccessor.db2IdValue(((Row)rows.iterator().next()).getValue(0)));
            rows = rows.next();
        }
    }

    @Override
    public Future<E> update(SqlConnection conn, E entity) {
        Object[] params = this.parametersMapper.apply(entity);
        return conn.preparedQuery(this.sqlSupport.getUpdateSql()).execute(Tuple.wrap((Object[])params)).map(rowSet -> {
            if (rowSet.rowCount() == 1) {
                return entity;
            }
            throw new EntityNotFoundException("Entity with id: " + params[0] + " is not found");
        });
    }

    @Override
    public Future<Collection<Boolean>> updateAll(SqlConnection conn, Collection<E> entities) {
        List<Tuple> batch = this.toBatch(entities);
        return conn.preparedQuery(this.sqlSupport.getUpdateSql()).executeBatch(batch).map(rows -> this.checkExistedEntities((RowSet<Row>)rows, new ArrayList<Boolean>(entities.size())));
    }

    private Collection<Boolean> checkExistedEntities(RowSet<Row> rows, Collection<Boolean> existedEntities) {
        do {
            existedEntities.add(rows.rowCount() == 1);
        } while ((rows = rows.next()) != null);
        return existedEntities;
    }

    @Override
    public Future<E> update(SqlConnection conn, E entity, Query<E> query) {
        Tuple paramsTuple;
        Object[] params = this.parametersMapper.apply(entity);
        Object id = params[0];
        if (id == null) {
            return Future.failedFuture((Throwable)new IllegalArgumentException("id field must be set"));
        }
        StringBuilder sqlBuilder = new StringBuilder();
        int index = this.sqlSupport.getUpdateSql(sqlBuilder, query);
        if (index > this.sqlSupport.getColumnNames().size()) {
            paramsTuple = new ArrayTuple(index);
            Tuples.addAll(paramsTuple, params);
            query.appendQueryParams(paramsTuple);
        } else {
            paramsTuple = Tuple.wrap((Object[])params);
        }
        return conn.preparedQuery(sqlBuilder.toString()).execute(paramsTuple).map(rowSet -> {
            if (rowSet.rowCount() == 1) {
                return entity;
            }
            throw new EntityNotFoundException("Entity with id: " + params[0] + " is not found");
        });
    }

    @Override
    public Future<Void> updateDynamic(SqlConnection conn, E entity) {
        Object[] params = this.parametersMapper.apply(entity);
        Object id = params[0];
        if (id == null) {
            return Future.failedFuture((Throwable)new IllegalArgumentException("id field must be set"));
        }
        StringBuilder sqlBuilder = new StringBuilder();
        int idx = this.sqlSupport.getUpdateDynamicSql(sqlBuilder, params);
        if (idx == 1) {
            return Future.succeededFuture();
        }
        idx = 1;
        for (int i = 1; i < params.length; ++i) {
            if (params[i] == null) continue;
            params[idx++] = params[i];
        }
        return conn.preparedQuery(sqlBuilder.toString()).execute(Tuples.sub(params, 0, idx)).map(rowSet -> {
            if (rowSet.rowCount() == 1) {
                return null;
            }
            throw new EntityNotFoundException("Entity with id: " + params[0] + " is not found");
        });
    }

    @Override
    public Future<Collection<Boolean>> updateDynamicAll(SqlConnection conn, Collection<E> entities) {
        if (entities.isEmpty()) {
            return Future.succeededFuture();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        E entity = entities.iterator().next();
        Object[] params = this.parametersMapper.apply(entity);
        int idx = this.sqlSupport.getUpdateDynamicSql(sqlBuilder, params);
        if (idx == 1) {
            return Future.succeededFuture();
        }
        List<Tuple> batch = this.toBatch(entities, entityParams -> {
            int nonNullIdx = 1;
            for (int i = 1; i < ((Object[])entityParams).length; ++i) {
                if (entityParams[i] == null) continue;
                entityParams[nonNullIdx++] = entityParams[i];
            }
            return Tuples.sub(entityParams, 0, nonNullIdx);
        });
        return conn.preparedQuery(sqlBuilder.toString()).executeBatch(batch).map(rows -> this.checkExistedEntities((RowSet<Row>)rows, new ArrayList<Boolean>(entities.size())));
    }

    @Override
    public Future<Void> updateDynamic(SqlConnection conn, E entity, Query<E> query) {
        Object[] params = this.parametersMapper.apply(entity);
        Object id = params[0];
        if (id == null) {
            return Future.failedFuture((Throwable)new IllegalArgumentException("id field must be set"));
        }
        StringBuilder sqlBuilder = new StringBuilder();
        int idx = this.sqlSupport.getUpdateDynamicSql(sqlBuilder, params, query);
        Tuple paramsTuple = new ArrayTuple(idx).addValue(id);
        for (int i = 1; i < params.length; ++i) {
            if (params[i] == null) continue;
            paramsTuple.addValue(params[i]);
        }
        if (paramsTuple.size() == 1) {
            return Future.succeededFuture();
        }
        query.appendQueryParams(paramsTuple);
        return conn.preparedQuery(sqlBuilder.toString()).execute(paramsTuple).map(rowSet -> {
            if (rowSet.rowCount() == 1) {
                return null;
            }
            throw new EntityNotFoundException("Entity with id: " + params[0] + " is not found");
        });
    }

    private Future<E> upsert(SqlConnection conn, E entity) {
        Object[] params = this.parametersMapper.apply(entity);
        return conn.preparedQuery(this.sqlSupport.getUpsertSql()).execute(Tuple.wrap((Object[])params)).map(entity);
    }

    private Future<Collection<E>> upsertAll(SqlConnection conn, Collection<E> entities) {
        List<Tuple> batch = this.toBatch(entities);
        return conn.preparedQuery(this.sqlSupport.getUpsertSql()).executeBatch(batch).map(entities);
    }

    @Override
    public Future<Void> delete(SqlConnection conn, ID id) {
        return conn.preparedQuery(this.sqlSupport.getDeleteByIdSql()).execute(Tuple.of((Object)this.idAccessor.id2DbValue(id))).map(res -> {
            if (res.rowCount() != 1) {
                throw new EntityNotFoundException("Entity " + id + " is not found");
            }
            return null;
        });
    }

    @Override
    public Future<Void> deleteAll(SqlConnection conn, Collection<ID> ids) {
        ArrayList<ID> queryParams = ids.getClass() == ArrayList.class ? (ArrayList<ID>)ids : new ArrayList<ID>(ids);
        Query query = QueryFactory.in(this.sqlSupport.getIdName(), queryParams);
        return conn.preparedQuery(this.sqlSupport.getQuerySql(this.sqlSupport.getDeleteSql(), query)).execute(query.getQueryParams()).mapEmpty();
    }

    @Override
    public Future<Void> deleteAll(SqlConnection conn) {
        return conn.preparedQuery(this.sqlSupport.getDeleteSql()).execute().mapEmpty();
    }

    @Override
    public Future<Optional<E>> find(SqlConnection conn, ID id) {
        return conn.preparedQuery(this.sqlSupport.getQueryByIdSql()).mapping(this.rowMapper).execute(Tuple.of((Object)this.idAccessor.id2DbValue(id))).map(this::toEntity);
    }

    protected List<E> toList(SqlResult<List<E>> sqlResult) {
        return (List)sqlResult.value();
    }

    protected Optional<E> toEntity(RowSet<E> rowSet) {
        RowIterator rowIter = rowSet.iterator();
        Object entity = rowIter.hasNext() ? rowIter.next() : null;
        return Optional.ofNullable(entity);
    }

    @Override
    public Future<List<E>> findAll(SqlConnection conn) {
        return conn.query(this.sqlSupport.getQuerySql()).collecting(this.collector).execute().map(this::toList);
    }

    @Override
    public Future<List<E>> findAll(SqlConnection conn, Query<E> query) {
        String sql = this.sqlSupport.getSql(this.sqlSupport.getQuerySql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).collecting(this.collector).execute(params).map(this::toList);
    }

    @Override
    public Future<Optional<E>> find(SqlConnection conn, Query<E> query) {
        String sql = this.sqlSupport.getSql(this.sqlSupport.getQuerySql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).mapping(this.rowMapper).execute(params).map(this::toEntity);
    }

    @Override
    public Future<Page<E>> findAll(SqlConnection conn, Query<E> query, PageRequest pageRequest) {
        query.limit(pageRequest.getSize()).offset(pageRequest.getOffset());
        String sql = this.sqlSupport.getSql(this.sqlSupport.getQuerySql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).collecting(this.collector).execute(params).compose(sqlResult -> {
            List content = (List)sqlResult.value();
            if (!content.isEmpty() && content.size() < pageRequest.getSize()) {
                return Future.succeededFuture(new Page(pageRequest, pageRequest.getOffset() + (long)content.size(), content));
            }
            return this.count(conn, query).map(cnt -> new Page(pageRequest, (long)cnt, content));
        });
    }

    @Override
    public Future<Long> count(SqlConnection conn, Query<E> query) {
        return conn.preparedQuery(this.sqlSupport.getQuerySql(this.sqlSupport.getCountSql(), query)).execute(query.getQueryParams()).map(res -> ((Row)res.iterator().next()).getLong(0));
    }

    @Override
    public Future<Boolean> exists(SqlConnection conn, ID id) {
        return conn.preparedQuery(this.sqlSupport.getExistByIdSql()).execute(Tuple.of((Object)this.idAccessor.id2DbValue(id))).map(res -> res.size() > 0);
    }

    @Override
    public Future<Boolean> exists(SqlConnection conn, Query<E> query) {
        query.limit(1).offset(-1L);
        String sql = this.sqlSupport.getSql(this.sqlSupport.getExistSql(), query);
        Tuple params = this.getSqlParams(query);
        return conn.preparedQuery(sql).execute(params).map(res -> res.size() > 0);
    }

    protected Tuple getSqlParams(Query<E> query) {
        if (query.limit() < 0 && query.offset() < 0L) {
            return query.getQueryParams();
        }
        Tuple params = Tuple.tuple();
        params = query.appendQueryParams(params);
        if (query.limit() >= 0) {
            params.addInteger(Integer.valueOf(query.limit()));
        }
        if (query.offset() >= 0L) {
            params.addLong(Long.valueOf(query.offset()));
        }
        return params;
    }

    protected List<Tuple> toBatch(Collection<E> entities, Function<Object[], Tuple> tupleMapper) {
        ArrayList<Tuple> batch = new ArrayList<Tuple>(entities.size());
        for (E e : entities) {
            batch.add(tupleMapper.apply(this.parametersMapper.apply(e)));
        }
        return batch;
    }

    protected List<Tuple> toBatch(Collection<E> entities) {
        ArrayList<Tuple> batch = new ArrayList<Tuple>(entities.size());
        for (E e : entities) {
            batch.add(Tuple.wrap((Object[])this.parametersMapper.apply(e)));
        }
        return batch;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }
}

