/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.postgresql;

import com.github.longdt.vertxorm.repository.SqlSupport;
import com.github.longdt.vertxorm.repository.query.Query;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SqlSupportImpl
implements SqlSupport {
    private final String tableName;
    private final List<String> columnNames;
    private final String insertSql;
    private final String autoIdInsertSql;
    private final String upsertSql;
    private final String updateSql;
    private final String querySql;
    private final String queryByIdSql;
    private final String countSql;
    private final String existSql;
    private final String existByIdSql;
    private final String deleteSql;
    private final String deleteByIdSql;
    private final String returningAllSql;

    public SqlSupportImpl(String tableName, List<String> columnNames) {
        this.tableName = Objects.requireNonNull(tableName);
        this.columnNames = Objects.requireNonNull(columnNames);
        String columnNamesStr = columnNames.stream().map(c -> "\"" + c + "\"").collect(Collectors.joining(","));
        this.insertSql = "INSERT INTO \"" + tableName + "\" (" + columnNamesStr + ") VALUES " + IntStream.rangeClosed(1, columnNames.size()).mapToObj(idx -> "$" + idx).collect(Collectors.joining(",", "(", ")"));
        this.autoIdInsertSql = "INSERT INTO \"" + tableName + "\" " + columnNames.stream().skip(1L).map(c -> "\"" + c + "\"").collect(Collectors.joining(",", "(", ")")) + " VALUES " + IntStream.rangeClosed(1, columnNames.size() - 1).mapToObj(idx -> "$" + idx).collect(Collectors.joining(",", "(", ")")) + " RETURNING \"" + this.getIdName() + "\"";
        this.upsertSql = this.insertSql + " ON CONFLICT (\"" + this.getIdName() + "\") DO UPDATE SET " + columnNames.stream().skip(1L).map(c -> "\"" + c + "\" = EXCLUDED.\"" + c + "\"").collect(Collectors.joining(", "));
        this.updateSql = "UPDATE \"" + tableName + "\" SET " + IntStream.range(1, columnNames.size()).mapToObj(idx -> "\"" + (String)columnNames.get(idx) + "\" = $" + (idx + 1)).collect(Collectors.joining(",")) + " WHERE \"" + this.getIdName() + "\" = $1";
        this.querySql = "SELECT " + columnNamesStr + " FROM \"" + tableName + "\"";
        this.queryByIdSql = this.querySql + " WHERE \"" + this.getIdName() + "\" = $1";
        this.countSql = "SELECT count(*) FROM \"" + tableName + "\"";
        this.existSql = "SELECT 1 FROM \"" + tableName + "\"";
        this.existByIdSql = this.existSql + " WHERE \"" + this.getIdName() + "\" = $1 LIMIT 1";
        this.deleteSql = "DELETE FROM \"" + tableName + "\"";
        this.deleteByIdSql = this.deleteSql + " WHERE \"" + this.getIdName() + "\" = $1";
        this.returningAllSql = " RETURNING " + columnNamesStr;
    }

    String getTableName() {
        return this.tableName;
    }

    String getIdName() {
        return this.columnNames.get(0);
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String getInsertSql() {
        return this.insertSql;
    }

    @Override
    public String getAutoIdInsertSql() {
        return this.autoIdInsertSql;
    }

    @Override
    public String getUpsertSql() {
        return this.upsertSql;
    }

    @Override
    public String getUpdateSql() {
        return this.updateSql;
    }

    @Override
    public <E> int getUpdateSql(StringBuilder sqlBuilder, Query<E> query) {
        sqlBuilder.append(this.updateSql).append(" AND ");
        return query.appendQuerySql(sqlBuilder, this.columnNames.size());
    }

    @Override
    public int getUpdateDynamicSql(StringBuilder sqlBuilder, Object[] params) {
        sqlBuilder.append("UPDATE \"").append(this.tableName).append("\" SET ");
        int placeIdx = 1;
        for (int i = 1; i < params.length; ++i) {
            if (params[i] == null) continue;
            sqlBuilder.append('\"').append(this.columnNames.get(i)).append("\"=$").append(++placeIdx).append(',');
        }
        if (placeIdx > 1) {
            sqlBuilder.setLength(sqlBuilder.length() - 1);
        }
        sqlBuilder.append(" WHERE \"").append(this.getIdName()).append("\" = $1");
        return placeIdx;
    }

    @Override
    public <E> int getUpdateDynamicSql(StringBuilder sqlBuilder, Object[] params, Query<E> query) {
        int index = this.getUpdateDynamicSql(sqlBuilder, params);
        sqlBuilder.append(" AND ");
        return query.appendQuerySql(sqlBuilder, index);
    }

    @Override
    public String getQuerySql() {
        return this.querySql;
    }

    @Override
    public String getQueryByIdSql() {
        return this.queryByIdSql;
    }

    @Override
    public <E> String getSql(String sql, Query<E> query) {
        StringBuilder sqlBuilder = new StringBuilder(sql);
        int index = 0;
        if (query.isConditional()) {
            sqlBuilder.append(" WHERE ");
            index = query.appendQuerySql(sqlBuilder, index);
        }
        if (query.orderBy() != null && !query.orderBy().isEmpty()) {
            sqlBuilder.append(" ORDER BY ");
            query.orderBy().forEach(o -> sqlBuilder.append("\"").append(o.getFieldName()).append("\" ").append(o.isDescending() ? "DESC," : "ASC,"));
            sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        }
        if (query.limit() >= 0) {
            sqlBuilder.append(" LIMIT $").append(++index);
        }
        if (query.offset() >= 0L) {
            sqlBuilder.append(" OFFSET $").append(++index);
        }
        return sqlBuilder.toString();
    }

    @Override
    public String getCountSql() {
        return this.countSql;
    }

    @Override
    public String getExistSql() {
        return this.existSql;
    }

    @Override
    public String getExistByIdSql() {
        return this.existByIdSql;
    }

    @Override
    public String getDeleteSql() {
        return this.deleteSql;
    }

    @Override
    public String getDeleteByIdSql() {
        return this.deleteByIdSql;
    }

    public String getReturningAllSql() {
        return this.returningAllSql;
    }
}

