/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository;

import com.github.longdt.vertxorm.repository.Page;
import com.github.longdt.vertxorm.repository.PageRequest;
import com.github.longdt.vertxorm.repository.query.Query;
import com.github.longdt.vertxorm.repository.query.QueryFactory;
import io.vertx.core.Future;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface CrudRepository<ID, E> {
    default public Future<E> save(E entity) {
        return this.getPool().withConnection(conn -> this.save((SqlConnection)conn, entity));
    }

    public Future<E> save(SqlConnection var1, E var2);

    default public Future<Collection<E>> saveAll(Collection<E> entities) {
        return this.getPool().withConnection(conn -> this.saveAll((SqlConnection)conn, entities));
    }

    public Future<Collection<E>> saveAll(SqlConnection var1, Collection<E> var2);

    default public Future<E> insert(E entity) {
        return this.getPool().withConnection(conn -> this.insert((SqlConnection)conn, entity));
    }

    public Future<E> insert(SqlConnection var1, E var2);

    default public Future<Collection<E>> insertAll(Collection<E> entities) {
        return this.getPool().withConnection(conn -> this.insertAll((SqlConnection)conn, entities));
    }

    public Future<Collection<E>> insertAll(SqlConnection var1, Collection<E> var2);

    default public Future<E> update(E entity) {
        return this.getPool().withConnection(conn -> this.update((SqlConnection)conn, entity));
    }

    public Future<E> update(SqlConnection var1, E var2);

    default public Future<Collection<Boolean>> updateAll(Collection<E> entities) {
        return this.getPool().withConnection(conn -> this.updateAll((SqlConnection)conn, entities));
    }

    public Future<Collection<Boolean>> updateAll(SqlConnection var1, Collection<E> var2);

    default public Future<E> update(E entity, Query<E> query) {
        return this.getPool().withConnection(conn -> this.update((SqlConnection)conn, entity, query));
    }

    public Future<E> update(SqlConnection var1, E var2, Query<E> var3);

    default public Future<Void> updateDynamic(E entity) {
        return this.getPool().withConnection(conn -> this.updateDynamic((SqlConnection)conn, entity));
    }

    public Future<Void> updateDynamic(SqlConnection var1, E var2);

    default public Future<Collection<Boolean>> updateDynamicAll(Collection<E> entities) {
        return this.getPool().withConnection(conn -> this.updateDynamicAll((SqlConnection)conn, entities));
    }

    public Future<Collection<Boolean>> updateDynamicAll(SqlConnection var1, Collection<E> var2);

    default public Future<Integer> updateDynamicAll(E entity, Query<E> query) {
        return this.getPool().withConnection(conn -> this.updateDynamicAll((SqlConnection)conn, entity, query));
    }

    public Future<Integer> updateDynamicAll(SqlConnection var1, E var2, Query<E> var3);

    default public Future<Void> updateDynamic(E entity, Query<E> query) {
        return this.getPool().withConnection(conn -> this.updateDynamic((SqlConnection)conn, entity, query));
    }

    public Future<Void> updateDynamic(SqlConnection var1, E var2, Query<E> var3);

    default public Future<E> merge(E entity) {
        return this.getPool().withConnection(conn -> this.merge((SqlConnection)conn, entity));
    }

    public Future<E> merge(SqlConnection var1, E var2);

    default public Future<Collection<E>> mergeAll(Collection<E> entities) {
        return this.getPool().withConnection(conn -> this.mergeAll((SqlConnection)conn, entities));
    }

    public Future<Collection<E>> mergeAll(SqlConnection var1, Collection<E> var2);

    default public Future<E> merge(E entity, Query<E> query) {
        return this.getPool().withConnection(conn -> this.merge((SqlConnection)conn, entity, query));
    }

    public Future<E> merge(SqlConnection var1, E var2, Query<E> var3);

    default public Future<List<E>> mergeAll(E entity, Query<E> query) {
        return this.getPool().withConnection(conn -> this.mergeAll((SqlConnection)conn, entity, query));
    }

    public Future<List<E>> mergeAll(SqlConnection var1, E var2, Query<E> var3);

    default public Future<Void> delete(ID id) {
        return this.getPool().withConnection(conn -> this.delete((SqlConnection)conn, id));
    }

    public Future<Void> delete(SqlConnection var1, ID var2);

    default public Future<Void> deleteAll(Collection<ID> ids) {
        return this.getPool().withConnection(conn -> this.deleteAll((SqlConnection)conn, ids));
    }

    public Future<Void> deleteAll(SqlConnection var1, Collection<ID> var2);

    default public Future<Void> deleteAll() {
        return this.getPool().withConnection(this::deleteAll);
    }

    public Future<Void> deleteAll(SqlConnection var1);

    default public Future<Optional<E>> find(ID id) {
        return this.getPool().withConnection(conn -> this.find((SqlConnection)conn, id));
    }

    public Future<Optional<E>> find(SqlConnection var1, ID var2);

    default public Future<List<E>> findAll() {
        return this.getPool().withConnection(this::findAll);
    }

    public Future<List<E>> findAll(SqlConnection var1);

    default public Future<List<E>> findAll(Query<E> query) {
        return this.getPool().withConnection(conn -> this.findAll((SqlConnection)conn, query));
    }

    public Future<List<E>> findAll(SqlConnection var1, Query<E> var2);

    default public Future<Optional<E>> find(Query<E> query) {
        return this.getPool().withConnection(conn -> this.find((SqlConnection)conn, query));
    }

    public Future<Optional<E>> find(SqlConnection var1, Query<E> var2);

    default public Future<Page<E>> findAll(PageRequest pageRequest) {
        return this.findAll(QueryFactory.emptyQuery(), pageRequest);
    }

    default public Future<Page<E>> findAll(Query<E> query, PageRequest pageRequest) {
        return this.getPool().withTransaction(conn -> this.findAll((SqlConnection)conn, query, pageRequest));
    }

    default public Future<Page<E>> findAll(SqlConnection conn, PageRequest pageRequest) {
        return this.findAll(conn, QueryFactory.emptyQuery(), pageRequest);
    }

    public Future<Page<E>> findAll(SqlConnection var1, Query<E> var2, PageRequest var3);

    default public Future<Long> count(Query<E> query) {
        return this.getPool().withConnection(conn -> this.count((SqlConnection)conn, query));
    }

    public Future<Long> count(SqlConnection var1, Query<E> var2);

    default public Future<Boolean> exists(ID id) {
        return this.getPool().withConnection(conn -> this.exists((SqlConnection)conn, id));
    }

    public Future<Boolean> exists(SqlConnection var1, ID var2);

    default public Future<Boolean> exists(Query<E> query) {
        return this.getPool().withConnection(conn -> this.exists((SqlConnection)conn, query));
    }

    public Future<Boolean> exists(SqlConnection var1, Query<E> var2);

    public Pool getPool();
}

