/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.common;

import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javabase.lorenwang.tools.common.HanziToPinyinUtils;
import javabase.lorenwang.tools.common.JtlwCheckVariateUtils;

public class JtlwVariateDataParamUtils {
    private final String TAG = this.getClass().getName();
    private static volatile JtlwVariateDataParamUtils optionUtils;

    private JtlwVariateDataParamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwVariateDataParamUtils getInstance() {
        if (optionUtils != null) return optionUtils;
        Class<JtlwVariateDataParamUtils> clazz = JtlwVariateDataParamUtils.class;
        synchronized (JtlwVariateDataParamUtils.class) {
            if (optionUtils != null) return optionUtils;
            optionUtils = new JtlwVariateDataParamUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionUtils;
        }
    }

    public String paramsDoubleToNum(Double data, int num) {
        StringBuilder decimalsPattern = new StringBuilder(".");
        for (int i = 0; i < num; ++i) {
            decimalsPattern.append("0");
        }
        if (data == null || data == 0.0) {
            return "0" + decimalsPattern.toString();
        }
        DecimalFormat df = new DecimalFormat("###,###" + decimalsPattern.toString());
        if (data > 0.0 && data < 1.0) {
            return "0" + df.format(data);
        }
        return df.format(data);
    }

    public Long paramsLongToNum(Long time, Integer num) {
        if (time != null && num != null) {
            int length = String.valueOf(time).length();
            int compareTo = num.compareTo(length);
            if (compareTo == 0) {
                return time;
            }
            if (compareTo < 0) {
                return Double.valueOf((double)time.longValue() / Math.pow(10.0, length - num)).longValue();
            }
            return Double.valueOf((double)time.longValue() * Math.pow(10.0, length - num)).longValue();
        }
        return 0L;
    }

    public String clearEndZeroAndParamsForDouble(Double doubleNum, Integer maxDecimalNum) {
        String str = this.paramsDoubleToNum(doubleNum, maxDecimalNum);
        if (str.indexOf(".") > 0) {
            str = str.replaceAll("0+?$", "");
            str = str.replaceAll("[.]$", "");
        }
        return str;
    }

    public String clearStringBlank(String str) {
        if (str != null && !"".equals(str)) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            return m.replaceAll("");
        }
        return str;
    }

    public <T> List<T> paramesArrayToList(T[] arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (arrays != null) {
            list.addAll(Arrays.asList(arrays));
        }
        return list;
    }

    public <K, T> List<K> paramsHashMapKeyToArrayList(Map<K, List<T>> map) {
        ArrayList<K> list = new ArrayList<K>();
        if (map == null) {
            return list;
        }
        for (Map.Entry<K, List<T>> kListEntry : map.entrySet()) {
            list.add(kListEntry.getKey());
        }
        return list;
    }

    public long generateRandom(long min, long max) {
        return min + (long)(new Random().nextDouble() * (double)(max - min));
    }

    public char getFirstPinYin(String source) {
        if (JtlwCheckVariateUtils.getInstance().isEmpty(source)) {
            return '#';
        }
        Locale newChina = new Locale("zh", "HANS", "CN");
        if (!Arrays.asList(Collator.getAvailableLocales()).contains(Locale.CHINA) && !Arrays.asList(Collator.getAvailableLocales()).contains(Locale.CHINESE) && !Arrays.asList(Collator.getAvailableLocales()).contains(newChina) || source != null && !"".equals(source) && source.charAt(0) <= 'Z' && source.charAt(0) >= 'A' || Objects.requireNonNull(source).charAt(0) <= 'z' && source.charAt(0) >= 'a') {
            return source.length() > 0 ? source.toLowerCase().charAt(0) : (char)'#';
        }
        ArrayList<HanziToPinyinUtils.Token> tokens = HanziToPinyinUtils.getInstance().get(source);
        if (tokens == null || tokens.size() == 0) {
            return source.toLowerCase().charAt(0);
        }
        HanziToPinyinUtils.Token token = tokens.get(0);
        if (token.type == 2) {
            return token.target.toLowerCase().charAt(0);
        }
        return '#';
    }

    public String getPinYin(String input) {
        ArrayList<HanziToPinyinUtils.Token> tokens = HanziToPinyinUtils.getInstance().get(input);
        StringBuilder sb = new StringBuilder();
        if (tokens != null && tokens.size() > 0) {
            for (HanziToPinyinUtils.Token token : tokens) {
                if (2 == token.type) {
                    sb.append(token.target);
                    continue;
                }
                sb.append(token.source);
            }
        }
        return sb.toString().toLowerCase();
    }

    public int booleanToInt(Boolean value) {
        return value == null || value == false ? 0 : 1;
    }
}

