/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.common;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JtlwBeanUtil {
    private final String TAG = this.getClass().getName();
    private static volatile JtlwBeanUtil optionsInstance;

    private JtlwBeanUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwBeanUtil getInstance() {
        if (optionsInstance != null) return optionsInstance;
        Class<JtlwBeanUtil> clazz = JtlwBeanUtil.class;
        synchronized (JtlwBeanUtil.class) {
            if (optionsInstance != null) return optionsInstance;
            optionsInstance = new JtlwBeanUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionsInstance;
        }
    }

    public <T, R> R copyWithTheParameters(T origin, Class<R> target) {
        if (origin != null && target != null) {
            try {
                Map<String, Class<?>> originMap = this.getBeanFieldsAndReturnType(origin.getClass());
                Map originDataParams = this.getBeanParameters(origin);
                HashMap targetMap = new HashMap();
                for (Map.Entry<String, Class<?>> entry : this.getBeanFieldsAndReturnType(target).entrySet()) {
                    if (entry.getValue() == null || originDataParams.get(entry.getKey()) == null || !entry.getValue().getName().equals(originMap.get(entry.getKey()).getName())) continue;
                    targetMap.put(entry.getKey(), originDataParams.get(entry.getKey()));
                }
                Gson gson = new Gson();
                return (R)gson.fromJson(gson.toJson(targetMap), target);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public <T, R> R copyWithTheParameters(T origin, R target, boolean filterNull) {
        if (origin != null && target != null) {
            try {
                Map<String, Class<?>> originMap = this.getBeanFieldsAndReturnType(origin.getClass());
                Map originDataParams = this.getBeanParameters(origin);
                Map targetDataParams = this.getBeanParameters(target);
                for (Map.Entry<String, Class<?>> entry : this.getBeanFieldsAndReturnType(target.getClass()).entrySet()) {
                    if (entry.getValue() == null || originDataParams.get(entry.getKey()) == null || !entry.getValue().getName().equals(originMap.get(entry.getKey()).getName())) continue;
                    Object value = originDataParams.get(entry.getKey());
                    if (value == null) {
                        if (!filterNull) continue;
                        targetDataParams.put(entry.getKey(), null);
                        continue;
                    }
                    targetDataParams.put(entry.getKey(), value);
                }
                Gson gson = new Gson();
                return (R)gson.fromJson(gson.toJson((Object)targetDataParams), target.getClass());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public <T, R> R copyWithTheParameters(T origin, R target) {
        return this.copyWithTheParameters(origin, target, false);
    }

    public <T, R> Collection<R> copyWithTheParameters(Collection<T> originList, R target, boolean filterNull) {
        ArrayList<R> list = new ArrayList<R>();
        for (T item : originList) {
            R data = this.copyWithTheParameters(item, target, filterNull);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    public <T, R> Collection<R> copyWithTheParameters(Collection<T> originList, Class<R> target) {
        ArrayList<Class<R>> list = new ArrayList<Class<R>>();
        for (T item : originList) {
            Class<R> data = this.copyWithTheParameters(item, (R)target);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    public <T> Map getBeanParameters(T data) {
        if (data != null) {
            try {
                Gson gson = new Gson();
                String json = gson.toJson(data);
                if (json != null) {
                    return (Map)gson.fromJson(json, Map.class);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public <T> Map<String, Class<?>> getBeanFieldsAndReturnType(Class<T> beanClass) {
        if (beanClass != null) {
            HashMap map = new HashMap();
            for (Field item : beanClass.getDeclaredFields()) {
                map.put(item.getName(), item.getType());
            }
            return map;
        }
        return null;
    }
}

