/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.thread;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javabase.lorenwang.tools.common.JtlwDateTimeUtils;
import javabase.lorenwang.tools.thread.CountDownCallback;

public class JtlwTimingTaskUtils {
    private final String TAG = this.getClass().getName();
    private static volatile JtlwTimingTaskUtils optionsInstance;
    private final ScheduledThreadPoolExecutor threadPoolExecutor;
    private final Map<Integer, Runnable> TIMING_TASK_MAP = new ConcurrentHashMap<Integer, Runnable>();
    private final Map<Integer, ScheduledFuture> TIMING_TASK_MAP_SCHEDULED = new ConcurrentHashMap<Integer, ScheduledFuture>();

    private JtlwTimingTaskUtils() {
        this.threadPoolExecutor = new ScheduledThreadPoolExecutor(1, Thread::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwTimingTaskUtils getInstance() {
        if (optionsInstance != null) return optionsInstance;
        Class<JtlwTimingTaskUtils> clazz = JtlwTimingTaskUtils.class;
        synchronized (JtlwTimingTaskUtils.class) {
            if (optionsInstance != null) return optionsInstance;
            optionsInstance = new JtlwTimingTaskUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionsInstance;
        }
    }

    public void schedule(int taskId, Runnable runnable, long delay) {
        if (runnable == null) {
            return;
        }
        this.cancelTimingTask(taskId);
        ScheduledFuture<?> schedule = this.threadPoolExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        this.TIMING_TASK_MAP.put(taskId, runnable);
        this.TIMING_TASK_MAP_SCHEDULED.put(taskId, schedule);
    }

    public void schedule(int taskId, Runnable runnable, long delay, long period) {
        if (runnable == null) {
            return;
        }
        this.cancelTimingTask(taskId);
        ScheduledFuture<?> schedule = this.threadPoolExecutor.scheduleAtFixedRate(runnable, delay, period, TimeUnit.MILLISECONDS);
        this.TIMING_TASK_MAP.put(taskId, runnable);
        this.TIMING_TASK_MAP_SCHEDULED.put(taskId, schedule);
    }

    public void countDownTask(final int taskId, final CountDownCallback countDownCallback, final long sumTime, long period) {
        if (countDownCallback == null) {
            return;
        }
        this.schedule(taskId, new Runnable(){
            private Long nowTime = null;
            private final Long START_TIME = JtlwDateTimeUtils.getInstance().getMillisecond();

            @Override
            public void run() {
                this.nowTime = sumTime - (JtlwDateTimeUtils.getInstance().getMillisecond() - this.START_TIME);
                if (this.nowTime <= 0L) {
                    JtlwTimingTaskUtils.this.cancelTimingTask(taskId);
                    countDownCallback.finish();
                } else {
                    countDownCallback.countDownTime(sumTime, this.nowTime);
                }
            }
        }, 0L, period);
    }

    public void cancelTimingTask(int taskId) {
        ScheduledFuture scheduledFuture;
        Runnable task = this.TIMING_TASK_MAP.get(taskId);
        if (task != null) {
            this.threadPoolExecutor.remove(task);
            this.threadPoolExecutor.purge();
            this.TIMING_TASK_MAP.remove(taskId);
            task = null;
        }
        if ((scheduledFuture = this.TIMING_TASK_MAP_SCHEDULED.get(taskId)) != null) {
            scheduledFuture.cancel(true);
            this.TIMING_TASK_MAP_SCHEDULED.remove(taskId);
        }
    }
}

