/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.common;

import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import javabase.lorenwang.tools.JtlwLogUtils;
import javabase.lorenwang.tools.common.JtlwDateTimeUtils;
import org.jetbrains.annotations.NotNull;

public class JtlwCheckVariateUtils {
    private final String TAG = this.getClass().getName();
    private static volatile JtlwCheckVariateUtils optionUtils;

    private JtlwCheckVariateUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwCheckVariateUtils getInstance() {
        if (optionUtils != null) return optionUtils;
        Class<JtlwCheckVariateUtils> clazz = JtlwCheckVariateUtils.class;
        synchronized (JtlwCheckVariateUtils.class) {
            if (optionUtils != null) return optionUtils;
            optionUtils = new JtlwCheckVariateUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionUtils;
        }
    }

    public <T> boolean isEmpty(T str) {
        if (str instanceof String) {
            return "".equals(str);
        }
        return str == null;
    }

    public <T> boolean isNotEmpty(T str) {
        return !this.isEmpty(str);
    }

    public boolean isHaveEmpty(Object ... objects) {
        for (Object object : objects) {
            if (!this.isEmpty(object)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String str, String patternStr) {
        if (this.isEmpty(str)) {
            return false;
        }
        return str.matches(patternStr);
    }

    public boolean isInteger(String str) {
        if (this.isEmpty(str)) {
            return false;
        }
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLong(String str) {
        if (this.isEmpty(str)) {
            return false;
        }
        try {
            Long.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDouble(String str) {
        if (this.isEmpty(str)) {
            return false;
        }
        try {
            Double.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isOverLength(String str, int len) {
        if (this.isEmpty(str)) {
            return false;
        }
        return str.length() > len;
    }

    public boolean isOverLength(Double d, int len) {
        if (d == null) {
            return false;
        }
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setGroupingUsed(false);
        formatter.setMaximumFractionDigits(0);
        formatter.setMinimumFractionDigits(0);
        return formatter.format(d).length() > len;
    }

    public <T> boolean isInList(T item, List<T> list) {
        for (T listItem : list) {
            if (!item.equals(listItem)) continue;
            return true;
        }
        return false;
    }

    public <T> boolean isInArray(T item, T[] list) {
        for (T listItem : list) {
            if (!item.equals(listItem)) continue;
            return true;
        }
        return false;
    }

    public boolean checkIsImage(String path) {
        if (path != null && path.length() > 4) {
            String start = path.toLowerCase().substring(path.length() - 4);
            if (start.contains(".jpg") || start.contains(".png") || start.contains(".bmp") || start.contains(".gif") || start.contains(".psd") || start.contains(".swf") || start.contains(".svg") || start.contains(".pcx") || start.contains(".dxf") || start.contains(".wmf") || start.contains(".emf") || start.contains(".lic") || start.contains(".eps") || start.contains(".tga")) {
                return true;
            }
            if (path.length() > 5) {
                start = path.toLowerCase().substring(path.length() - 5);
                return start.contains(".jpeg") || start.contains(".tiff") || start.contains(".heic");
            }
        }
        return false;
    }

    public boolean checkIsVideo(String path) {
        if (path != null && path.length() > 4) {
            return path.toLowerCase().substring(path.length() - 4).contains(".mp4");
        }
        return false;
    }

    public boolean checkFileIsExit(String filePath) {
        if (this.isEmpty(filePath)) {
            JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u67e5\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u901a\u8fc7\u68c0\u6d4b");
            return false;
        }
        File file = new File(filePath);
        boolean isExit = false;
        if (file.isDirectory()) {
            JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u67e5\u6587\u4ef6\u4e3a\u7a7a\u6216\u88ab\u68c0\u6d4b\u7684\u5730\u5740\u4e3a\u6587\u4ef6\u5939\uff0c\u4e0d\u901a\u8fc7\u68c0\u6d4b");
            return false;
        }
        if (file.exists()) {
            isExit = true;
            JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u67e5\u6587\u4ef6\u5b58\u5728");
        } else {
            JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u67e5\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return isExit;
    }

    public boolean checkFileIsImage(String filePath) {
        if (!this.isEmpty(filePath)) {
            if (this.checkIsImage(filePath.toLowerCase())) {
                JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u6d4b\u5730\u5740\u4e3a\u56fe\u7247\u5730\u5740\uff1a");
                return true;
            }
            JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u6d4b\u5730\u5740\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e3a\u975e\u56fe\u7247");
            return false;
        }
        JtlwLogUtils.logUtils.logI(this.TAG, "\u88ab\u68c0\u6d4b\u5730\u5740\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e3a\u975e\u56fe\u7247");
        return false;
    }

    public int checkChineseIdCard(@NotNull String idCard) {
        if (this.isEmpty(idCard) || !idCard.matches("(^[1-9]\\d{5}[123]\\d{3}(10|11|12|0[1-9])(0[1-9]|[12]\\d|3[01])(00[1-9]|0[1-9]\\d|[1-9]\\d{2})(\\d|x|X)$)|(^[1-9]\\d{5}[3456789]\\d(10|11|12|0[1-9])(0[1-9]|[12]\\d|3[01])(00[1-9]|0[1-9]\\d|[1-9]\\d{2})$)")) {
            return 1;
        }
        String[] cityCodes = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
        String city = idCard.substring(0, 2);
        boolean haveCode = false;
        for (String cityCode : cityCodes) {
            if (!cityCode.equals(city)) continue;
            haveCode = true;
            break;
        }
        if (!haveCode) {
            return 2;
        }
        if (idCard.length() == 18) {
            Integer[] factor = new Integer[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
            Character[] parity = new Character[]{Character.valueOf('1'), Character.valueOf('0'), Character.valueOf('x'), Character.valueOf('9'), Character.valueOf('8'), Character.valueOf('7'), Character.valueOf('6'), Character.valueOf('5'), Character.valueOf('4'), Character.valueOf('3'), Character.valueOf('2')};
            int sum = 0;
            char[] chars = idCard.toCharArray();
            for (int i = 0; i < 17; ++i) {
                int ai = Integer.parseInt(String.valueOf(chars[i]));
                int wi = factor[i];
                sum += ai * wi;
            }
            Character last = parity[sum % 11];
            if (last.compareTo(Character.valueOf(String.valueOf(idCard.charAt(17)).toLowerCase().charAt(0))) != 0) {
                return 3;
            }
        }
        return 0;
    }

    public boolean checkAgeMoreThanLimitByIdCard(@NotNull String idCard, int limit, boolean judgeYear) {
        if (this.checkChineseIdCard(idCard) == 0) {
            int idTime = 0;
            int currentTime = Integer.parseInt(JtlwDateTimeUtils.getInstance().getFormatDateNowTime(JtlwDateTimeUtils.YEAR_PATTERN));
            if (idCard.length() == 18) {
                idTime = Integer.parseInt(idCard.substring(6, 10));
            } else if (idCard.length() == 15) {
                idTime = Integer.parseInt("19" + idCard.substring(6, 8));
            }
            if (judgeYear) {
                return currentTime - idTime >= limit;
            }
            if (currentTime - idTime > limit) {
                return true;
            }
            if (currentTime - idTime < limit) {
                return false;
            }
            idTime = 0;
            currentTime = Integer.parseInt(JtlwDateTimeUtils.getInstance().getFormatDateNowTime(JtlwDateTimeUtils.MONTH_PATTERN));
            if (idCard.length() == 18) {
                idTime = Integer.parseInt(idCard.substring(10, 12));
            } else if (idCard.length() == 15) {
                idTime = Integer.parseInt(idCard.substring(8, 10));
            }
            if (currentTime - idTime > 0) {
                return true;
            }
            if (currentTime - idTime < 0) {
                return false;
            }
            idTime = 0;
            currentTime = Integer.parseInt(JtlwDateTimeUtils.getInstance().getFormatDateNowTime(JtlwDateTimeUtils.DAY_PATTERN));
            if (idCard.length() == 18) {
                idTime = Integer.parseInt(idCard.substring(12, 14));
            } else if (idCard.length() == 15) {
                idTime = Integer.parseInt(idCard.substring(10, 12));
            }
            return currentTime - idTime >= 0;
        }
        return false;
    }
}

