/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.dataConversion;

import javabase.lorenwang.tools.JtlwMatchesRegularCommon;
import org.jetbrains.annotations.NotNull;

public class JtlwCodeConversionUtil {
    private final String TAG = this.getClass().getName();
    private static volatile JtlwCodeConversionUtil optionsInstance;

    private JtlwCodeConversionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwCodeConversionUtil getInstance() {
        if (optionsInstance != null) return optionsInstance;
        Class<JtlwCodeConversionUtil> clazz = JtlwCodeConversionUtil.class;
        synchronized (JtlwCodeConversionUtil.class) {
            if (optionsInstance != null) return optionsInstance;
            optionsInstance = new JtlwCodeConversionUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionsInstance;
        }
    }

    public String chineseToUnicode(@NotNull String dataStr) {
        StringBuilder result = new StringBuilder();
        for (char cha : dataStr.toCharArray()) {
            String item = Integer.toHexString(cha);
            result.append("\\u");
            if (item.length() <= 2) {
                result.append("00");
            }
            result.append(item);
        }
        return result.toString();
    }

    public String unicodeToChinese(@NotNull String dataStr) {
        boolean start = false;
        for (String code : JtlwMatchesRegularCommon.getRegexResultList(dataStr, "\\\\(u|U)[0-9a-zA-Z]{4}", false)) {
            dataStr = dataStr.replace(code, String.valueOf((char)Integer.parseInt(code.substring(2), 16)));
        }
        return dataStr;
    }
}

