/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.dataConversion;

import javabase.lorenwang.tools.common.JtlwCheckVariateUtils;

public class JtlwDecimalConvertUtils {
    private final char[] ALPHABET_LOWER_CASE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private final char[] ALPHABET_UPPER_CASE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private final String TAG = this.getClass().getName();
    private static volatile JtlwDecimalConvertUtils optionUtils;

    private JtlwDecimalConvertUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwDecimalConvertUtils getInstance() {
        if (optionUtils != null) return optionUtils;
        Class<JtlwDecimalConvertUtils> clazz = JtlwDecimalConvertUtils.class;
        synchronized (JtlwDecimalConvertUtils.class) {
            if (optionUtils != null) return optionUtils;
            optionUtils = new JtlwDecimalConvertUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionUtils;
        }
    }

    public Integer decimal10To2(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            String result = this.decimalToAssign(num, 2, null);
            if (JtlwCheckVariateUtils.getInstance().isInteger(result)) {
                return Integer.valueOf(result);
            }
            return null;
        }
        return null;
    }

    public Integer decimal10To8(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            String result = this.decimalToAssign(num, 8, null);
            if (JtlwCheckVariateUtils.getInstance().isInteger(result)) {
                return Integer.valueOf(result);
            }
            return null;
        }
        return null;
    }

    public String decimal10To16(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            return this.decimalToAssign(num, 16, null);
        }
        return null;
    }

    public String decimal10To32(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            return this.decimalToAssign(num, 32, null);
        }
        return null;
    }

    public String decimal10To64(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            return this.decimalToAssign(num, 64, null);
        }
        return null;
    }

    public Integer decimal8To2(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            char[] chars = String.valueOf(num).toCharArray();
            StringBuilder result = new StringBuilder();
            for (char item : chars) {
                result.append(this.decimalToAssign(item - 48, 2, 3));
            }
            if (JtlwCheckVariateUtils.getInstance().isInteger(result.toString())) {
                return Integer.valueOf(result.toString());
            }
            return null;
        }
        return null;
    }

    public Integer decimal8To10(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            char[] chars = String.valueOf(num).toCharArray();
            int length = chars.length;
            if (length == 0) {
                return null;
            }
            int result = 0;
            for (int i = 0; i < length; ++i) {
                result = (chars[i] - 48) * (int)Math.pow(8.0, length - i - 1) + result;
            }
            return result;
        }
        return null;
    }

    public String decimal8To16(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            num = this.decimal8To10(num);
            return this.decimal10To16(num);
        }
        return null;
    }

    public String decimal8To32(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            num = this.decimal8To10(num);
            return this.decimal10To32(num);
        }
        return null;
    }

    public String decimal8To64(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            num = this.decimal8To10(num);
            return this.decimal10To64(num);
        }
        return null;
    }

    public Integer decimal2To8(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            String result = this.decimal2ToOther(num, 8, 3);
            if (result != null && JtlwCheckVariateUtils.getInstance().isInteger(result)) {
                return Integer.valueOf(result);
            }
            return null;
        }
        return null;
    }

    public Integer decimal2To10(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            String result = this.decimal2ToOther(num, 10, null);
            if (result != null && JtlwCheckVariateUtils.getInstance().isInteger(result)) {
                return Integer.valueOf(result);
            }
            return null;
        }
        return null;
    }

    public String decimal2To16(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            return this.decimal2ToOther(num, 16, 4);
        }
        return null;
    }

    public String decimal2To32(Integer num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            return this.decimal2ToOther(num, 32, 5);
        }
        return null;
    }

    public Integer decimal16To2(String num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            char[] chars = (num = num.toLowerCase()).toCharArray();
            int length = chars.length;
            if (length == 0) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            for (char aChar : chars) {
                Character character = Character.valueOf(aChar);
                if (character.compareTo(Character.valueOf('0')) >= 0 && character.compareTo(Character.valueOf('9')) <= 0) {
                    result.insert(0, this.decimalToAssign(character.charValue() - 48, 2, 4));
                    continue;
                }
                if (character.compareTo(Character.valueOf('a')) < 0 || character.compareTo(Character.valueOf('f')) > 0) continue;
                result.insert(0, this.decimalToAssign(character.charValue() - 87, 2, 4));
            }
            if (JtlwCheckVariateUtils.getInstance().isInteger(result.toString())) {
                return Integer.valueOf(result.toString());
            }
        }
        return null;
    }

    public Integer decimal16To8(String num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            Integer integer = this.decimal16To2(num);
            return this.decimal2To8(integer);
        }
        return null;
    }

    public Integer decimal16To10(String num) {
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(num)) {
            char[] chars = (num = num.toLowerCase()).toCharArray();
            int length = chars.length;
            if (length == 0) {
                return null;
            }
            int result = 0;
            for (int i = 0; i < length; ++i) {
                Character character = Character.valueOf(chars[i]);
                if (character.compareTo(Character.valueOf('0')) >= 0 && character.compareTo(Character.valueOf('9')) <= 0) {
                    result += (character.charValue() - 48) * (int)Math.pow(16.0, i);
                    continue;
                }
                if (character.compareTo(Character.valueOf('a')) < 0 || character.compareTo(Character.valueOf('f')) > 0) continue;
                result += (character.charValue() - 87) * (int)Math.pow(16.0, i);
            }
            return result;
        }
        return null;
    }

    private String decimalToAssign(int num, int assign, Integer minLength) {
        StringBuilder result = new StringBuilder();
        while (num >= assign) {
            int remainder = num % assign;
            if (remainder >= 10) {
                result.insert(0, this.getAssignDecimalStr(assign, remainder - 10));
            } else {
                result.insert(0, remainder);
            }
            num /= assign;
        }
        if (num >= 10) {
            result.insert(0, this.getAssignDecimalStr(assign, num - 10));
        } else {
            result.insert(0, num);
        }
        if (minLength == null) {
            return result.toString();
        }
        int diff = result.length() - minLength;
        if (diff < 0) {
            diff = Math.abs(diff);
            for (int i = 0; i < diff; ++i) {
                result.insert(0, "0");
            }
        }
        return result.toString();
    }

    private String decimal2ToOther(int num, int assign, Integer splitNum) {
        char[] chars = String.valueOf(num).toCharArray();
        int length = chars.length;
        if (length == 0) {
            return null;
        }
        if (splitNum == null) {
            splitNum = length;
        }
        StringBuilder result = new StringBuilder();
        int value = 0;
        for (int i = length - 1; i >= 0; --i) {
            int posi = (length - i - 1) % splitNum;
            value += (chars[i] - 48) * (int)Math.pow(2.0, posi);
            if (posi == splitNum - 1) {
                if (value >= 10) {
                    result.insert(0, this.getAssignDecimalStr(assign, value - 10));
                } else {
                    result.insert(0, value);
                }
                value = 0;
                continue;
            }
            if (i != 0) continue;
            if (value >= 10) {
                result.insert(0, this.getAssignDecimalStr(assign, value - 10));
            } else {
                result.insert(0, value);
            }
            value = 0;
        }
        return result.toString();
    }

    private String getAssignDecimalStr(int assign, int strPosition) {
        switch (assign) {
            case 10: {
                return String.valueOf(strPosition + 10);
            }
            case 32: {
                Character result = Character.valueOf(this.ALPHABET_UPPER_CASE[strPosition]);
                if (result.compareTo(Character.valueOf('I')) <= 0) {
                    return result.toString();
                }
                Character c = result;
                Character c2 = result = Character.valueOf((char)(result.charValue() + '\u0001'));
                if (result.compareTo(Character.valueOf('L')) <= 0) {
                    return result.toString();
                }
                c = result;
                c2 = result = Character.valueOf((char)(result.charValue() + '\u0001'));
                if (result.compareTo(Character.valueOf('O')) <= 0) {
                    return result.toString();
                }
                c = result;
                c2 = result = Character.valueOf((char)(result.charValue() + '\u0001'));
                if (result.compareTo(Character.valueOf('U')) <= 0) {
                    return result.toString();
                }
                c = result;
                c2 = result = Character.valueOf((char)(result.charValue() + '\u0001'));
                return result.toString();
            }
            case 64: {
                if (strPosition > 26) {
                    return String.valueOf(this.ALPHABET_UPPER_CASE[strPosition - 26]);
                }
                return String.valueOf(this.ALPHABET_LOWER_CASE[strPosition]);
            }
        }
        return String.valueOf(this.ALPHABET_LOWER_CASE[strPosition]);
    }
}

