/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javabase.lorenwang.tools.JtlwLogUtils;
import javabase.lorenwang.tools.common.JtlwCheckVariateUtils;
import javabase.lorenwang.tools.common.JtlwCommonUtils;
import javabase.lorenwang.tools.common.JtlwDateTimeUtils;
import javabase.lorenwang.tools.common.JtlwVariateDataParamUtils;
import javabase.lorenwang.tools.enums.JtlwFileTypeEnum;
import javabase.lorenwang.tools.file.EncodingDetect;
import org.jetbrains.annotations.NotNull;

public class JtlwFileOptionUtils {
    private final String TAG = "FileOptionUtils";
    private static volatile JtlwFileOptionUtils baseUtils;
    private ConcurrentLinkedQueue<File> fileOptionsLinkedQueue;
    private final int BUFFER_SIZE = 1024;
    private final List<JtlwFileTypeEnum> allDocFileTypeEnum;
    private final List<JtlwFileTypeEnum> allImageFileTypeEnum = new ArrayList<JtlwFileTypeEnum>();

    public JtlwFileOptionUtils() {
        this.allDocFileTypeEnum = new ArrayList<JtlwFileTypeEnum>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JtlwFileOptionUtils getInstance() {
        Class<JtlwFileOptionUtils> clazz = JtlwFileOptionUtils.class;
        synchronized (JtlwFileOptionUtils.class) {
            if (baseUtils == null) {
                baseUtils = new JtlwFileOptionUtils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return baseUtils;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readImageFileGetBytes(Boolean isCheckFile, String filePath) {
        if (isCheckFile.booleanValue() && !JtlwCheckVariateUtils.getInstance().checkFileIsExit(filePath) && !JtlwCheckVariateUtils.getInstance().checkFileIsImage(filePath)) {
            return null;
        }
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            int length;
            fileInputStream = new FileInputStream(filePath);
            outputStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[2048];
            while ((length = fileInputStream.read(bytes)) > 0) {
                outputStream.write(bytes, 0, length);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", "\u56fe\u7247\u8bfb\u53d6\u5f02\u5e38");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public byte[] readBytes(String path) {
        try {
            File file = new File(path);
            return this.readBytes(file);
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] readBytes(File file) {
        FileInputStream fis;
        block17: {
            fis = null;
            if (file.exists()) break block17;
            byte[] byArray = null;
            try {
                assert (fis != null);
                fis.close();
            }
            catch (Exception e) {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
            }
            return byArray;
        }
        fis = new FileInputStream(file);
        byte[] byArray = this.readBytes(fis);
        try {
            assert (fis != null);
            fis.close();
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                try {
                    assert (fis != null);
                    fis.close();
                }
                catch (Exception e2) {
                    JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e2) ? "" : e2.getMessage());
                }
                throw throwable;
            }
            try {
                assert (fis != null);
                fis.close();
            }
            catch (Exception e3) {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e3) ? "" : e3.getMessage());
            }
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] readBytes(InputStream inputStream) {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = inputStream.read(buffer);
        while (length != -1) {
            baos.write(buffer, 0, length);
            baos.flush();
            length = inputStream.read(buffer);
        }
        byte[] byArray = baos.toByteArray();
        try {
            assert (baos != null);
            baos.close();
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                try {
                    assert (baos != null);
                    baos.close();
                }
                catch (Exception e2) {
                    JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e2) ? "" : e2.getMessage());
                }
                throw throwable;
            }
            try {
                assert (baos != null);
                baos.close();
            }
            catch (Exception e3) {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e3) ? "" : e3.getMessage());
            }
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Boolean writeToFile(File file, InputStream inputStream, boolean append) {
        if (!append) {
            this.deleteFile(file.getAbsolutePath());
        }
        this.createDirectory(file.getAbsolutePath(), true);
        FileOutputStream fos = null;
        fos = new FileOutputStream(file, append);
        byte[] buffer = new byte[1024];
        int length = inputStream.read(buffer);
        while (length != -1) {
            fos.write(buffer, 0, length);
            fos.flush();
            length = inputStream.read(buffer);
        }
        Boolean bl = true;
        try {
            assert (fos != null);
            fos.close();
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
        }
        return bl;
        catch (Exception e) {
            Boolean bl2;
            try {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    assert (fos != null);
                    fos.close();
                }
                catch (Exception e2) {
                    JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e2) ? "" : e2.getMessage());
                }
                throw throwable;
            }
            try {
                assert (fos != null);
                fos.close();
            }
            catch (Exception e3) {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e3) ? "" : e3.getMessage());
            }
            return bl2;
        }
    }

    public boolean writeToFile(File file, String text) {
        return this.writeToFile(file, text, "UTF-8", false);
    }

    public Boolean writeToFile(File file, String text, String encoding, boolean append) {
        try {
            return this.writeToFile(file, new ByteArrayInputStream(text.getBytes(encoding)), append);
        }
        catch (UnsupportedEncodingException e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
            return false;
        }
    }

    public boolean writeToFile(File file, byte[] buffer) {
        return this.writeToFile(file, buffer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean writeToFile(File file, byte[] buffer, boolean append) {
        FileOutputStream fos = null;
        this.deleteFile(file.getAbsolutePath());
        this.createDirectory(file.getAbsolutePath(), true);
        fos = new FileOutputStream(file, append);
        fos.write(buffer);
        boolean bl = true;
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            try {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e) ? "" : e.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e2) ? "" : e2.getMessage());
                }
                throw throwable;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e3) {
                JtlwLogUtils.logUtils.logE("FileOptionUtils", JtlwCheckVariateUtils.getInstance().isEmpty(e3) ? "" : e3.getMessage());
            }
            return bl2;
        }
    }

    public String paramsFileSize(Long fileSize) {
        if (fileSize.compareTo(1024L) < 0) {
            return JtlwVariateDataParamUtils.getInstance().paramsDoubleToNum(fileSize.doubleValue(), 2) + "B";
        }
        if (fileSize.compareTo((long)Math.pow(1024.0, 2.0)) < 0) {
            return JtlwVariateDataParamUtils.getInstance().paramsDoubleToNum((double)fileSize.longValue() * 1.0 / 1024.0, 2) + "KB";
        }
        if (fileSize.compareTo((long)Math.pow(1024.0, 3.0)) < 0) {
            return JtlwVariateDataParamUtils.getInstance().paramsDoubleToNum((double)fileSize.longValue() * 1.0 / 1024.0 / 1024.0, 2) + "MB";
        }
        if (fileSize.compareTo((long)Math.pow(1024.0, 4.0)) < 0) {
            return JtlwVariateDataParamUtils.getInstance().paramsDoubleToNum((double)fileSize.longValue() * 1.0 / 1024.0 / 1024.0 / 1024.0, 2) + "GB";
        }
        return "0B";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean copyFile(String oldPath, String newPath) {
        FileOutputStream fs = null;
        try {
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length = inStream.read(buffer);
                while (length != -1) {
                    fs.write(buffer, 0, length);
                    fs.flush();
                    length = inStream.read(buffer);
                }
                inStream.close();
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean copyFileDir(String oldPath, String newPath) {
        if (JtlwCheckVariateUtils.getInstance().isNotEmpty(oldPath) && JtlwCheckVariateUtils.getInstance().isNotEmpty(newPath)) {
            File oldFile = new File(oldPath);
            File newFile = new File(newPath);
            if (!oldFile.exists() || newFile.exists()) {
                return false;
            }
            this.createDirectory(newPath, oldFile.isFile());
            if (oldFile.isFile()) {
                return this.copyFile(oldPath, newPath);
            }
            boolean status = true;
            for (File file : oldFile.listFiles()) {
                status = file.isFile() ? status && this.copyFile(file.getAbsolutePath(), newFile.getAbsolutePath() + "/" + file.getName()) != false : status && this.copyFileDir(file.getAbsolutePath(), newFile.getAbsolutePath() + "/" + file.getName());
            }
            return status;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compressToZip(@NotNull String sourcePath, @NotNull String outPutPath) {
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            JtlwLogUtils.logUtils.logI("FileOptionUtils", sourcePath + "-zip\u538b\u7f29\uff1a\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
            return false;
        }
        File outputFile = new File(outPutPath);
        if (outputFile.exists()) {
            JtlwLogUtils.logUtils.logI("FileOptionUtils", sourcePath + "-zip\u538b\u7f29\uff1a\u8f93\u51fa\u76ee\u6807\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u538b\u7f29");
            return false;
        }
        FileOutputStream outputStream = null;
        ZipOutputStream zos = null;
        try {
            JtlwLogUtils.logUtils.logI("FileOptionUtils", sourcePath + "-zip\u538b\u7f29\uff1a\u5f00\u59cb\u8fdb\u884c\u538b\u7f29:" + JtlwDateTimeUtils.getInstance().getMillisecond());
            outputStream = new FileOutputStream(new File(outPutPath));
            zos = new ZipOutputStream(outputStream);
            boolean status = this.compressToZip(sourceFile, zos, sourceFile.getName());
            if (status) {
                JtlwLogUtils.logUtils.logI("FileOptionUtils", sourcePath + "-zip\u538b\u7f29\uff1a\u538b\u7f29\u5b8c\u6210:" + JtlwDateTimeUtils.getInstance().getMillisecond());
            } else {
                JtlwLogUtils.logUtils.logI("FileOptionUtils", sourcePath + "-zip\u538b\u7f29\uff1a\u538b\u7f29\u5931\u8d25");
            }
            boolean bl = status;
            return bl;
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logI("FileOptionUtils", sourcePath + "-zip\u538b\u7f29\uff1a\u538b\u7f29\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + (e.getMessage() != null ? e.getMessage() : ""));
            boolean bl = false;
            return bl;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean compressToZip(File sourceFile, ZipOutputStream zos, String saveFileName) {
        try {
            byte[] buf = new byte[2048];
            if (sourceFile.isFile()) {
                int len;
                zos.putNextEntry(new ZipEntry(saveFileName));
                FileInputStream in = new FileInputStream(sourceFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            } else {
                File[] listFiles = sourceFile.listFiles();
                if (listFiles == null || listFiles.length == 0) {
                    zos.putNextEntry(new ZipEntry(saveFileName + "/"));
                    zos.closeEntry();
                } else {
                    boolean status = true;
                    for (File file : listFiles) {
                        status = status && this.compressToZip(file, zos, saveFileName + "/" + file.getName());
                    }
                    return status;
                }
            }
            return true;
        }
        catch (Exception e) {
            JtlwLogUtils.logUtils.logI("FileOptionUtils", sourceFile.getAbsolutePath() + "-zip\u538b\u7f29\uff1a\u538b\u7f29\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + (e.getMessage() != null ? e.getMessage() : ""));
            return false;
        }
    }

    public boolean deleteFile(String path) {
        boolean result = false;
        File file = new File(path);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }

    public Long getFileSize(File file, String filtrationDir) {
        long fileSize = 0L;
        if (file.isFile() && file.exists()) {
            fileSize += file.length();
        } else if (file.exists()) {
            File[] files = file.listFiles();
            assert (files != null);
            for (File file1 : files) {
                if (file1.isFile()) {
                    fileSize += file1.length();
                    continue;
                }
                if (!file.isDirectory() && filtrationDir != null && filtrationDir.equals(file.getAbsolutePath())) continue;
                fileSize += this.getFileSize(file1, filtrationDir).longValue();
            }
        }
        return fileSize;
    }

    public Boolean deleteDirectory(String filePath) {
        File dirFile;
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(dirFile = new File(filePath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            File childFile;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n && (flag = (childFile = fileArray[i]).isFile() ? this.deleteFile(childFile.getAbsolutePath()) : this.deleteDirectory(childFile.getAbsolutePath()).booleanValue()); ++i) {
            }
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public String getLastDirectoryName(String absolutePath) {
        if (absolutePath == null) {
            return "";
        }
        String path = absolutePath.intern();
        File file = new File(path);
        if (file.isFile()) {
            path = file.getParentFile().getAbsolutePath();
        }
        if (path.contains("/")) {
            while ("/".equals(path.substring(path.lastIndexOf("/")).intern())) {
                path = path.substring(0, path.length() - 1);
            }
            path = path.substring(path.lastIndexOf("/") + 1);
        }
        return path;
    }

    public boolean createDirectory(String path, boolean nowPathIsFile) {
        if (JtlwCheckVariateUtils.getInstance().isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        if (file.exists()) {
            return true;
        }
        if (nowPathIsFile) {
            file = file.getParentFile();
        }
        return file.mkdirs();
    }

    public List<File> getFileListForMatchRecursionScan(String scanPath, String matchRegular) {
        File file;
        ArrayList<File> list = new ArrayList<File>();
        if (!JtlwCheckVariateUtils.getInstance().isHaveEmpty(scanPath, matchRegular) && (file = new File(scanPath)).exists()) {
            File[] files = file.listFiles();
            assert (files != null);
            for (File childFile : files) {
                if (childFile == null) continue;
                if (childFile.isDirectory()) {
                    if (file.getName().matches("^\\..*")) continue;
                    list.addAll(this.getFileListForMatchRecursionScan(childFile.getAbsolutePath(), matchRegular));
                    continue;
                }
                if (!childFile.isFile() || !childFile.getName().matches(matchRegular)) continue;
                list.add(childFile);
            }
        }
        return list;
    }

    public synchronized List<File> getFileListForMatchLinkedQueueScan(String scanPath, String matchRegular) {
        ArrayList<File> list = new ArrayList<File>();
        if (!JtlwCheckVariateUtils.getInstance().isHaveEmpty(scanPath, matchRegular)) {
            File file;
            if (this.fileOptionsLinkedQueue == null) {
                this.fileOptionsLinkedQueue = new ConcurrentLinkedQueue();
            }
            if ((file = new File(scanPath)).exists() && !file.isFile()) {
                File[] files = file.listFiles((file1, s) -> !file1.getName().trim().startsWith("."));
                ArrayList<Runnable> runnableList = new ArrayList<Runnable>();
                Semaphore semaphore = new Semaphore(100);
                if (files != null) {
                    for (File f : files) {
                        if (f.isDirectory()) {
                            this.fileOptionsLinkedQueue.offer(f);
                            Runnable runnable = () -> list.addAll(this.startFileScan(matchRegular));
                            runnableList.add(runnable);
                            continue;
                        }
                        if (!f.isFile() || !f.getName().matches(matchRegular)) continue;
                        list.add(f);
                    }
                }
                ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                for (Runnable runnable : runnableList) {
                    executorService.submit(runnable);
                }
                executorService.shutdown();
                while (!executorService.isTerminated()) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.fileOptionsLinkedQueue = null;
        return list;
    }

    private List<File> startFileScan(String matchRegular) {
        ArrayList<File> list = new ArrayList<File>();
        while (!this.fileOptionsLinkedQueue.isEmpty()) {
            File tmpFile = this.fileOptionsLinkedQueue.poll();
            File[] fileArray = tmpFile.listFiles((file, s) -> !file.getName().trim().startsWith("."));
            assert (fileArray != null);
            for (File f : fileArray) {
                if (f == null) continue;
                if (f.isDirectory()) {
                    this.fileOptionsLinkedQueue.offer(f);
                    continue;
                }
                if (!f.getName().matches(matchRegular)) continue;
                list.add(f);
            }
        }
        return list;
    }

    public void clearEmptyFileDir(String dirPath) {
        File file;
        if (!JtlwCheckVariateUtils.getInstance().isEmpty(dirPath) && (file = new File(dirPath)).exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                this.deleteDirectory(file.getAbsolutePath());
            } else {
                for (File childFile : files) {
                    if (!childFile.exists() || !childFile.isDirectory()) continue;
                    this.clearEmptyFileDir(file.getAbsolutePath());
                }
            }
        }
    }

    public JtlwFileTypeEnum getFileType(String filePath) {
        try {
            return this.getFileType(new FileInputStream(filePath));
        }
        catch (FileNotFoundException e) {
            return JtlwFileTypeEnum.OTHER;
        }
    }

    public JtlwFileTypeEnum getFileType(InputStream inputStream) {
        try {
            if (inputStream == null) {
                return null;
            }
            byte[] bytes = new byte[28];
            inputStream.read(bytes, 0, bytes.length);
            String fileHeader = JtlwCommonUtils.getInstance().bytesToHexString(bytes).toLowerCase();
            for (JtlwFileTypeEnum type : JtlwFileTypeEnum.values()) {
                if (!fileHeader.startsWith(type.getStart().toLowerCase())) continue;
                return type;
            }
            return JtlwFileTypeEnum.OTHER;
        }
        catch (Exception e) {
            return JtlwFileTypeEnum.OTHER;
        }
    }

    public Charset getFileCodedFormat(String filePath) {
        String javaEncode = EncodingDetect.getJavaEncode(filePath);
        switch (javaEncode.toLowerCase()) {
            case "utf-8": {
                return StandardCharsets.UTF_8;
            }
            case "unicode": {
                return Charset.forName("unicode");
            }
        }
        return Charset.forName("gbk");
    }

    public boolean changeFileCodedFormat(String filePath, Charset oldCodedFormat, Charset newCodedFormat) {
        String content = this.readFileContent(filePath, oldCodedFormat);
        return this.writeFilContent(filePath, newCodedFormat, new String(content.getBytes(newCodedFormat), newCodedFormat));
    }

    public String readFileContent(String filePath, Charset codedFormat) {
        byte[] bytes = this.readBytes(filePath);
        if (bytes == null) {
            return "";
        }
        return new String(bytes, codedFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFilContent(String filePath, Charset toCharsetName, String content) {
        this.deleteFile(filePath);
        FileOutputStream outputStream = null;
        OutputStreamWriter outWrite = null;
        try {
            outputStream = new FileOutputStream(filePath);
            outWrite = new OutputStreamWriter((OutputStream)outputStream, toCharsetName);
            outWrite.write(content);
            outWrite.flush();
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.print(e.getClass() + "\n");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outWrite != null) {
                try {
                    outWrite.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JtlwFileTypeEnum> getDocType() {
        if (this.allDocFileTypeEnum.isEmpty()) {
            List<JtlwFileTypeEnum> list = this.allDocFileTypeEnum;
            synchronized (list) {
                if (this.allDocFileTypeEnum.isEmpty()) {
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.DOC);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.XLS);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.PDF);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.DOCX);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.XLSX);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.MDB);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.PST);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.DBX);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.XLSX_DOCX);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.XLS_DOC);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.VSD);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.WPS);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.WPD);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.EPS);
                    this.allDocFileTypeEnum.add(JtlwFileTypeEnum.TXT);
                }
            }
        }
        return this.allDocFileTypeEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JtlwFileTypeEnum> getImageType() {
        if (this.allImageFileTypeEnum.isEmpty()) {
            List<JtlwFileTypeEnum> list = this.allImageFileTypeEnum;
            synchronized (list) {
                if (this.allImageFileTypeEnum.isEmpty()) {
                    this.allImageFileTypeEnum.add(JtlwFileTypeEnum.JPG);
                    this.allImageFileTypeEnum.add(JtlwFileTypeEnum.JPEG);
                    this.allImageFileTypeEnum.add(JtlwFileTypeEnum.PNG);
                    this.allImageFileTypeEnum.add(JtlwFileTypeEnum.BMP);
                    this.allImageFileTypeEnum.add(JtlwFileTypeEnum.GIF);
                    this.allImageFileTypeEnum.add(JtlwFileTypeEnum.TIF);
                }
            }
        }
        return this.allImageFileTypeEnum;
    }

    public boolean renameFile(File oldFile, String newFileName) {
        if (oldFile != null && oldFile.exists()) {
            File newFile = new File(oldFile.getParentFile().getAbsolutePath() + "/" + newFileName);
            return oldFile.renameTo(newFile);
        }
        return false;
    }
}

