/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class JtlwDateTimeUtil {
    private static volatile JtlwDateTimeUtil optionUtils;
    public static long DAY_TIME_MILLISECOND;
    public static long HOUR_TIME_MILLISECOND;
    public static String YEAR_PATTERN;
    public static String MONTH_PATTERN;
    public static String DAY_PATTERN;

    private JtlwDateTimeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwDateTimeUtil getInstance() {
        if (optionUtils != null) return optionUtils;
        Class<JtlwDateTimeUtil> clazz = JtlwDateTimeUtil.class;
        synchronized (JtlwDateTimeUtil.class) {
            if (optionUtils != null) return optionUtils;
            optionUtils = new JtlwDateTimeUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionUtils;
        }
    }

    public Long getMillisecond() {
        return System.currentTimeMillis();
    }

    public Long getSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public String getFormatDateTime(String pattern, long dateTime) {
        return this.getFormatDateTime(pattern, new Date(dateTime));
    }

    public String getFormatDateTime(String pattern, Date date) {
        if (pattern == null || "".equals(pattern) || date == null) {
            return null;
        }
        SimpleDateFormat sDateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        return sDateFormat.format(date);
    }

    public String getFormatDateNowTime(String pattern) {
        if (pattern == null || "".equals(pattern)) {
            return null;
        }
        SimpleDateFormat sDateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        return sDateFormat.format(new Date(this.getMillisecond()));
    }

    public Long getFormatNowTimeToMillisecond(String pattern) {
        if (pattern == null || "".equals(pattern)) {
            return null;
        }
        SimpleDateFormat sDateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        Long time = null;
        try {
            time = sDateFormat.parse(sDateFormat.format(new Date(this.getMillisecond()))).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }

    public long getMillisecond(String dateAndTime, String dateAndTimeFormat) {
        if (dateAndTime == null || "".equals(dateAndTime) || dateAndTimeFormat == null || "".equals(dateAndTimeFormat)) {
            return 0L;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateAndTimeFormat, Locale.getDefault());
        long millionSeconds = 0L;
        try {
            millionSeconds = sdf.parse(dateAndTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return millionSeconds;
    }

    public long getSecond(String dateAndTime, String dateAndTimeFormat) {
        return this.getMillisecond(dateAndTime, dateAndTimeFormat) / 1000L;
    }

    public boolean isLeapYear(Integer year) {
        if (year != null) {
            return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        }
        return false;
    }

    public boolean isLeapYearForTime(long yearTime) {
        return this.isLeapYear(Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, yearTime)));
    }

    public int dateToWeek(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return w;
    }

    public List<Long> getMonthTimeList(long monthTime, int firstWeek, boolean onlyMonth) {
        int i;
        firstWeek %= 7;
        ArrayList<Long> timeList = new ArrayList<Long>();
        Long monthStartTime = JtlwDateTimeUtil.getInstance().getMillisecond(JtlwDateTimeUtil.getInstance().getFormatDateTime("yyyy-MM", monthTime), "yyyy-MM");
        long nextMonthStartTime = this.getNextMonthStartDayTime(monthTime);
        int weekDay = this.dateToWeek(monthStartTime);
        int addFirst = 0;
        if (weekDay > firstWeek) {
            addFirst = weekDay - firstWeek;
        } else if (weekDay < firstWeek) {
            addFirst = weekDay + 7 - firstWeek;
        }
        if (onlyMonth) {
            for (i = 0; i < addFirst; ++i) {
                timeList.add(null);
            }
        } else {
            for (i = addFirst; i > 0; --i) {
                timeList.add(monthStartTime - DAY_TIME_MILLISECOND * (long)i);
            }
        }
        while (monthStartTime.compareTo(nextMonthStartTime) < 0) {
            timeList.add(monthStartTime);
            monthStartTime = monthStartTime + DAY_TIME_MILLISECOND;
        }
        if (!onlyMonth) {
            int lastWeekDay = this.dateToWeek(nextMonthStartTime - DAY_TIME_MILLISECOND);
            int addLast = firstWeek + 7 - lastWeekDay - 1;
            for (int i2 = 0; i2 < addLast; ++i2) {
                timeList.add(nextMonthStartTime);
                nextMonthStartTime += DAY_TIME_MILLISECOND;
            }
        }
        return timeList;
    }

    public boolean isOneDay(long timeOne, long timeTwo) {
        return this.getFormatDateTime("yyyyMMdd", timeOne).equals(this.getFormatDateTime("yyyyMMdd", timeTwo));
    }

    public boolean isOneHour(long timeOne, long timeTwo) {
        return this.getFormatDateTime("yyyyMMddHH", timeOne).equals(this.getFormatDateTime("yyyyMMddHH", timeTwo));
    }

    public boolean isOneMinutes(long timeOne, long timeTwo) {
        return this.getFormatDateTime("yyyyMMddHHmm", timeOne).equals(this.getFormatDateTime("yyyyMMddHHmm", timeTwo));
    }

    public long getNextMonthStartDayTime(long time) {
        String month = JtlwDateTimeUtil.getInstance().getFormatDateTime("MM", time);
        String year = JtlwDateTimeUtil.getInstance().getFormatDateTime("yyyy", time);
        switch (month) {
            case "01": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "02", "yyyyMM");
            }
            case "02": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "03", "yyyyMM");
            }
            case "03": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "04", "yyyyMM");
            }
            case "04": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "05", "yyyyMM");
            }
            case "05": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "06", "yyyyMM");
            }
            case "06": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "07", "yyyyMM");
            }
            case "07": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "08", "yyyyMM");
            }
            case "08": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "09", "yyyyMM");
            }
            case "09": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "10", "yyyyMM");
            }
            case "10": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "11", "yyyyMM");
            }
            case "11": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "12", "yyyyMM");
            }
            case "12": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(Integer.parseInt(year) + 1 + "01", "yyyyMM");
            }
        }
        return -1L;
    }

    public long getLastMonthStartDayTime(long time) {
        String month = JtlwDateTimeUtil.getInstance().getFormatDateTime("MM", time);
        String year = JtlwDateTimeUtil.getInstance().getFormatDateTime("yyyy", time);
        switch (month) {
            case "01": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(Integer.parseInt(year) - 1 + "12", "yyyyMM");
            }
            case "02": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "01", "yyyyMM");
            }
            case "03": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "02", "yyyyMM");
            }
            case "04": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "03", "yyyyMM");
            }
            case "05": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "04", "yyyyMM");
            }
            case "06": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "05", "yyyyMM");
            }
            case "07": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "06", "yyyyMM");
            }
            case "08": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "07", "yyyyMM");
            }
            case "09": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "08", "yyyyMM");
            }
            case "10": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "09", "yyyyMM");
            }
            case "11": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "10", "yyyyMM");
            }
            case "12": {
                return JtlwDateTimeUtil.getInstance().getMillisecond(year + "11", "yyyyMM");
            }
        }
        return -1L;
    }

    public int getMonthDays(long showTime) {
        String year = this.getFormatDateTime("yyyy", showTime);
        String month = this.getFormatDateTime("MM", showTime);
        int showYear = Integer.parseInt(year);
        int showMonth = Integer.parseInt(month);
        if (showMonth == 1 || showMonth == 3 || showMonth == 5 || showMonth == 7 || showMonth == 8 || showMonth == 10 || showMonth == 12) {
            return 31;
        }
        if (showMonth == 2) {
            if (this.isLeapYear(showYear)) {
                return 29;
            }
            return 28;
        }
        return 30;
    }

    public int getCountdownDay(long millisecondTime) {
        return (int)(millisecondTime / DAY_TIME_MILLISECOND);
    }

    public int getCountdownHours(long millisecondTime) {
        return this.getCountdownHours(millisecondTime, false);
    }

    public int getCountdownHours(long millisecondTime, boolean useOneDay) {
        if (useOneDay) {
            return (int)(millisecondTime / HOUR_TIME_MILLISECOND % 24L);
        }
        return (int)(millisecondTime / HOUR_TIME_MILLISECOND);
    }

    public int getCountdownMinutes(long millisecondTime) {
        return this.getCountdownMinutes(millisecondTime, false);
    }

    public int getCountdownMinutes(long millisecondTime, boolean useOnHours) {
        if (useOnHours) {
            return (int)(millisecondTime / 60000L % 60L);
        }
        return (int)(millisecondTime / 60000L);
    }

    public int getCountdownMillisecond(long millisecondTime) {
        return this.getCountdownMillisecond(millisecondTime, false);
    }

    public int getCountdownMillisecond(long millisecondTime, boolean useOnMinutes) {
        if (useOnMinutes) {
            return (int)(millisecondTime / 1000L % 60L);
        }
        return (int)(millisecondTime / 1000L);
    }

    public List<Long> getYearList(int leftYearCount, int rightYearCount) {
        int i;
        ArrayList<Long> list = new ArrayList<Long>();
        String year = this.getFormatDateNowTime(YEAR_PATTERN);
        list.add(this.getMillisecond(year, YEAR_PATTERN));
        int yearNum = Integer.parseInt(year);
        for (i = 1; i <= leftYearCount; ++i) {
            list.add(0, this.getMillisecond(String.valueOf(yearNum - i), YEAR_PATTERN));
        }
        for (i = 1; i <= rightYearCount; ++i) {
            list.add(this.getMillisecond(String.valueOf(yearNum + i), YEAR_PATTERN));
        }
        return list;
    }

    public List<Long> getYearList(long startTime, long endTime) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (startTime <= endTime) {
            int start = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, startTime));
            int end = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, endTime));
            for (int index = start; index <= end; ++index) {
                list.add(this.getMillisecond(String.valueOf(index), YEAR_PATTERN));
            }
        }
        return list;
    }

    public List<Long> getMonthList(long yearTime, boolean asOfCurrent) {
        String monthPattern = YEAR_PATTERN + MONTH_PATTERN;
        String year = this.getFormatDateTime(YEAR_PATTERN, yearTime);
        ArrayList<Long> list = new ArrayList<Long>();
        if (asOfCurrent) {
            int month = Integer.parseInt(this.getFormatDateNowTime(MONTH_PATTERN));
            for (int i = 1; i <= month; ++i) {
                list.add(this.getMillisecond(year + i, monthPattern));
            }
        } else {
            for (int i = 1; i <= 12; ++i) {
                list.add(this.getMillisecond(year + i, monthPattern));
            }
        }
        return list;
    }

    public List<Long> getMonthList(long startTime, long endTime, long showTime) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (showTime >= startTime && showTime <= endTime) {
            int startYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, startTime));
            int endYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, endTime));
            int showYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, showTime));
            int start = 1;
            int end = 12;
            if (startYear == endYear) {
                start = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, startTime));
                end = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, endTime));
            } else if (showYear == endYear) {
                end = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, endTime));
            } else if (showYear == startYear) {
                start = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, startTime));
            }
            for (int index = start; index <= end; ++index) {
                list.add(this.getMillisecond(showYear + (index < 10 ? "0" + index : String.valueOf(index)), YEAR_PATTERN + MONTH_PATTERN));
            }
        }
        return list;
    }

    public List<Long> getDayList(long monthTime, boolean asOfCurrent) {
        String dayPattern = YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN;
        String yearMonth = this.getFormatDateTime(YEAR_PATTERN + MONTH_PATTERN, monthTime);
        int month = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, monthTime));
        ArrayList<Long> list = new ArrayList<Long>();
        int maxDay = asOfCurrent ? Integer.parseInt(this.getFormatDateNowTime(DAY_PATTERN)) : (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12 ? 31 : (month == 2 ? (this.isLeapYearForTime(monthTime) ? 29 : 28) : 30));
        for (int i = 1; i <= maxDay; ++i) {
            list.add(this.getMillisecond(yearMonth + i, dayPattern));
        }
        return list;
    }

    public List<Long> getDayList(long startTime, long endTime, long showTime, boolean onlyCurrentMonth) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (showTime >= startTime && showTime <= endTime) {
            int startYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, startTime));
            int endYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, endTime));
            int showYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, showTime));
            int startMonth = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, startTime));
            int endMonth = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, endTime));
            int showMonth = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, showTime));
            int start = 1;
            int end = this.getMonthDays(showTime);
            if (startYear == endYear) {
                if (startMonth == endMonth) {
                    start = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, startTime));
                    end = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, endTime));
                } else if (showMonth == endMonth) {
                    end = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, endTime));
                } else if (showMonth == startMonth) {
                    start = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, startTime));
                }
            } else if (showYear == endYear) {
                if (showMonth == endMonth) {
                    end = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, endTime));
                }
            } else if (showYear == startYear && showMonth == startMonth) {
                start = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, startTime));
            }
            for (int index = start; index <= end; ++index) {
                list.add(this.getMillisecond(showYear + (showMonth < 10 ? "0" + showMonth : String.valueOf(showMonth)) + (index < 10 ? "0" + index : String.valueOf(index)), YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN));
            }
            if (!onlyCurrentMonth) {
                long first = startTime;
                if (list.size() > 0) {
                    first = (Long)list.get(list.size() - 1);
                }
                for (long time = first + DAY_TIME_MILLISECOND; time < endTime; time += DAY_TIME_MILLISECOND) {
                    list.add(time);
                }
            }
        }
        return list;
    }

    public List<Long> getHourList(long startTime, long endTime, long showTime, boolean onlyCurrentDay) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (showTime >= startTime && showTime <= endTime) {
            String showDay = this.getFormatDateTime(YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN, showTime);
            int start = 0;
            int end = 23;
            if (this.isOneDay(showTime, endTime)) {
                end = Integer.parseInt(this.getFormatDateTime("HH", endTime));
            } else if (this.isOneDay(showTime, startTime)) {
                start = Integer.parseInt(this.getFormatDateTime("HH", startTime));
            }
            for (int index = start; index <= end; ++index) {
                list.add(this.getMillisecond(showDay + (index < 10 ? "0" + index : String.valueOf(index)), YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN + "HH"));
            }
        }
        if (!onlyCurrentDay) {
            long first = startTime;
            if (list.size() > 0) {
                first = (Long)list.get(list.size() - 1);
            }
            for (long time = first + HOUR_TIME_MILLISECOND; time < endTime; time += HOUR_TIME_MILLISECOND) {
                list.add(time);
            }
        }
        return list;
    }

    public List<Long> getMinutesList(long startTime, long endTime, long showTime, boolean onlyCurrentHour) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (showTime >= startTime && showTime <= endTime) {
            String showDay = this.getFormatDateTime(YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN + "HH", showTime);
            int start = 0;
            int end = 59;
            if (this.isOneHour(showTime, endTime)) {
                end = Integer.parseInt(this.getFormatDateTime("mm", endTime));
            } else if (this.isOneHour(showTime, startTime)) {
                start = Integer.parseInt(this.getFormatDateTime("mm", startTime));
            }
            for (int index = start; index <= end; ++index) {
                list.add(this.getMillisecond(showDay + (index < 10 ? "0" + index : String.valueOf(index)), YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN + "HHmm"));
            }
        }
        if (!onlyCurrentHour) {
            long first = startTime;
            if (list.size() > 0) {
                first = (Long)list.get(list.size() - 1);
            }
            for (long time = first + 60000L; time < endTime; time += 60000L) {
                list.add(time);
            }
        }
        return list;
    }

    public List<Long> getSecondsList(long startTime, long endTime, long showTime, boolean onlyCurrentMinutes) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (showTime >= startTime && showTime <= endTime) {
            String showDay = this.getFormatDateTime(YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN + "HHmm", showTime);
            int start = 0;
            int end = 59;
            if (this.isOneMinutes(showTime, endTime)) {
                end = Integer.parseInt(this.getFormatDateTime("ss", endTime));
            } else if (this.isOneMinutes(showTime, startTime)) {
                start = Integer.parseInt(this.getFormatDateTime("ss", startTime));
            }
            for (int index = start; index <= end; ++index) {
                list.add(this.getMillisecond(showDay + (index < 10 ? "0" + index : String.valueOf(index)), YEAR_PATTERN + MONTH_PATTERN + DAY_PATTERN + "HHmmss"));
            }
        }
        if (!onlyCurrentMinutes) {
            long first = startTime;
            if (list.size() > 0) {
                first = (Long)list.get(list.size() - 1);
            }
            for (long time = first + 1000L; time < endTime; time += 1000L) {
                list.add(time);
            }
        }
        return list;
    }

    public int getConstellation(long time) {
        int day = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, time));
        int month = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, time));
        int[] constellationEdgeDay = new int[]{20, 18, 20, 20, 20, 21, 22, 22, 22, 22, 21, 21};
        if (day <= constellationEdgeDay[month - 1]) {
            --month;
        }
        return month;
    }

    public int getAge(long birthTime, boolean isReal) {
        int currentYear = Integer.parseInt(this.getFormatDateNowTime(YEAR_PATTERN));
        int birthYear = Integer.parseInt(this.getFormatDateTime(YEAR_PATTERN, birthTime));
        int year = currentYear - birthYear + 1;
        if (isReal) {
            int birthDay;
            int currentDay;
            int birthMonth;
            int currentMonth = Integer.parseInt(this.getFormatDateNowTime(MONTH_PATTERN));
            if (currentMonth < (birthMonth = Integer.parseInt(this.getFormatDateTime(MONTH_PATTERN, birthTime)))) {
                --year;
            } else if (currentMonth == birthMonth && (currentDay = Integer.parseInt(this.getFormatDateNowTime(DAY_PATTERN))) < (birthDay = Integer.parseInt(this.getFormatDateTime(DAY_PATTERN, birthTime)))) {
                --year;
            }
        }
        return year;
    }

    static {
        DAY_TIME_MILLISECOND = 86400000L;
        HOUR_TIME_MILLISECOND = 3600000L;
        YEAR_PATTERN = "yyyy";
        MONTH_PATTERN = "MM";
        DAY_PATTERN = "dd";
    }
}

