/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.tools.safe;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javabase.lorenwang.tools.common.JtlwCheckVariateUtil;
import javabase.lorenwang.tools.dataConversion.JtlwCodeConversionUtil;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JtlwEncryptDecryptUtil {
    private static volatile JtlwEncryptDecryptUtil optionUtils;
    private final String KEY_ALGORITHM = "AES";
    private final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    private JtlwEncryptDecryptUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JtlwEncryptDecryptUtil getInstance() {
        if (optionUtils != null) return optionUtils;
        Class<JtlwEncryptDecryptUtil> clazz = JtlwEncryptDecryptUtil.class;
        synchronized (JtlwEncryptDecryptUtil.class) {
            if (optionUtils != null) return optionUtils;
            optionUtils = new JtlwEncryptDecryptUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return optionUtils;
        }
    }

    public String encrypt(String srcData, String key, String ivs) {
        if (JtlwCheckVariateUtil.getInstance().isEmpty(srcData) || JtlwCheckVariateUtil.getInstance().isEmpty(key) || JtlwCheckVariateUtil.getInstance().isEmpty(ivs)) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivs.getBytes());
            cipher.init(1, (Key)keySpec, ivParameterSpec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(JtlwCodeConversionUtil.getInstance().unicodeToChinese(srcData).getBytes()));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String decrypt(String srcData, String key, String ivs) {
        if (JtlwCheckVariateUtil.getInstance().isEmpty(srcData) || JtlwCheckVariateUtil.getInstance().isEmpty(key) || JtlwCheckVariateUtil.getInstance().isEmpty(ivs)) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivs.getBytes());
            cipher.init(2, (Key)keySpec, ivParameterSpec);
            byte[] bytes = Base64.getDecoder().decode(JtlwCodeConversionUtil.getInstance().unicodeToChinese(srcData));
            return new String(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            return "";
        }
    }
}

