/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ConverterHelper {
    public static <T> T convert(T destin, Object source) {
        if (source == null) {
            return null;
        }
        Class<?> clazz = source.getClass();
        Field[] fieldsSource = ConverterHelper.getAllFields(clazz);
        clazz = destin.getClass();
        Field[] fieldsDestin = ConverterHelper.getAllFields(clazz);
        block4: for (Field fieldSource : fieldsSource) {
            if (ConverterHelper.isStatic(fieldSource).booleanValue()) continue;
            fieldSource.setAccessible(true);
            try {
                for (Field fieldDestin : fieldsDestin) {
                    if (ConverterHelper.isStatic(fieldDestin).booleanValue()) break;
                    fieldDestin.setAccessible(true);
                    if (!fieldDestin.getName().equals(fieldSource.getName())) continue;
                    if (fieldDestin.getType().equals(fieldSource.getType())) {
                        fieldDestin.set(destin, fieldSource.get(source));
                        continue block4;
                    }
                    try {
                        fieldDestin.set(destin, ConverterHelper.typeConvert(fieldDestin.getType(), fieldSource.get(source)));
                    }
                    catch (Exception e) {
                        fieldDestin.set(destin, null);
                    }
                    continue block4;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return destin;
    }

    public static <S, T> List<T> convertList(T destin, List<S> source) {
        if (source.size() == 0) {
            return null;
        }
        LinkedList lists = new LinkedList();
        Class<?> clazz = destin.getClass();
        try {
            for (S item : source) {
                Object temp = clazz.newInstance();
                lists.add(ConverterHelper.convert(temp, item));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lists;
    }

    private static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != Object.class) {
            try {
                fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        Field[] temp = new Field[fieldList.size()];
        fieldList.toArray(temp);
        return temp;
    }

    private static <T> Object typeConvert(Class<T> destinClass, Object sourceObj) throws Exception {
        try {
            if (destinClass.equals(Integer.class)) {
                Method method = sourceObj.getClass().getMethod("intValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Double.class)) {
                Method method = sourceObj.getClass().getMethod("doubleValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Long.class)) {
                Method method = sourceObj.getClass().getMethod("longValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Float.class)) {
                Method method = sourceObj.getClass().getMethod("floatValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Short.class)) {
                Method method = sourceObj.getClass().getMethod("shortValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(BigDecimal.class)) {
                if (sourceObj.getClass().equals(Double.class)) {
                    Method method = destinClass.getMethod("valueOf", Double.TYPE);
                    return method.invoke(null, sourceObj);
                }
                if (sourceObj.getClass().equals(Long.class)) {
                    Method method = destinClass.getMethod("valueOf", Long.TYPE);
                    return method.invoke(null, sourceObj);
                }
            }
            throw new Exception(String.format("Can not convert '%s' to '%s'", sourceObj.getClass(), destinClass));
        }
        catch (Exception e) {
            throw new Exception(String.format("Can not convert '%s' to '%s'", sourceObj.getClass(), destinClass));
        }
    }

    private static Boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }
}

