/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Exception.SortException;
import Model.PageModel;
import Model.PageRequest;
import Util.SortUtil;
import java.util.ArrayList;
import java.util.List;

public class ListPageHelper {
    private static final Integer maxSize = 50;
    private static final Integer maxPage = 50;

    public static <T> PageModel<T> doPage(PageRequest pageRequest, List<T> paramLists) {
        ArrayList<T> pagedLists = new ArrayList<T>();
        PageModel<T> pageModel = new PageModel<T>();
        if (paramLists == null || paramLists.size() < 1) {
            System.err.println("No data in lists. ");
            pageModel.setEmpty(true);
            return pageModel;
        }
        if (pageRequest == null || pageRequest.getSize() == null | pageRequest.getPage() == null) {
            System.err.println("No data in pageRequest. ");
            pageModel.setEmpty(true);
            return pageModel;
        }
        if (pageRequest.getSort() != null) {
            try {
                SortUtil.doSort(pageRequest.getSort(), paramLists);
            }
            catch (SortException e) {
                e.printStackTrace();
            }
        }
        Integer size = pageRequest.getSize();
        Integer page = pageRequest.getPage();
        if (size < 1 | size > maxSize || page < 1 | page > maxPage) {
            size = 20;
            page = 1;
        }
        pageModel.setTotalElements(paramLists.size());
        pageModel.setSize(size);
        pageModel.setPage(page);
        if (size >= paramLists.size()) {
            if (page > 1) {
                pageModel.setEmpty(true);
                return pageModel;
            }
            pageModel.setPageOfElements_Content_TotalPages(paramLists.size(), paramLists, 1);
            return pageModel;
        }
        int count = 0;
        try {
            for (int i = size * (page - 1); i < size * page; ++i) {
                pagedLists.add(paramLists.get(i));
                ++count;
            }
        }
        catch (Exception e) {
            System.err.println("List index out of range. ");
            System.err.println(String.format("We count '%s' data in this page.", count));
            if (count == 0) {
                pageModel.setEmpty(true);
                pageModel.setTotalPages(paramLists.size() / size + 1);
                return pageModel;
            }
            pageModel.setPageOfElements_Content_TotalPages(count, pagedLists, paramLists.size() / size + 1);
            return pageModel;
        }
        pageModel.setPageOfElements_Content_TotalPages(count, pagedLists, paramLists.size() / size + 1);
        return pageModel;
    }
}

