/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Exception.SortException;
import Model.Sort;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortUtil {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String FIELD_CLASS = "fieldClass";
    private static final String FIELD_OBJECT = "fieldObject";
    private static final String INTEGER_CLASS = "java.lang.Integer";
    private static final String LONG_CLASS = "java.lang.Long";
    private static final String DOUBLE_CLASS = "java.lang.Double";
    private static final String DATE_CLASS = "java.util.Date";

    public static <T> void doSort(Sort sort, List<T> paramLists) throws SortException {
        if (sort.getFieldName() == null) {
            throw new SortException("You did not choose one field which you want to sort by it! ");
        }
        paramLists.sort((one, two) -> {
            try {
                return SortUtil.compare(one, two, sort.getFieldName(), sort.getDirection());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                return 0;
            }
        });
    }

    private static Integer compare(Object paramOne, Object paramTwo, String fieldName, Sort.Direction direction) throws Exception {
        if (!paramOne.getClass().getName().equals(paramTwo.getClass().getName())) {
            throw new SortException("The two params is not in one class!");
        }
        Map<String, Object> mapOne = SortUtil.getFieldByField(paramOne, fieldName);
        Map<String, Object> mapTwo = SortUtil.getFieldByField(paramTwo, fieldName);
        if (mapOne.get(FIELD_CLASS).equals(INTEGER_CLASS)) {
            return SortUtil.compare(Integer.parseInt(mapOne.get(FIELD_OBJECT).toString()), Integer.parseInt(mapTwo.get(FIELD_OBJECT).toString()), direction);
        }
        if (mapOne.get(FIELD_CLASS).equals(DOUBLE_CLASS)) {
            return SortUtil.compare(Double.valueOf(mapOne.get(FIELD_OBJECT).toString()), Double.valueOf(mapTwo.get(FIELD_OBJECT).toString()), direction);
        }
        if (mapOne.get(FIELD_CLASS).equals(LONG_CLASS)) {
            return SortUtil.compare(Long.valueOf(mapOne.get(FIELD_OBJECT).toString()), Long.valueOf(mapTwo.get(FIELD_OBJECT).toString()), direction);
        }
        if (mapOne.get(FIELD_CLASS).equals(DATE_CLASS)) {
            return SortUtil.compare(DATE_FORMAT.parse(DATE_FORMAT.format(mapOne.get(FIELD_OBJECT))), DATE_FORMAT.parse(DATE_FORMAT.format(mapTwo.get(FIELD_OBJECT))), direction);
        }
        throw new SortException("Can not solve this attribute's type!");
    }

    private static Map<String, Object> getFieldByField(Object param, String fieldName) throws IllegalAccessException, SortException {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> c = param.getClass();
        for (Field field : fields = c.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            Object obj = field.get(param);
            if (obj == null) {
                throw new NullPointerException("Such field is null!");
            }
            map.put(FIELD_CLASS, obj.getClass().getName());
            map.put(FIELD_OBJECT, obj);
            return map;
        }
        throw new SortException(String.format("\"%s\"--No such field in this param!", fieldName));
    }

    private static Map<String, Object> doFieldGetMethod(Object param, String fieldName) throws InvocationTargetException, IllegalAccessException, NullPointerException, SortException {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> c = param.getClass();
        for (Method method : methods = c.getMethods()) {
            if (!("get" + fieldName).toLowerCase().equals(method.getName().toLowerCase())) continue;
            Object obj = method.invoke(param, new Object[0]);
            if (obj == null) {
                throw new NullPointerException("Such fieldName has no get method or this field is null!");
            }
            map.put(FIELD_CLASS, obj.getClass().getName());
            map.put(FIELD_OBJECT, obj);
            return map;
        }
        throw new SortException(String.format("\"%s\"--No such field in this param!", fieldName));
    }

    private static Integer compare(Integer one, Integer two, Sort.Direction direction) {
        switch (direction) {
            case ASC: {
                return Integer.compare(one, two);
            }
            case DESC: {
                return Integer.compare(two, one);
            }
        }
        return 0;
    }

    private static Integer compare(Double one, Double two, Sort.Direction direction) {
        switch (direction) {
            case ASC: {
                return Double.compare(one, two);
            }
            case DESC: {
                return Double.compare(two, one);
            }
        }
        return 0;
    }

    private static Integer compare(Long one, Long two, Sort.Direction direction) {
        switch (direction) {
            case ASC: {
                return Long.compare(one, two);
            }
            case DESC: {
                return Long.compare(two, one);
            }
        }
        return 0;
    }

    private static Integer compare(Date one, Date two, Sort.Direction direction) {
        switch (direction) {
            case ASC: {
                return one.compareTo(two);
            }
            case DESC: {
                return two.compareTo(one);
            }
        }
        return 0;
    }
}

