/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javaUtil.Util;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Do2Groovy {
    public static void toGroovy(String savePath, String classPath) {
        File dir = new File(classPath);
        try {
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                if (files != null) {
                    for (File file : files) {
                        String fileName = file.getName().substring(0, file.getName().indexOf("."));
                        String className = Do2Groovy.getPackage(file) + "." + fileName;
                        byte[] b = Do2Groovy.getGroovy(Class.forName(className)).getBytes();
                        String tableName = fileName.substring(0, fileName.indexOf("DO"));
                        String groovyPath = savePath + "\\" + tableName + ".groovy";
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(groovyPath));
                        fileOutputStream.write(b, 0, b.length);
                        fileOutputStream.close();
                        System.out.println("DONE");
                    }
                    System.out.println(String.format("total: %s done.", files.length));
                } else {
                    System.err.println("No files in this directory. ");
                }
            } else {
                System.err.println("Path is not a directory. ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getPackage(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] b = new byte[2048];
            while (fileInputStream.read(b) != -1) {
                sb.append(new String(b, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Pattern pattern = Pattern.compile("package ([\\s\\S]*)dataobject");
        Matcher matcher = pattern.matcher(sb.toString());
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static <T> String getGroovy(Class<T> clazz) {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        String simpleName = clazz.getSimpleName();
        String fileName = simpleName.substring(0, simpleName.indexOf("DO"));
        String tableName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fileName);
        sb.append("package script.db\n\n");
        sb.append(String.format("databaseChangeLog(logicalFilePath: '%s.groovy')\n", fileName));
        sb.append("{\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sb.append(String.format("changeSet(id: '%s-add-table-%s', author: 'Luoming Xu')\n", sdf.format(new Date(System.currentTimeMillis())), tableName));
        sb.append("{\n");
        sb.append(String.format("createTable(tableName: \"%s\")\n", tableName));
        sb.append("{\n");
        sb.append("column(name: 'id', type: 'BIGINT', autoIncrement: true, remarks: '\u741b\u2196D\u951b\u5c7c\u5bcc\u95bf\ue1c6\u7d1dunsigned bigint\u9286\u4f78\u5d1f\u741b\u3126\u6902\u9477\ue044\ue583\u9286\u4f79\ue11e\u95c0\u5938\u8d1f 1')\n{\nconstraints(primaryKey: true)\n}\n");
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String temp = field.getName().toLowerCase();
            if (temp.contains("lastupdate") || temp.contains("creat") || temp.contains("serial") || temp.contains("objectversionnumber") || temp.contains("id")) continue;
            String columnName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
            String type = Do2Groovy.getJdbcType(field);
            sb.append(String.format("column(name: '%s', type: '%s', remarks: '')\n", columnName, type));
        }
        sb.append("column(name: \"created_by\", type: \"BIGINT\", defaultValue: \"0\", remarks: '\u9352\u6d98\u7f13\u6d5c\ufffd')\n");
        sb.append("column(name: \"creation_date\", type: \"DATETIME not null\", defaultValueComputed: \"CURRENT_TIMESTAMP\", remarks: '\u9352\u6d98\u7f13\u93c3\u5815\u68ff')\n");
        sb.append("column(name: \"last_updated_by\", type: \"BIGINT\", defaultValue: \"0\", remarks: '\u6dc7\ue1bd\u657c\u6d5c\ufffd')\n");
        sb.append("column(name: \"last_update_date\", type: \"DATETIME not null on update current_timestamp\", defaultValueComputed: \"CURRENT_TIMESTAMP\", remarks: '\u93c8\ufffd\u935a\u5e9d\u6168\u93c0\u89c4\u6902\u95c2\ufffd')\n");
        sb.append("column(name: \"object_version_number\", type: \"BIGINT\", defaultValue: \"1\", remarks: '\u9417\u581f\u6e70\u9359\ufffd')\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append("}\n");
        return sb.toString();
    }

    private static String getJdbcType(Field field) {
        Class<?> clazz = field.getType();
        if (clazz.equals(String.class)) {
            return "varchar(50)";
        }
        if (clazz.equals(Long.class)) {
            return "bigint";
        }
        if (clazz.equals(Double.class) || clazz.equals(BigDecimal.class)) {
            return "decimal";
        }
        if (clazz.equals(Integer.class)) {
            return "int";
        }
        if (clazz.equals(Date.class)) {
            return "datetime";
        }
        return "error. no such type";
    }
}

