/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javaUtil.Util;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AspectLog {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ThreadLocal<Long> startTime = new ThreadLocal();
    private Map<String, Long> methodCallCount = new HashMap<String, Long>();

    @Pointcut(value="@annotation(com.github.luomingxuorg.javaUtil.Annotation.AspectScope)")
    public void cut() {
    }

    @Before(value="cut()")
    public void before() {
        this.startTime.set(System.currentTimeMillis());
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        this.logger.info("--------------------------------------");
        String className = point.getSignature().getDeclaringTypeName();
        String classType = point.getSignature().getDeclaringType().toString().split(" ")[0];
        String methodName = point.getSignature().getName();
        String returnType = point.getSignature().toString().split(" ")[0];
        Object[] args = point.getArgs();
        this.logger.info(String.format("class/interface: %s(%s)", className, classType));
        this.logger.info(String.format("method: %s", methodName));
        this.logger.info(String.format("args size: %s", args.length));
        for (Object item : args) {
            this.logger.info(String.format("\ttype: %s\tvalue: %s", item.getClass().getSimpleName(), item));
        }
        this.logger.info(String.format("return type: %s", returnType));
        String mapKey = className + "." + methodName;
        if (this.methodCallCount.containsKey(mapKey)) {
            Long temp = this.methodCallCount.get(mapKey);
            this.methodCallCount.put(mapKey, temp + 1L);
        } else {
            this.methodCallCount.put(mapKey, 1L);
        }
        return result;
    }

    @After(value="cut()")
    public void after(JoinPoint point) {
        Long finish = System.currentTimeMillis();
        String mapKey = point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName();
        this.logger.info(String.format("total cost %sms", finish - this.startTime.get()));
        this.logger.info(String.format("call count: %s", this.methodCallCount.get(mapKey)));
        this.logger.info("--------------------------------------");
    }
}

