/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javaUtil.Util;

import com.github.luomingxuorg.javaUtil.Entity.MethodCallInfo;
import com.github.luomingxuorg.javaUtil.Util.StrInColor;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AspectLog {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ThreadLocal<Long> startTime = new ThreadLocal();
    private Map<String, MethodCallInfo> mapMethodCall = new HashMap<String, MethodCallInfo>();

    @Pointcut(value="@annotation(com.github.luomingxuorg.javaUtil.Annotation.EnableAspectScope)")
    private void methodAnnotationScope() {
    }

    @Before(value="methodAnnotationScope()")
    protected void before() {
        this.startTime.set(System.currentTimeMillis());
    }

    @Around(value="methodAnnotationScope()")
    protected Object around(ProceedingJoinPoint point) throws Throwable {
        this.logger.info(StrInColor.yellow("----------------Around----------------"));
        Object result = point.proceed();
        String className = point.getSignature().getDeclaringTypeName();
        String classType = point.getSignature().getDeclaringType().toString().split(" ")[0];
        String methodName = point.getSignature().getName();
        String returnType = point.getSignature().toString().split(" ")[0];
        Object[] args = point.getArgs();
        this.logger.info(String.format("%s: %s(%s)", StrInColor.green("class/interface"), className, classType));
        this.logger.info(String.format("%s: %s", StrInColor.green("method"), methodName));
        this.logger.info(String.format("%s: %s", StrInColor.green("args size"), args.length));
        for (Object item : args) {
            this.logger.info(String.format("\t%s: %s\t%s: %s", StrInColor.green("type"), item.getClass().getSimpleName(), StrInColor.green("value"), item));
        }
        this.logger.info(String.format("%s: %s, %s: %s", StrInColor.green("return"), result, StrInColor.green("type"), returnType));
        String mapKey = className + "." + methodName;
        if (this.mapMethodCall.containsKey(mapKey)) {
            MethodCallInfo entity = this.mapMethodCall.get(mapKey);
            entity.setCallCount(entity.getCallCount() + 1L);
            this.mapMethodCall.put(mapKey, entity);
        } else {
            MethodCallInfo entity = new MethodCallInfo();
            entity.setCallCount(1L);
            entity.setCallTotalTime(0L);
            this.mapMethodCall.put(mapKey, entity);
        }
        return result;
    }

    @After(value="methodAnnotationScope()")
    protected void after(JoinPoint point) {
        this.logger.info(StrInColor.yellow("----------------After----------------"));
        Long costTime = System.currentTimeMillis() - this.startTime.get();
        String mapKey = point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName();
        MethodCallInfo entity = this.mapMethodCall.get(mapKey);
        entity.setCallTotalTime(entity.getCallTotalTime() + costTime);
        this.mapMethodCall.put(mapKey, entity);
        this.logger.info(StrInColor.blue(String.format("cost %sms", costTime)));
        this.logger.info(StrInColor.blue(this.mapMethodCall.get(mapKey).toString()));
        this.logger.info(StrInColor.yellow("------------------------------------------------"));
    }
}

