/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javaUtil.Util;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;

public class GenerateFrameworkFile {
    private static String tableName = "";
    private static String upperTableName = "";
    private static String lowerTableName = "";

    public static void generate(String filePath, String saveDir) {
        try {
            File file = new File(saveDir);
            if (!file.exists() || !file.isDirectory()) {
                throw new Exception("\u6dc7\u6fc6\u74e8\u93c2\u56e6\u6b22\u6fb6\u5f52\u654a\u7487\ufffd");
            }
            CreateTable createTable = (CreateTable)CCJSqlParserUtil.parse((String)GenerateFrameworkFile.readFile(new File(filePath)));
            tableName = createTable.getTable().getName();
            upperTableName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, tableName);
            lowerTableName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tableName);
            GenerateFrameworkFile.generateGroovy(createTable, saveDir);
            GenerateFrameworkFile.generateRepository(saveDir);
            GenerateFrameworkFile.generateService(saveDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void generateGroovy(CreateTable createTable, String saveDir) {
        StringBuilder sb = new StringBuilder();
        sb.append("package script.db\n\n");
        sb.append(String.format("databaseChangeLog(logicalFilePath: '%s.groovy')\n", tableName));
        sb.append("{\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sb.append(String.format("changeSet(id: '%s-add-table-%s', author: 'GeneratedBy LuomingXuOrg')\n", sdf.format(new Date(System.currentTimeMillis())), tableName));
        sb.append("{\n");
        sb.append(String.format("createTable(tableName: \"%s\")\n", tableName));
        sb.append("{\n");
        sb.append("column(name: 'id', type: 'bigint', autoIncrement: true, remarks: '\u741b\u2196D, \u6d93\u5a5a\u656d, \u9477\ue044\ue583, \u59dd\u30e9\u66b1\u6d93\ufffd 1')\n{\nconstraints(primaryKey: true)\n}\n");
        for (ColumnDefinition column : createTable.getColumnDefinitions()) {
            String name = column.getColumnName();
            String type = column.getColDataType().toString().replace(" ", "");
            if (name.equals("id") || name.equals("created_by") || name.equals("creation_date") || name.equals("last_updated_by") || name.equals("last_update_date") || name.equals("object_version_number")) continue;
            sb.append(String.format("column(name: '%s'", name));
            List list = column.getColumnSpecStrings();
            if (list.contains("null")) {
                if (list.contains("not")) {
                    sb.append(String.format(", type: '%s not null'", type));
                } else {
                    sb.append(String.format(", type: '%s null'", type));
                }
            }
            if (list.contains("default")) {
                String defaultValue = (String)list.get(list.indexOf("default") + 1);
                if (type.contains("date") || type.contains("time")) {
                    sb.append(String.format(", defaultValueComputed: '%s'", defaultValue));
                } else {
                    sb.append(String.format(", defaultValue: %s", defaultValue));
                }
            }
            if (list.contains("comment")) {
                sb.append(String.format(", remarks: %s", list.get(list.indexOf("comment") + 1)));
            }
            sb.append(")\n");
        }
        sb.append("column(name: 'created_by', type: 'bigint', defaultValue: '0', remarks: '\u9352\u6d98\u7f13\u6d5c\ufffd')\n");
        sb.append("column(name: 'creation_date', type: 'datetime not null', defaultValueComputed: 'current_timestamp', remarks: '\u9352\u6d98\u7f13\u93c3\u5815\u68ff')\n");
        sb.append("column(name: 'last_updated_by', type: 'bigint', defaultValue: '0', remarks: '\u6dc7\ue1bd\u657c\u6d5c\ufffd')\n");
        sb.append("column(name: 'last_update_date', type: 'datetime not null on update current_timestamp', defaultValueComputed: 'current_timestamp', remarks: '\u93c8\ufffd\u935a\u5e9d\u6168\u93c0\u89c4\u6902\u95c2\ufffd')\n");
        sb.append("column(name: 'object_version_number', type: 'datetime', defaultValue: '1', remarks: '\u9417\u581f\u6e70\u9359\ufffd')\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append("}\n");
        GenerateFrameworkFile.writeFile(sb.toString().getBytes(), saveDir + "\\" + tableName + ".groovy");
    }

    private static void generateRepository(String saveDir) {
        String sb = "import org.springframework.stereotype.Component;\n\n@Component\n" + String.format("public interface %sRepository", upperTableName) + "\n{}\n";
        GenerateFrameworkFile.writeFile(sb.getBytes(), saveDir + "\\" + upperTableName + "Repository.java");
        sb = "import org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.stereotype.Component;\n@Component\n" + String.format("public class %sRepositoryImpl implements %sRepository\n{", upperTableName, upperTableName) + String.format("private final %sMapper %sMapper;\n", upperTableName, lowerTableName) + "@Autowired\n" + String.format("public %sRepositoryImpl(%sMapper %sMapper)\n{", upperTableName, upperTableName, lowerTableName) + String.format("this.%sMapper=%sMapper;\n}\n}\n", lowerTableName, lowerTableName);
        GenerateFrameworkFile.writeFile(sb.getBytes(), saveDir + "\\" + upperTableName + "RepositoryImpl.java");
    }

    private static void generateService(String saveDir) {
        String upperTableName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, tableName);
        String lowerTableName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tableName);
        String sb = "import org.springframework.stereotype.Component;\n\n@Component\n" + String.format("public interface %sService", upperTableName) + "\n{}\n";
        GenerateFrameworkFile.writeFile(sb.getBytes(), saveDir + "\\" + upperTableName + "Service.java");
        sb = "import org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.stereotype.Component;\n@Component\n" + String.format("public class %sServiceImpl implements %sService\n{", upperTableName, upperTableName) + String.format("private final %sRepository %sRepository;\n", upperTableName, lowerTableName) + "@Autowired\n" + String.format("public %sServiceImpl(%sRepository %sRepository)\n{", upperTableName, upperTableName, lowerTableName) + String.format("this.%sRepository=%sRepository;\n}\n}\n", lowerTableName, lowerTableName);
        GenerateFrameworkFile.writeFile(sb.getBytes(), saveDir + "\\" + upperTableName + "ServiceImpl.java");
    }

    private static String readFile(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            int byteRead;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] b = new byte[1024];
            while ((byteRead = fileInputStream.read(b)) != -1) {
                sb.append(new String(b, 0, byteRead, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static void writeFile(byte[] buffer, String savePath) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(savePath));
            fileOutputStream.write(buffer, 0, buffer.length);
            fileOutputStream.close();
            System.out.println(savePath + " DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

