/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javaUtil.Util;

import com.github.luomingxuorg.javaUtil.Entity.PageEntity;
import com.github.luomingxuorg.javaUtil.Entity.PageRequest;
import com.github.luomingxuorg.javaUtil.Exception.SortException;
import com.github.luomingxuorg.javaUtil.Util.SortUtil;
import java.util.ArrayList;
import java.util.List;

public class ListPageHelper {
    private static Integer maxSize = 100;
    private static Integer maxPage = 100;

    public static <T> PageEntity<T> doPage(PageRequest pageRequest, List<T> paramLists, Integer ... param) {
        ListPageHelper.setMaxSizePage(param);
        ArrayList<T> pagedLists = new ArrayList<T>();
        PageEntity<T> pageEntity = new PageEntity<T>();
        if (paramLists == null || paramLists.size() < 1) {
            System.err.println("No data in lists. ");
            pageEntity.setEmpty(true);
            return pageEntity;
        }
        if (pageRequest == null || pageRequest.getSize() == null | pageRequest.getPage() == null) {
            System.err.println("No data in pageRequest. ");
            pageEntity.setEmpty(true);
            return pageEntity;
        }
        if (pageRequest.getSort() != null) {
            try {
                SortUtil.doSort(pageRequest.getSort(), paramLists);
            }
            catch (SortException e) {
                e.printStackTrace();
            }
        }
        Integer size = pageRequest.getSize();
        Integer page = pageRequest.getPage();
        if (size < 1 | size > maxSize || page < 1 | page > maxPage) {
            size = 20;
            page = 1;
        }
        pageEntity.setTotalElements(paramLists.size());
        pageEntity.setSize(size);
        pageEntity.setPage(page);
        if (size >= paramLists.size()) {
            if (page > 1) {
                pageEntity.setEmpty(true);
                return pageEntity;
            }
            pageEntity.setPageOfElements_Content_TotalPages(paramLists.size(), paramLists, 1);
            return pageEntity;
        }
        int count = 0;
        try {
            for (int i = size * (page - 1); i < size * page; ++i) {
                pagedLists.add(paramLists.get(i));
                ++count;
            }
        }
        catch (Exception e) {
            System.err.println("List index out of range. ");
            System.err.println(String.format("We count '%s' data in this page.", count));
            if (count == 0) {
                pageEntity.setEmpty(true);
                pageEntity.setTotalPages(paramLists.size() / size + 1);
                return pageEntity;
            }
            pageEntity.setPageOfElements_Content_TotalPages(count, pagedLists, paramLists.size() / size + 1);
            return pageEntity;
        }
        pageEntity.setPageOfElements_Content_TotalPages(count, pagedLists, paramLists.size() / size + 1);
        return pageEntity;
    }

    private static void setMaxSizePage(Integer ... param) {
        Integer[] temp = (Integer[])param.clone();
        try {
            maxSize = temp[0];
            maxPage = temp[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

