/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javaUtil.Util;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperConverter {
    private static final Logger log = LoggerFactory.getLogger(WrapperConverter.class);
    private static final Map<String, BeanCopier> BEAN_COPIER_CACHE = new ConcurrentHashMap<String, BeanCopier>();
    private static final Map<String, ConstructorAccess> CONSTRUCTOR_ACCESS_CACHE = new ConcurrentHashMap<String, ConstructorAccess>();

    public static void copy(Object source, Object target, @NonNull boolean useConverter, Converter converter) {
        if (useConverter && converter == null) {
            log.error("Converter can not be NULL when useConverter is true");
            return;
        }
        BeanCopier copier = WrapperConverter.getBeanCopier(source.getClass(), target.getClass(), useConverter);
        copier.copy(source, target, converter);
    }

    public static <S, T> List<T> copyList(List<S> sourceList, Class<T> targetClass, @NonNull boolean useConverter, Converter converter) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        if (useConverter && converter == null) {
            log.error("Converter can not be NULL when useConverter is true");
            return Collections.emptyList();
        }
        ConstructorAccess<T> constructorAccess = WrapperConverter.getConstructorAccess(targetClass);
        BeanCopier copier = WrapperConverter.getBeanCopier(sourceList.get(0).getClass(), targetClass, useConverter);
        LinkedList<Object> resultList = new LinkedList<Object>();
        try {
            for (S source : sourceList) {
                Object target = constructorAccess.newInstance();
                copier.copy(source, target, converter);
                resultList.add(target);
            }
        }
        catch (Exception e) {
            log.error(String.format("Copy list %s failed", targetClass));
            e.printStackTrace();
            return Collections.emptyList();
        }
        return resultList;
    }

    private static BeanCopier getBeanCopier(Class sourceClass, Class targetClass, boolean useConverter) {
        StringBuffer sb = new StringBuffer();
        sb.append(sourceClass.getName());
        sb.append("-");
        sb.append(targetClass.getName());
        sb.append("-");
        sb.append(useConverter);
        String beanKey = sb.toString();
        BeanCopier copier = BEAN_COPIER_CACHE.get(beanKey);
        if (copier == null) {
            copier = BeanCopier.create((Class)sourceClass, (Class)targetClass, (boolean)useConverter);
            BEAN_COPIER_CACHE.put(beanKey, copier);
            return copier;
        }
        return copier;
    }

    private static <T> ConstructorAccess<T> getConstructorAccess(Class<T> targetClass) {
        ConstructorAccess constructorAccess = CONSTRUCTOR_ACCESS_CACHE.get(targetClass.getName());
        if (constructorAccess != null) {
            return constructorAccess;
        }
        try {
            constructorAccess = ConstructorAccess.get(targetClass);
            constructorAccess.newInstance();
            CONSTRUCTOR_ACCESS_CACHE.put(targetClass.getName(), constructorAccess);
        }
        catch (Exception e) {
            log.error(String.format("Create new instance of %s failed", targetClass));
            throw e;
        }
        return constructorAccess;
    }
}

