/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import com.github.luomingxuorg.javautil.exception.SortException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class FieldUtil {
    public static Object getObjectByFieldName(Object param, String fieldName) throws Exception {
        Field[] fields;
        Class<?> c = param.getClass();
        for (Field field : fields = c.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            Object obj = field.get(param);
            if (obj == null) {
                throw new NullPointerException("Such field is null!");
            }
            return obj;
        }
        throw new SortException(String.format("\"%s\"--No such field in this param!", fieldName));
    }

    public static Object doFieldGetMethod(Object param, String fieldName) throws Exception {
        Method[] methods;
        Class<?> c = param.getClass();
        for (Method method : methods = c.getMethods()) {
            if (!("get" + fieldName).toLowerCase().equals(method.getName().toLowerCase())) continue;
            Object obj = method.invoke(param, new Object[0]);
            if (obj == null) {
                throw new NullPointerException("Such fieldName has no get method or this field is null!");
            }
            return obj;
        }
        throw new SortException(String.format("\"%s\"--No such field in this param!", fieldName));
    }

    public static <T> Object typeConvert(Class<T> destinClass, Object sourceObj) throws Exception {
        try {
            if (destinClass.equals(Integer.class)) {
                Method method = sourceObj.getClass().getMethod("intValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Double.class)) {
                Method method = sourceObj.getClass().getMethod("doubleValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Long.class)) {
                Method method = sourceObj.getClass().getMethod("longValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Float.class)) {
                Method method = sourceObj.getClass().getMethod("floatValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(Short.class)) {
                Method method = sourceObj.getClass().getMethod("shortValue", new Class[0]);
                return method.invoke(sourceObj, new Object[0]);
            }
            if (destinClass.equals(BigDecimal.class)) {
                if (sourceObj.getClass().equals(Double.class)) {
                    Method method = destinClass.getMethod("valueOf", Double.TYPE);
                    return method.invoke(null, sourceObj);
                }
                if (sourceObj.getClass().equals(Long.class)) {
                    Method method = destinClass.getMethod("valueOf", Long.TYPE);
                    return method.invoke(null, sourceObj);
                }
            }
            throw new Exception(String.format("Can not convert '%s' to '%s'", sourceObj.getClass(), destinClass));
        }
        catch (Exception e) {
            throw new Exception(String.format("Can not convert '%s' to '%s'", sourceObj.getClass(), destinClass));
        }
    }
}

