/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import com.github.luomingxuorg.javautil.entity.Sort;
import com.github.luomingxuorg.javautil.exception.SortException;
import com.github.luomingxuorg.javautil.util.FieldUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class SortUtil {
    public static <T> void doSort(Sort sort, List<T> paramList) throws SortException {
        if (sort.getFieldName() == null) {
            throw new SortException("You did not choose one field which you want to sort by it! ");
        }
        paramList.sort((one, two) -> {
            try {
                return SortUtil.compare(one, two, sort.getFieldName(), sort.getDirection());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                return 0;
            }
        });
    }

    private static Integer compare(Object paramOne, Object paramTwo, String fieldName, Sort.Direction direction) throws Exception {
        if (!paramOne.getClass().getName().equals(paramTwo.getClass().getName())) {
            throw new SortException("The two params is not in one class!");
        }
        return SortUtil.compare(FieldUtil.getObjectByFieldName(paramOne, fieldName), FieldUtil.getObjectByFieldName(paramTwo, fieldName), direction);
    }

    private static Integer compare(Object one, Object two, Sort.Direction direction) throws Exception {
        Class<?> clazz = one.getClass();
        if (clazz.equals(Integer.class) || clazz.equals(Double.class) || clazz.equals(Long.class) || clazz.equals(Short.class) || clazz.equals(Float.class) || clazz.equals(Date.class)) {
            Method method = clazz.getMethod("compareTo", one.getClass());
            return SortUtil.compare(method, one, two, direction);
        }
        if (clazz.equals(BigDecimal.class)) {
            Method method = BigDecimal.class.getMethod("doubleValue", new Class[0]);
            Double temp0 = (Double)method.invoke(one, new Object[0]);
            Double temp1 = (Double)method.invoke(two, new Object[0]);
            method = Double.class.getMethod("compareTo", Double.class);
            return SortUtil.compare(method, (Object)temp0, temp1, direction);
        }
        throw new Exception("Can not compare the two param's class. ");
    }

    private static Integer compare(Method method, Object one, Object two, Sort.Direction direction) throws Exception {
        switch (direction) {
            case ASC: {
                return (Integer)method.invoke(one, two);
            }
            case DESC: {
                return (Integer)method.invoke(two, one);
            }
        }
        return 0;
    }
}

