/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import com.github.luomingxuorg.javautil.entity.MethodCallInfo;
import com.github.luomingxuorg.javautil.util.PrintWithColor;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AspectLog {
    private static final Logger log = LoggerFactory.getLogger(AspectLog.class);
    private ThreadLocal<Long> startTime = new ThreadLocal();
    private Map<String, MethodCallInfo> mapMethodCall = new HashMap<String, MethodCallInfo>();

    @Pointcut(value="@annotation(com.github.luomingxuorg.javautil.annotation.EnableAspectScope)")
    private void methodAnnotationScope() {
    }

    @Before(value="methodAnnotationScope()")
    protected void before(JoinPoint point) {
        String mapKey = point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName();
        if (this.mapMethodCall.containsKey(mapKey)) {
            MethodCallInfo entity = this.mapMethodCall.get(mapKey);
            entity.setCallCount(entity.getCallCount() + 1L);
            this.mapMethodCall.put(mapKey, entity);
        } else {
            MethodCallInfo entity = new MethodCallInfo();
            entity.setCallCount(1L);
            entity.setCallTotalTime(0L);
            this.mapMethodCall.put(mapKey, entity);
        }
        this.startTime.set(System.currentTimeMillis());
    }

    @Around(value="methodAnnotationScope()")
    protected Object around(ProceedingJoinPoint point) throws Throwable {
        log.info(PrintWithColor.yellow("----------------Around----------------"));
        Object result = point.proceed();
        String className = point.getSignature().getDeclaringTypeName();
        String classType = point.getSignature().getDeclaringType().toString().split(" ")[0];
        String methodName = point.getSignature().getName();
        String returnType = point.getSignature().toString().split(" ")[0];
        Object[] args = point.getArgs();
        log.info("{}: {}({})", new Object[]{PrintWithColor.green("class/interface"), className, classType});
        log.info("{}: {}", (Object)PrintWithColor.green("method"), (Object)methodName);
        log.info("{}: {}", (Object)PrintWithColor.green("args size"), (Object)args.length);
        for (Object item : args) {
            if (item == null) continue;
            log.info("\t{}: {}\t{}: {}", new Object[]{PrintWithColor.green("type"), item.getClass().getSimpleName(), PrintWithColor.green("value"), item.toString()});
        }
        log.info("{}: {}, {}: {}", new Object[]{PrintWithColor.green("return"), result, PrintWithColor.green("type"), returnType});
        return result;
    }

    @After(value="methodAnnotationScope()")
    protected void after(JoinPoint point) {
        log.info(PrintWithColor.yellow("----------------After----------------"));
        Long costTime = System.currentTimeMillis() - this.startTime.get();
        String mapKey = point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName();
        MethodCallInfo entity = this.mapMethodCall.get(mapKey);
        entity.setCallTotalTime(entity.getCallTotalTime() + costTime);
        this.mapMethodCall.put(mapKey, entity);
        log.info(PrintWithColor.blue(String.format("cost %sms", costTime)));
        log.info(PrintWithColor.blue(this.mapMethodCall.get(mapKey).toString()));
        log.info(PrintWithColor.yellow("------------------------------------------------"));
    }
}

