/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class GenerateFrameworkFileBySQLDeprecated {
    private static String tableName = "";

    public static void generate(String filePath, String saveDir) {
        Map<String, List<String>> map = GenerateFrameworkFileBySQLDeprecated.sqlSequenceSplit(GenerateFrameworkFileBySQLDeprecated.splitSql(GenerateFrameworkFileBySQLDeprecated.readFile(new File(filePath))));
        GenerateFrameworkFileBySQLDeprecated.generateGroovy(map, saveDir);
        GenerateFrameworkFileBySQLDeprecated.generateRepository(saveDir);
        GenerateFrameworkFileBySQLDeprecated.generateService(saveDir);
    }

    private static void generateRepository(String saveDir) {
        String upperName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, tableName);
        String lowerName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tableName);
        String sb = "import org.springframework.stereotype.Component;\n\n@Component\n" + String.format("public interface %sRepository", upperName) + "\n{}\n";
        GenerateFrameworkFileBySQLDeprecated.writeInFile(sb.getBytes(), saveDir + "\\" + upperName + "Repository.java");
        sb = "import org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.stereotype.Component;\n@Component\n" + String.format("public class %sRepositoryImpl implements %sRepository\n{", upperName, upperName) + String.format("private final %sMapper %sMapper;\n", upperName, lowerName) + "@Autowired\n" + String.format("public %sRepositoryImpl(%sMapper %sMapper)\n{", upperName, upperName, lowerName) + String.format("this.%sMapper=%sMapper;\n}\n}\n", lowerName, lowerName);
        GenerateFrameworkFileBySQLDeprecated.writeInFile(sb.getBytes(), saveDir + "\\" + upperName + "RepositoryImpl.java");
    }

    private static void generateService(String saveDir) {
        String upperName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, tableName);
        String lowerName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tableName);
        String sb = "import org.springframework.stereotype.Component;\n\n@Component\n" + String.format("public interface %sService", upperName) + "\n{}\n";
        GenerateFrameworkFileBySQLDeprecated.writeInFile(sb.getBytes(), saveDir + "\\" + upperName + "Service.java");
        sb = "import org.springframework.beans.factory.annotation.Autowired;\nimport org.springframework.stereotype.Component;\n@Component\n" + String.format("public class %sServiceImpl implements %sService\n{", upperName, upperName) + String.format("private final %sRepository %sRepository;\n", upperName, lowerName) + "@Autowired\n" + String.format("public %sServiceImpl(%sRepository %sRepository)\n{", upperName, upperName, lowerName) + String.format("this.%sRepository=%sRepository;\n}\n}\n", lowerName, lowerName);
        GenerateFrameworkFileBySQLDeprecated.writeInFile(sb.getBytes(), saveDir + "\\" + upperName + "ServiceImpl.java");
    }

    private static void generateGroovy(Map<String, List<String>> map, String saveDir) {
        StringBuilder sb = new StringBuilder();
        sb.append("package script.db\n\n");
        sb.append(String.format("databaseChangeLog(logicalFilePath: '%s.groovy')\n", tableName));
        sb.append("{\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sb.append(String.format("changeSet(id: '%s-add-table-%s', author: 'GeneratedBy LuomingXuOrg')\n", sdf.format(new Date(System.currentTimeMillis())), tableName));
        sb.append("{\n");
        sb.append(String.format("createTable(tableName: \"%s\")\n", tableName));
        sb.append("{\n");
        sb.append("column(name: 'id', type: 'BIGINT', autoIncrement: true, remarks: '\u8868ID\uff0c\u4e3b\u952e\uff0cunsigned bigint\u3001\u5355\u8868\u65f6\u81ea\u589e\u3001\u6b65\u957f\u4e3a 1')\n{\nconstraints(primaryKey: true)\n}\n");
        for (List<String> list : map.values()) {
            String key = list.get(0);
            if (key.equals("id") || key.equals("created_by") || key.equals("creation_date") || key.equals("last_updated_by") || key.equals("last_update_date") || key.equals("object_version_number")) continue;
            sb.append(String.format("column(name: '%s'", list.get(0)));
            if (list.contains("null")) {
                if (list.contains("not")) {
                    sb.append(String.format(", type: '%s not null'", list.get(1).equals("date") ? "datetime" : list.get(1)));
                } else {
                    sb.append(String.format(", type: '%s null'", list.get(1).equals("date") ? "datetime" : list.get(1)));
                }
            }
            if (list.contains("default")) {
                sb.append(String.format(", defaultValue: %s", list.get(list.indexOf("default") + 1)));
            }
            if (list.contains("comment")) {
                StringBuilder temp = new StringBuilder();
                int i = list.indexOf("comment") + 1;
                while (true) {
                    if (list.get(i).startsWith("'")) {
                        temp.append(list.get(i));
                    }
                    if (list.get(i).endsWith("'") && !list.get(i).startsWith("'")) {
                        temp.append(list.get(i));
                    }
                    if (temp.toString().endsWith("'")) break;
                    ++i;
                }
                sb.append(String.format(", remarks: %s", temp.toString()));
            }
            sb.append(")\n");
        }
        sb.append("column(name: 'created_by', type: 'BIGINT', defaultValue: '0', remarks: '\u521b\u5efa\u4eba')\n");
        sb.append("column(name: 'creation_date', type: 'DATETIME not null', defaultValueComputed: 'CURRENT_TIMESTAMP', remarks: '\u521b\u5efa\u65f6\u95f4')\n");
        sb.append("column(name: 'last_updated_by', type: 'BIGINT', defaultValue: '0', remarks: '\u4fee\u6539\u4eba')\n");
        sb.append("column(name: 'last_update_date', type: 'DATETIME not null on update current_timestamp', defaultValueComputed: 'CURRENT_TIMESTAMP', remarks: '\u6700\u540e\u4fee\u6539\u65f6\u95f4')\n");
        sb.append("column(name: 'object_version_number', type: 'BIGINT', defaultValue: '1', remarks: '\u7248\u672c\u53f7')\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append("}\n");
        GenerateFrameworkFileBySQLDeprecated.writeInFile(sb.toString().getBytes(), saveDir + "\\" + tableName + ".groovy");
    }

    private static void writeInFile(byte[] buffer, String savePath) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(savePath));
            fileOutputStream.write(buffer, 0, buffer.length);
            fileOutputStream.close();
            System.out.println(savePath + " DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, List<String>> sqlSequenceSplit(List<String> list) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (String item : list) {
            String[] arr = item.split("(\\s+)");
            ArrayList<String> arrTemp = new ArrayList<String>(Arrays.asList(arr));
            arrTemp.removeIf(temp -> temp.equals(""));
            map.put(arr[1], arrTemp);
        }
        return map;
    }

    private static List<String> readFile(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            int byteRead;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] b = new byte[1024];
            while ((byteRead = fileInputStream.read(b)) != -1) {
                sb.append(new String(b, 0, byteRead, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(Arrays.asList(Objects.requireNonNull(GenerateFrameworkFileBySQLDeprecated.remainBracket(sb.toString())).split("(\\s*\\r\\n)|(\\s*\\n)")));
    }

    private static String remainBracket(String str) {
        Pattern pattern = Pattern.compile("^.*table.*");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            tableName = matcher.group().split("\\.")[1];
        }
        if ((matcher = (pattern = Pattern.compile("\\(([\\s\\S]*)\\)")).matcher(str)).find()) {
            return matcher.group();
        }
        return null;
    }

    private static List<String> splitSql(List<String> list) {
        ArrayList<String> listTemp = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        list.remove(0);
        list.remove(list.size() - 1);
        for (String item : list) {
            if (!item.endsWith(",")) {
                sb.append(item);
                continue;
            }
            listTemp.add(sb + item.substring(0, item.length() - 1));
            sb = new StringBuilder();
        }
        listTemp.add(sb.toString());
        return listTemp;
    }
}

