/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleConverter {
    private static final Logger log = LoggerFactory.getLogger(SingleConverter.class);

    public static void copy(Object source, Object target, @NonNull boolean useConverter, Converter converter) {
        if (useConverter && converter == null) {
            log.error("Converter can not be NULL when useConverter is true");
            return;
        }
        BeanCopier copier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)useConverter);
        copier.copy(source, target, converter);
    }

    public static <S, T> List<T> copyList(List<S> sourceList, Class<T> targetClass, @NonNull boolean useConverter, Converter converter) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        if (useConverter && converter == null) {
            log.error("Converter can not be NULL when useConverter is true");
            return Collections.emptyList();
        }
        ConstructorAccess constructorAccess = ConstructorAccess.get(targetClass);
        BeanCopier copier = BeanCopier.create(sourceList.get(0).getClass(), targetClass, (boolean)useConverter);
        LinkedList<Object> resultList = new LinkedList<Object>();
        try {
            for (S source : sourceList) {
                Object target = constructorAccess.newInstance();
                copier.copy(source, target, converter);
                resultList.add(target);
            }
        }
        catch (Exception e) {
            log.error("Copy list {} failed", targetClass);
            e.printStackTrace();
            return Collections.emptyList();
        }
        return resultList;
    }
}

