/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;

public class CompleteFullColumns {
    public static void generate(String filePath, String formerColumnResult) {
        try {
            File file = new File(filePath);
            FileInputStream stream = new FileInputStream(file);
            CreateTable createTable = (CreateTable)CCJSqlParserUtil.parse((InputStream)stream);
            String tableName = createTable.getTable().getName();
            List columns = createTable.getColumnDefinitions();
            for (ColumnDefinition item : columns) {
                String columnName = item.getColumnName();
                Pattern pattern = Pattern.compile(String.format("(column=\"%s\")", columnName));
                Matcher matcher = pattern.matcher(formerColumnResult);
                formerColumnResult = matcher.replaceAll(String.format("column=\"%s_%s\"", tableName, columnName));
                System.out.println(String.format("%s.%s as %s_%s,", tableName, columnName, tableName, columnName));
            }
            System.out.println(formerColumnResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

