/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import com.github.luomingxuorg.javautil.util.FieldUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EntityConverter {
    public static <T> T convert(T destin, Object source) {
        if (source == null) {
            return destin;
        }
        Field[] fieldsSource = EntityConverter.getAllFields(source.getClass());
        Field[] fieldsDestin = EntityConverter.getAllFields(destin.getClass());
        Map<String, Field> destMap = Arrays.stream(fieldsDestin).filter(item -> EntityConverter.isStatic(item) == false).collect(Collectors.toMap(Field::getName, item -> item, (old, fresh) -> old));
        for (Field fieldSource : fieldsSource) {
            fieldSource.setAccessible(true);
            if (EntityConverter.isStatic(fieldSource).booleanValue()) continue;
            try {
                Field fieldDestin;
                Object sourceValue = fieldSource.get(source);
                if (sourceValue == null || (fieldDestin = destMap.get(fieldSource.getName())) == null) continue;
                fieldDestin.setAccessible(true);
                if (fieldDestin.getType().equals(fieldSource.getType())) {
                    fieldDestin.set(destin, sourceValue);
                    continue;
                }
                try {
                    fieldDestin.set(destin, FieldUtil.typeConvert(fieldDestin.getType(), sourceValue));
                }
                catch (Exception e) {
                    fieldDestin.set(destin, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return destin;
    }

    public static <S, T> List<T> convertList(T destin, List<S> source) {
        if (source == null || source.size() < 1) {
            return null;
        }
        ArrayList lists = new ArrayList(source.size());
        Class<?> clazz = destin.getClass();
        try {
            for (S item : source) {
                Object temp = clazz.newInstance();
                lists.add(EntityConverter.convert(temp, item));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lists;
    }

    private static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != Object.class) {
            try {
                fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        Field[] temp = new Field[fieldList.size()];
        fieldList.toArray(temp);
        return temp;
    }

    private static Boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }
}

