/*
 * Decompiled with CFR 0.152.
 */
package com.github.luomingxuorg.javautil.util;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snowflake {
    private static final Logger log = LoggerFactory.getLogger(Snowflake.class);
    private static long epoch = 1566885913535L;
    private static final long workerIdBits = 5L;
    private static final long dataCenterIdBits = 5L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 17L;
    private static final long timestampShift = 22L;
    private static final long sequenceMask = 4095L;
    private static final long workerIdMask = 31L;
    private static final long dataCenterIdMask = 31L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static final Random RANDOM = new Random();

    public Snowflake(long dataCenterId, long workerId, long projectStartEpoch) {
        this.dataCenterId = dataCenterId & 0x1FL;
        this.workerId = workerId & 0x1FL;
        epoch = projectStartEpoch;
    }

    public synchronized long nextId() {
        long timestamp = this.timestamp();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                log.info("rollover");
                this.sequence = RANDOM.nextInt(100);
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = RANDOM.nextInt(100);
        }
        if (timestamp < this.lastTimestamp) {
            log.warn("Clock is moving backwards. Rejecting requests until {}.", (Object)this.lastTimestamp);
            if (this.timeBackwardsCallback(timestamp, this.lastTimestamp)) {
                return this.nextId();
            }
        }
        this.lastTimestamp = timestamp;
        return timestamp - epoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timestamp();
        }
        return timestamp;
    }

    private long timestamp() {
        return System.currentTimeMillis();
    }

    protected boolean timeBackwardsCallback(long timestamp, long lastTimestamp) {
        long delay = lastTimestamp - timestamp;
        log.warn("Will wait {}ms to see if it could generate. ", (Object)delay);
        if (delay < 618L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if ((timestamp = this.timestamp()) < lastTimestamp) {
            log.error("Wait {}ms is not enough. Refusing to generate id.", (Object)delay);
            throw new IllegalStateException("Clock moved backwards. Refusing to generate id for " + (lastTimestamp - timestamp) + " milliseconds");
        }
        return true;
    }
}

