/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jsonnodereader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.github.marschall.jsonnodereader.JsonNodeJsonArray;
import com.github.marschall.jsonnodereader.JsonNodeJsonNumber;
import com.github.marschall.jsonnodereader.JsonNodeJsonObject;
import com.github.marschall.jsonnodereader.JsonNodeJsonString;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class JsonNodeJsonParser
implements JsonParser {
    private static final Map<JsonNodeType, JsonParser.Event> TYPE_TO_EVENT_MAP = new EnumMap<JsonNodeType, JsonParser.Event>(JsonNodeType.class);
    private JsonNodeIterator currentNode;
    private JsonParser.Event currentState;
    private final Deque<JsonNodeIterator> nodeStack;

    private static JsonParser.Event getState(JsonNode node) {
        JsonNodeType nodeType = node.getNodeType();
        if (nodeType == JsonNodeType.BOOLEAN) {
            return node.booleanValue() ? JsonParser.Event.VALUE_TRUE : JsonParser.Event.VALUE_FALSE;
        }
        JsonParser.Event state = TYPE_TO_EVENT_MAP.get(nodeType);
        if (state == null) {
            throw new IllegalStateException("unsupported node type");
        }
        return state;
    }

    public JsonNodeJsonParser(JsonNode root) {
        Objects.requireNonNull(root, "root");
        this.currentNode = JsonNodeIterator.adapt(root);
        this.nodeStack = new ArrayDeque<JsonNodeIterator>();
    }

    public boolean hasNext() {
        if (this.currentState == JsonParser.Event.END_OBJECT || this.currentState == JsonParser.Event.END_ARRAY) {
            return !this.nodeStack.isEmpty();
        }
        return true;
    }

    public JsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.advance();
        return this.currentState;
    }

    private void advance() {
        if (this.currentState == null) {
            this.currentState = this.currentNode.startEvent();
        } else {
            if (this.currentState == JsonParser.Event.END_OBJECT || this.currentState == JsonParser.Event.END_ARRAY) {
                this.currentNode = this.nodeStack.pop();
            }
            this.currentState = this.currentNode.nextState(this.currentState);
            this.pushNodeIfStart();
        }
    }

    private void pushNodeIfStart() {
        if (this.currentState == JsonParser.Event.START_ARRAY) {
            this.nodeStack.push(this.currentNode);
            this.currentNode = new JsonNodeIterator.ArrayJsonNodeIterator(this.currentNode.getJsonNode());
        } else if (this.currentState == JsonParser.Event.START_OBJECT) {
            this.nodeStack.push(this.currentNode);
            this.currentNode = new JsonNodeIterator.ObjectJsonNodeIterator(this.currentNode.getJsonNode());
        }
    }

    public String getString() {
        return switch (this.currentState) {
            case JsonParser.Event.KEY_NAME -> ((JsonNodeIterator.ObjectJsonNodeIterator)this.currentNode).getKey();
            case JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER -> this.currentNode.getJsonNode().asText();
            default -> throw new IllegalStateException("getString() not supported in current state");
        };
    }

    public boolean isIntegralNumber() {
        if (this.currentState != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("current state is not a number");
        }
        return this.currentNode.getJsonNode().isIntegralNumber();
    }

    public int getInt() {
        if (this.currentState != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("current state is not a number");
        }
        return this.currentNode.getJsonNode().intValue();
    }

    public long getLong() {
        if (this.currentState != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("current state is not a number");
        }
        return this.currentNode.getJsonNode().longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.currentState != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("current state is not a number");
        }
        return this.currentNode.getJsonNode().decimalValue();
    }

    public JsonLocation getLocation() {
        return LocationUnkown.INSTANCE;
    }

    public JsonParser.Event currentEvent() {
        return this.currentState;
    }

    public JsonObject getObject() {
        if (this.currentState != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException("not in start object");
        }
        JsonNode node = this.currentNode.getContainerNode();
        Object object = node.isEmpty() ? JsonValue.EMPTY_JSON_OBJECT : new JsonNodeJsonObject(node);
        this.currentState = JsonParser.Event.END_OBJECT;
        return object;
    }

    public JsonValue getValue() {
        return switch (this.currentState) {
            default -> throw new MatchException(null, null);
            case JsonParser.Event.END_OBJECT, JsonParser.Event.END_ARRAY -> throw new IllegalStateException("in state end");
            case JsonParser.Event.START_ARRAY -> this.getArray();
            case JsonParser.Event.START_OBJECT -> this.getObject();
            case JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_STRING -> new JsonNodeJsonString(this.currentNode.getJsonNode());
            case JsonParser.Event.VALUE_NUMBER -> new JsonNodeJsonNumber(this.currentNode.getJsonNode());
            case JsonParser.Event.VALUE_TRUE -> JsonValue.TRUE;
            case JsonParser.Event.VALUE_FALSE -> JsonValue.FALSE;
            case JsonParser.Event.VALUE_NULL -> JsonValue.NULL;
        };
    }

    public JsonArray getArray() {
        if (this.currentState != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException("not in start array");
        }
        JsonNode node = this.currentNode.getContainerNode();
        Object array = node.isEmpty() ? JsonValue.EMPTY_JSON_ARRAY : new JsonNodeJsonArray(node);
        this.currentState = JsonParser.Event.END_ARRAY;
        return array;
    }

    public void skipArray() {
        if (this.currentNode instanceof JsonNodeIterator.ArrayJsonNodeIterator) {
            this.currentState = JsonParser.Event.END_ARRAY;
        }
    }

    public void skipObject() {
        if (this.currentNode instanceof JsonNodeIterator.ObjectJsonNodeIterator) {
            this.currentState = JsonParser.Event.END_OBJECT;
        }
    }

    public void close() {
    }

    static {
        TYPE_TO_EVENT_MAP.put(JsonNodeType.ARRAY, JsonParser.Event.START_ARRAY);
        TYPE_TO_EVENT_MAP.put(JsonNodeType.OBJECT, JsonParser.Event.START_OBJECT);
        TYPE_TO_EVENT_MAP.put(JsonNodeType.NUMBER, JsonParser.Event.VALUE_NUMBER);
        TYPE_TO_EVENT_MAP.put(JsonNodeType.STRING, JsonParser.Event.VALUE_STRING);
        TYPE_TO_EVENT_MAP.put(JsonNodeType.NULL, JsonParser.Event.VALUE_NULL);
    }

    static sealed interface JsonNodeIterator {
        public static JsonNodeIterator adapt(JsonNode jsonNode) {
            if (jsonNode.isObject()) {
                return new ObjectJsonNodeIterator(jsonNode);
            }
            if (jsonNode.isArray()) {
                return new ArrayJsonNodeIterator(jsonNode);
            }
            throw new IllegalArgumentException("unsupported node type");
        }

        public JsonParser.Event nextState(JsonParser.Event var1);

        public JsonNode getJsonNode();

        public JsonNode getContainerNode();

        public JsonParser.Event startEvent();

        public static final class ObjectJsonNodeIterator
        implements JsonNodeIterator {
            private final Iterator<Map.Entry<String, JsonNode>> iterator;
            private JsonNode value;
            private String key;
            private JsonNode object;

            ObjectJsonNodeIterator(JsonNode object) {
                this.object = object;
                this.iterator = object.fields();
            }

            @Override
            public JsonParser.Event startEvent() {
                return JsonParser.Event.START_OBJECT;
            }

            String getKey() {
                return this.key;
            }

            @Override
            public JsonParser.Event nextState(JsonParser.Event currentState) {
                if (currentState == JsonParser.Event.KEY_NAME) {
                    return JsonNodeJsonParser.getState(this.value);
                }
                if (this.iterator.hasNext()) {
                    Map.Entry<String, JsonNode> next = this.iterator.next();
                    this.key = next.getKey();
                    this.value = next.getValue();
                    return JsonParser.Event.KEY_NAME;
                }
                return JsonParser.Event.END_OBJECT;
            }

            @Override
            public JsonNode getJsonNode() {
                return this.value;
            }

            @Override
            public JsonNode getContainerNode() {
                return this.object;
            }
        }

        public static final class ArrayJsonNodeIterator
        implements JsonNodeIterator {
            private final Iterator<JsonNode> nodeIterator;
            private JsonNode value;
            private JsonNode array;

            ArrayJsonNodeIterator(JsonNode array) {
                this.array = array;
                this.nodeIterator = array.elements();
            }

            @Override
            public JsonParser.Event startEvent() {
                return JsonParser.Event.START_ARRAY;
            }

            @Override
            public JsonParser.Event nextState(JsonParser.Event currentState) {
                if (this.nodeIterator.hasNext()) {
                    this.value = this.nodeIterator.next();
                    return JsonNodeJsonParser.getState(this.value);
                }
                return JsonParser.Event.END_ARRAY;
            }

            @Override
            public JsonNode getJsonNode() {
                return this.value;
            }

            @Override
            public JsonNode getContainerNode() {
                return this.array;
            }
        }
    }

    static final class LocationUnkown
    implements JsonLocation {
        static final JsonLocation INSTANCE = new LocationUnkown();

        private LocationUnkown() {
        }

        public long getLineNumber() {
            return -1L;
        }

        public long getColumnNumber() {
            return -1L;
        }

        public long getStreamOffset() {
            return -1L;
        }

        public String toString() {
            return "(line no=-1, column no=-1, offset=-1)";
        }
    }
}

