/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jsonnodereader;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Objects;

final class JsonNodeJsonString
implements JsonString {
    private final JsonNode jsonNode;

    JsonNodeJsonString(JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode, "jsonNode");
        this.jsonNode = jsonNode;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.STRING;
    }

    public String getString() {
        return this.jsonNode.textValue();
    }

    public CharSequence getChars() {
        return this.getString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JsonString)) {
            return false;
        }
        JsonString other = (JsonString)obj;
        return this.getString().equals(other.getString());
    }

    public int hashCode() {
        return this.jsonNode.hashCode();
    }

    public String toString() {
        String textValue = this.jsonNode.textValue();
        StringBuilder output = new StringBuilder(textValue.length() + 2);
        output.append('\"');
        JsonStringEncoder.getInstance().quoteAsString((CharSequence)textValue, output);
        output.append('\"');
        return output.toString();
    }
}

