/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.pathjavafilemanager;

import com.github.marschall.pathjavafilemanager.PathFileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class InputPathFileObject
extends PathFileObject {
    InputPathFileObject(Path path, Charset fileEncoding) {
        super(path, fileEncoding);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        if (ignoreEncodingErrors) {
            return new InputStreamReader(this.openInputStream(), this.fileEncoding);
        }
        CharsetDecoder decoder = this.fileEncoding.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new InputStreamReader(this.openInputStream(), decoder);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        long size = Files.size(this.path);
        if (size > Integer.MAX_VALUE) {
            throw new IllegalStateException("file " + this.getName() + " is larger than: " + Integer.MAX_VALUE);
        }
        int fileSize = (int)size;
        if (fileSize == 0) {
            return "";
        }
        try (Reader reader = this.openReader(ignoreEncodingErrors);){
            int read;
            char[] buffer = new char[Math.min(fileSize, 8192)];
            StringBuilder stringBuilder = new StringBuilder(fileSize);
            while ((read = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, read);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    @Override
    public OutputStream openOutputStream() {
        throw new IllegalStateException("writing not supported");
    }

    @Override
    public Writer openWriter() {
        throw new IllegalStateException("writing not supported");
    }
}

