/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.pathjavafilemanager;

import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

final class JavaFileObjects {
    private JavaFileObjects() {
        throw new AssertionError((Object)"not instantiable");
    }

    static boolean isNameCompatible(Path path, JavaFileObject.Kind fileKind, String simpleName, JavaFileObject.Kind kind) {
        if (fileKind != kind) {
            return false;
        }
        String fileName = path.getFileName().toString();
        return fileName.equals(simpleName + kind.extension);
    }

    static NestingKind getNestingKind(Path path, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS) {
            return null;
        }
        String fileName = path.getFileName().toString();
        int dollarIndex = fileName.lastIndexOf(36);
        if (dollarIndex == -1) {
            return NestingKind.TOP_LEVEL;
        }
        int dotIndex = fileName.indexOf(46, dollarIndex + 1);
        for (int i = dollarIndex + 1; i < dotIndex; ++i) {
            char c = fileName.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (i == dollarIndex + 1) {
                return NestingKind.MEMBER;
            }
            return NestingKind.LOCAL;
        }
        return NestingKind.ANONYMOUS;
    }

    static Modifier getAccessLevel(Path path) {
        return null;
    }
}

