/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Blog;
import com.google.schemaorg.core.BlogPosting;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BlogImpl
extends CreativeWorkImpl
implements Blog {
    private static final ImmutableSet<String> PROPERTY_SET = BlogImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/blogPost");
        builder.add((Object)"http://schema.org/blogPosts");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BlogImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Blog";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBlogPostList() {
        return this.getProperty("http://schema.org/blogPost");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBlogPostsList() {
        return this.getProperty("http://schema.org/blogPosts");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Blog.Builder>
    implements Blog.Builder {
        BuilderImpl() {
        }

        @Override
        public Blog.Builder addAbout(Thing value) {
            return (Blog.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Blog.Builder addAbout(Thing.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Blog.Builder addAbout(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Blog.Builder addAccessibilityAPI(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Blog.Builder addAccessibilityAPI(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Blog.Builder addAccessibilityControl(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Blog.Builder addAccessibilityControl(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Blog.Builder addAccessibilityFeature(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Blog.Builder addAccessibilityFeature(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Blog.Builder addAccessibilityHazard(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Blog.Builder addAccessibilityHazard(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Blog.Builder addAccountablePerson(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Blog.Builder addAccountablePerson(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Blog.Builder addAccountablePerson(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Blog.Builder addAdditionalType(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Blog.Builder addAdditionalType(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Blog.Builder addAggregateRating(AggregateRating value) {
            return (Blog.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Blog.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Blog.Builder addAggregateRating(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Blog.Builder addAlternateName(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Blog.Builder addAlternateName(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Blog.Builder addAlternativeHeadline(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Blog.Builder addAlternativeHeadline(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Blog.Builder addAssociatedMedia(MediaObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Blog.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Blog.Builder addAssociatedMedia(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Blog.Builder addAudience(Audience value) {
            return (Blog.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Blog.Builder addAudience(Audience.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Blog.Builder addAudience(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Blog.Builder addAudio(AudioObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Blog.Builder addAudio(AudioObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Blog.Builder addAudio(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Blog.Builder addAuthor(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Blog.Builder addAuthor(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Blog.Builder addAuthor(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Blog.Builder addAuthor(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Blog.Builder addAuthor(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Blog.Builder addAward(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Blog.Builder addAward(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Blog.Builder addAwards(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Blog.Builder addAwards(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Blog.Builder addBlogPost(BlogPosting value) {
            return (Blog.Builder)this.addProperty("http://schema.org/blogPost", value);
        }

        @Override
        public Blog.Builder addBlogPost(BlogPosting.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/blogPost", value.build());
        }

        @Override
        public Blog.Builder addBlogPost(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/blogPost", Text.of(value));
        }

        @Override
        public Blog.Builder addBlogPosts(BlogPosting value) {
            return (Blog.Builder)this.addProperty("http://schema.org/blogPosts", value);
        }

        @Override
        public Blog.Builder addBlogPosts(BlogPosting.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/blogPosts", value.build());
        }

        @Override
        public Blog.Builder addBlogPosts(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/blogPosts", Text.of(value));
        }

        @Override
        public Blog.Builder addCharacter(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Blog.Builder addCharacter(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Blog.Builder addCharacter(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Blog.Builder addCitation(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Blog.Builder addCitation(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Blog.Builder addCitation(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Blog.Builder addCitation(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Blog.Builder addComment(Comment value) {
            return (Blog.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Blog.Builder addComment(Comment.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Blog.Builder addComment(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Blog.Builder addCommentCount(Integer value) {
            return (Blog.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Blog.Builder addCommentCount(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Blog.Builder addContentLocation(Place value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Blog.Builder addContentLocation(Place.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Blog.Builder addContentLocation(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Blog.Builder addContentRating(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Blog.Builder addContentRating(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Blog.Builder addContributor(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Blog.Builder addContributor(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Blog.Builder addContributor(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Blog.Builder addContributor(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Blog.Builder addContributor(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Blog.Builder addCopyrightHolder(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Blog.Builder addCopyrightHolder(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Blog.Builder addCopyrightHolder(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Blog.Builder addCopyrightHolder(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Blog.Builder addCopyrightHolder(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Blog.Builder addCopyrightYear(Number value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Blog.Builder addCopyrightYear(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Blog.Builder addCreator(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Blog.Builder addCreator(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Blog.Builder addCreator(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Blog.Builder addCreator(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Blog.Builder addCreator(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Blog.Builder addDateCreated(Date value) {
            return (Blog.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Blog.Builder addDateCreated(DateTime value) {
            return (Blog.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Blog.Builder addDateCreated(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Blog.Builder addDateModified(Date value) {
            return (Blog.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Blog.Builder addDateModified(DateTime value) {
            return (Blog.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Blog.Builder addDateModified(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Blog.Builder addDatePublished(Date value) {
            return (Blog.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Blog.Builder addDatePublished(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Blog.Builder addDescription(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Blog.Builder addDescription(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Blog.Builder addDiscussionUrl(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Blog.Builder addDiscussionUrl(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Blog.Builder addEditor(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Blog.Builder addEditor(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Blog.Builder addEditor(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Blog.Builder addEducationalAlignment(AlignmentObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Blog.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Blog.Builder addEducationalAlignment(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Blog.Builder addEducationalUse(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Blog.Builder addEducationalUse(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Blog.Builder addEncoding(MediaObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Blog.Builder addEncoding(MediaObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Blog.Builder addEncoding(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Blog.Builder addEncodings(MediaObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Blog.Builder addEncodings(MediaObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Blog.Builder addEncodings(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Blog.Builder addExampleOfWork(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Blog.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Blog.Builder addExampleOfWork(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Blog.Builder addFileFormat(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Blog.Builder addFileFormat(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Blog.Builder addGenre(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Blog.Builder addGenre(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Blog.Builder addGenre(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Blog.Builder addHasPart(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Blog.Builder addHasPart(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Blog.Builder addHasPart(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Blog.Builder addHeadline(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Blog.Builder addHeadline(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Blog.Builder addImage(ImageObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Blog.Builder addImage(ImageObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Blog.Builder addImage(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Blog.Builder addImage(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Blog.Builder addInLanguage(Language value) {
            return (Blog.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Blog.Builder addInLanguage(Language.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Blog.Builder addInLanguage(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Blog.Builder addInLanguage(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Blog.Builder addInteractionStatistic(InteractionCounter value) {
            return (Blog.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Blog.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Blog.Builder addInteractionStatistic(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Blog.Builder addInteractivityType(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Blog.Builder addInteractivityType(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Blog.Builder addIsBasedOnUrl(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Blog.Builder addIsBasedOnUrl(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Blog.Builder addIsFamilyFriendly(Boolean value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Blog.Builder addIsFamilyFriendly(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Blog.Builder addIsPartOf(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Blog.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Blog.Builder addIsPartOf(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Blog.Builder addKeywords(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Blog.Builder addKeywords(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Blog.Builder addLearningResourceType(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Blog.Builder addLearningResourceType(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Blog.Builder addLicense(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Blog.Builder addLicense(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Blog.Builder addLicense(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Blog.Builder addLicense(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Blog.Builder addLocationCreated(Place value) {
            return (Blog.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Blog.Builder addLocationCreated(Place.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Blog.Builder addLocationCreated(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Blog.Builder addMainEntity(Thing value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Blog.Builder addMainEntity(Thing.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Blog.Builder addMainEntity(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Blog.Builder addMainEntityOfPage(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Blog.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Blog.Builder addMainEntityOfPage(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Blog.Builder addMainEntityOfPage(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Blog.Builder addMentions(Thing value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Blog.Builder addMentions(Thing.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Blog.Builder addMentions(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Blog.Builder addName(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Blog.Builder addName(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Blog.Builder addOffers(Offer value) {
            return (Blog.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Blog.Builder addOffers(Offer.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Blog.Builder addOffers(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Blog.Builder addPosition(Integer value) {
            return (Blog.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Blog.Builder addPosition(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Blog.Builder addPosition(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Blog.Builder addPotentialAction(Action value) {
            return (Blog.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Blog.Builder addPotentialAction(Action.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Blog.Builder addPotentialAction(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Blog.Builder addProducer(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Blog.Builder addProducer(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Blog.Builder addProducer(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Blog.Builder addProducer(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Blog.Builder addProducer(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Blog.Builder addProvider(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Blog.Builder addProvider(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Blog.Builder addProvider(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Blog.Builder addProvider(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Blog.Builder addProvider(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Blog.Builder addPublication(PublicationEvent value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Blog.Builder addPublication(PublicationEvent.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Blog.Builder addPublication(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Blog.Builder addPublisher(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Blog.Builder addPublisher(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Blog.Builder addPublisher(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Blog.Builder addPublisher(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Blog.Builder addPublisher(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Blog.Builder addPublishingPrinciples(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Blog.Builder addPublishingPrinciples(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Blog.Builder addRecordedAt(Event value) {
            return (Blog.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Blog.Builder addRecordedAt(Event.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Blog.Builder addRecordedAt(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Blog.Builder addReleasedEvent(PublicationEvent value) {
            return (Blog.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Blog.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Blog.Builder addReleasedEvent(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Blog.Builder addReview(Review value) {
            return (Blog.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Blog.Builder addReview(Review.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Blog.Builder addReview(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Blog.Builder addReviews(Review value) {
            return (Blog.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Blog.Builder addReviews(Review.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Blog.Builder addReviews(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Blog.Builder addSameAs(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Blog.Builder addSameAs(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Blog.Builder addSchemaVersion(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Blog.Builder addSchemaVersion(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Blog.Builder addSchemaVersion(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Blog.Builder addSourceOrganization(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Blog.Builder addSourceOrganization(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Blog.Builder addSourceOrganization(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Blog.Builder addText(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Blog.Builder addText(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Blog.Builder addThumbnailUrl(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Blog.Builder addThumbnailUrl(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Blog.Builder addTimeRequired(Duration value) {
            return (Blog.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Blog.Builder addTimeRequired(Duration.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Blog.Builder addTimeRequired(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Blog.Builder addTranslator(Organization value) {
            return (Blog.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Blog.Builder addTranslator(Organization.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Blog.Builder addTranslator(Person value) {
            return (Blog.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Blog.Builder addTranslator(Person.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Blog.Builder addTranslator(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Blog.Builder addTypicalAgeRange(Text value) {
            return (Blog.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Blog.Builder addTypicalAgeRange(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Blog.Builder addUrl(URL value) {
            return (Blog.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Blog.Builder addUrl(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Blog.Builder addVersion(Number value) {
            return (Blog.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Blog.Builder addVersion(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Blog.Builder addVideo(VideoObject value) {
            return (Blog.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Blog.Builder addVideo(VideoObject.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Blog.Builder addVideo(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Blog.Builder addWorkExample(CreativeWork value) {
            return (Blog.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Blog.Builder addWorkExample(CreativeWork.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Blog.Builder addWorkExample(String value) {
            return (Blog.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Blog.Builder addDetailedDescription(Article value) {
            return (Blog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Blog.Builder addDetailedDescription(Article.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Blog.Builder addDetailedDescription(String value) {
            return (Blog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Blog.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Blog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Blog.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Blog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Blog.Builder addPopularityScore(String value) {
            return (Blog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Blog build() {
            return new BlogImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

