/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Class;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Enumeration;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Property;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ClassImpl
extends IntangibleImpl
implements Class {
    private static final ImmutableSet<String> PROPERTY_SET = ClassImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/supersededBy");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ClassImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Class";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getSupersededByList() {
        return this.getProperty("http://schema.org/supersededBy");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Class.Builder>
    implements Class.Builder {
        BuilderImpl() {
        }

        @Override
        public Class.Builder addAdditionalType(URL value) {
            return (Class.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Class.Builder addAdditionalType(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Class.Builder addAlternateName(Text value) {
            return (Class.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Class.Builder addAlternateName(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Class.Builder addDescription(Text value) {
            return (Class.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Class.Builder addDescription(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Class.Builder addImage(ImageObject value) {
            return (Class.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Class.Builder addImage(ImageObject.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Class.Builder addImage(URL value) {
            return (Class.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Class.Builder addImage(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Class.Builder addMainEntityOfPage(CreativeWork value) {
            return (Class.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Class.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Class.Builder addMainEntityOfPage(URL value) {
            return (Class.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Class.Builder addMainEntityOfPage(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Class.Builder addName(Text value) {
            return (Class.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Class.Builder addName(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Class.Builder addPotentialAction(Action value) {
            return (Class.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Class.Builder addPotentialAction(Action.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Class.Builder addPotentialAction(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Class.Builder addSameAs(URL value) {
            return (Class.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Class.Builder addSameAs(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Class.Builder addSupersededBy(Class value) {
            return (Class.Builder)this.addProperty("http://schema.org/supersededBy", value);
        }

        @Override
        public Class.Builder addSupersededBy(Class.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.org/supersededBy", value.build());
        }

        @Override
        public Class.Builder addSupersededBy(Enumeration value) {
            return (Class.Builder)this.addProperty("http://schema.org/supersededBy", value);
        }

        @Override
        public Class.Builder addSupersededBy(Property value) {
            return (Class.Builder)this.addProperty("http://schema.org/supersededBy", value);
        }

        @Override
        public Class.Builder addSupersededBy(Property.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.org/supersededBy", value.build());
        }

        @Override
        public Class.Builder addSupersededBy(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/supersededBy", Text.of(value));
        }

        @Override
        public Class.Builder addUrl(URL value) {
            return (Class.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Class.Builder addUrl(String value) {
            return (Class.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Class.Builder addDetailedDescription(Article value) {
            return (Class.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Class.Builder addDetailedDescription(Article.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Class.Builder addDetailedDescription(String value) {
            return (Class.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Class.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Class.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Class.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Class.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Class.Builder addPopularityScore(String value) {
            return (Class.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Class build() {
            return new ClassImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

