/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DataCatalog;
import com.google.schemaorg.core.DataDownload;
import com.google.schemaorg.core.DataFeed;
import com.google.schemaorg.core.DataFeedItem;
import com.google.schemaorg.core.DatasetImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DataFeedImpl
extends DatasetImpl
implements DataFeed {
    private static final ImmutableSet<String> PROPERTY_SET = DataFeedImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/catalog");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dataFeedElement");
        builder.add((Object)"http://schema.org/datasetTimeInterval");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/distribution");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includedDataCatalog");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/spatial");
        builder.add((Object)"http://schema.org/temporal");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DataFeedImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DataFeed";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDataFeedElementList() {
        return this.getProperty("http://schema.org/dataFeedElement");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DataFeed.Builder>
    implements DataFeed.Builder {
        BuilderImpl() {
        }

        @Override
        public DataFeed.Builder addAbout(Thing value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public DataFeed.Builder addAbout(Thing.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public DataFeed.Builder addAbout(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAccessibilityAPI(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public DataFeed.Builder addAccessibilityAPI(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAccessibilityControl(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public DataFeed.Builder addAccessibilityControl(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAccessibilityFeature(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public DataFeed.Builder addAccessibilityFeature(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAccessibilityHazard(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public DataFeed.Builder addAccessibilityHazard(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAccountablePerson(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public DataFeed.Builder addAccountablePerson(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public DataFeed.Builder addAccountablePerson(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAdditionalType(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DataFeed.Builder addAdditionalType(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAggregateRating(AggregateRating value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public DataFeed.Builder addAggregateRating(AggregateRating.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public DataFeed.Builder addAggregateRating(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAlternateName(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DataFeed.Builder addAlternateName(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAlternativeHeadline(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public DataFeed.Builder addAlternativeHeadline(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAssociatedMedia(MediaObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public DataFeed.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public DataFeed.Builder addAssociatedMedia(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAudience(Audience value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public DataFeed.Builder addAudience(Audience.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public DataFeed.Builder addAudience(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAudio(AudioObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public DataFeed.Builder addAudio(AudioObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public DataFeed.Builder addAudio(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAuthor(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public DataFeed.Builder addAuthor(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public DataFeed.Builder addAuthor(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public DataFeed.Builder addAuthor(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public DataFeed.Builder addAuthor(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAward(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public DataFeed.Builder addAward(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public DataFeed.Builder addAwards(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public DataFeed.Builder addAwards(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCatalog(DataCatalog value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/catalog", value);
        }

        @Override
        public DataFeed.Builder addCatalog(DataCatalog.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/catalog", value.build());
        }

        @Override
        public DataFeed.Builder addCatalog(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/catalog", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCharacter(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public DataFeed.Builder addCharacter(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public DataFeed.Builder addCharacter(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCitation(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public DataFeed.Builder addCitation(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public DataFeed.Builder addCitation(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public DataFeed.Builder addCitation(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public DataFeed.Builder addComment(Comment value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public DataFeed.Builder addComment(Comment.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public DataFeed.Builder addComment(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCommentCount(Integer value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public DataFeed.Builder addCommentCount(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public DataFeed.Builder addContentLocation(Place value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public DataFeed.Builder addContentLocation(Place.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public DataFeed.Builder addContentLocation(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public DataFeed.Builder addContentRating(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public DataFeed.Builder addContentRating(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public DataFeed.Builder addContributor(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public DataFeed.Builder addContributor(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public DataFeed.Builder addContributor(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public DataFeed.Builder addContributor(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public DataFeed.Builder addContributor(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCopyrightHolder(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public DataFeed.Builder addCopyrightHolder(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public DataFeed.Builder addCopyrightHolder(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public DataFeed.Builder addCopyrightHolder(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public DataFeed.Builder addCopyrightHolder(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCopyrightYear(Number value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public DataFeed.Builder addCopyrightYear(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public DataFeed.Builder addCreator(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public DataFeed.Builder addCreator(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public DataFeed.Builder addCreator(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public DataFeed.Builder addCreator(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public DataFeed.Builder addCreator(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDataFeedElement(DataFeedItem value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dataFeedElement", value);
        }

        @Override
        public DataFeed.Builder addDataFeedElement(DataFeedItem.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dataFeedElement", value.build());
        }

        @Override
        public DataFeed.Builder addDataFeedElement(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dataFeedElement", value);
        }

        @Override
        public DataFeed.Builder addDataFeedElement(Thing value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dataFeedElement", value);
        }

        @Override
        public DataFeed.Builder addDataFeedElement(Thing.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dataFeedElement", value.build());
        }

        @Override
        public DataFeed.Builder addDataFeedElement(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dataFeedElement", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDatasetTimeInterval(DateTime value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/datasetTimeInterval", value);
        }

        @Override
        public DataFeed.Builder addDatasetTimeInterval(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/datasetTimeInterval", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDateCreated(Date value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataFeed.Builder addDateCreated(DateTime value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataFeed.Builder addDateCreated(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDateModified(Date value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataFeed.Builder addDateModified(DateTime value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataFeed.Builder addDateModified(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDatePublished(Date value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public DataFeed.Builder addDatePublished(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDescription(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DataFeed.Builder addDescription(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDiscussionUrl(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public DataFeed.Builder addDiscussionUrl(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDistribution(DataDownload value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/distribution", value);
        }

        @Override
        public DataFeed.Builder addDistribution(DataDownload.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/distribution", value.build());
        }

        @Override
        public DataFeed.Builder addDistribution(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/distribution", Text.of(value));
        }

        @Override
        public DataFeed.Builder addEditor(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public DataFeed.Builder addEditor(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public DataFeed.Builder addEditor(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public DataFeed.Builder addEducationalAlignment(AlignmentObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public DataFeed.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public DataFeed.Builder addEducationalAlignment(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public DataFeed.Builder addEducationalUse(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public DataFeed.Builder addEducationalUse(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public DataFeed.Builder addEncoding(MediaObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public DataFeed.Builder addEncoding(MediaObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public DataFeed.Builder addEncoding(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public DataFeed.Builder addEncodings(MediaObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public DataFeed.Builder addEncodings(MediaObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public DataFeed.Builder addEncodings(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public DataFeed.Builder addExampleOfWork(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public DataFeed.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public DataFeed.Builder addExampleOfWork(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public DataFeed.Builder addFileFormat(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public DataFeed.Builder addFileFormat(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public DataFeed.Builder addGenre(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public DataFeed.Builder addGenre(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public DataFeed.Builder addGenre(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public DataFeed.Builder addHasPart(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public DataFeed.Builder addHasPart(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public DataFeed.Builder addHasPart(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public DataFeed.Builder addHeadline(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public DataFeed.Builder addHeadline(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public DataFeed.Builder addImage(ImageObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataFeed.Builder addImage(ImageObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DataFeed.Builder addImage(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataFeed.Builder addImage(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DataFeed.Builder addIncludedDataCatalog(DataCatalog value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/includedDataCatalog", value);
        }

        @Override
        public DataFeed.Builder addIncludedDataCatalog(DataCatalog.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/includedDataCatalog", value.build());
        }

        @Override
        public DataFeed.Builder addIncludedDataCatalog(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/includedDataCatalog", Text.of(value));
        }

        @Override
        public DataFeed.Builder addInLanguage(Language value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public DataFeed.Builder addInLanguage(Language.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public DataFeed.Builder addInLanguage(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public DataFeed.Builder addInLanguage(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public DataFeed.Builder addInteractionStatistic(InteractionCounter value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public DataFeed.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public DataFeed.Builder addInteractionStatistic(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public DataFeed.Builder addInteractivityType(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public DataFeed.Builder addInteractivityType(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public DataFeed.Builder addIsBasedOnUrl(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public DataFeed.Builder addIsBasedOnUrl(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public DataFeed.Builder addIsFamilyFriendly(Boolean value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public DataFeed.Builder addIsFamilyFriendly(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public DataFeed.Builder addIsPartOf(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public DataFeed.Builder addIsPartOf(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public DataFeed.Builder addIsPartOf(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public DataFeed.Builder addKeywords(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public DataFeed.Builder addKeywords(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public DataFeed.Builder addLearningResourceType(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public DataFeed.Builder addLearningResourceType(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public DataFeed.Builder addLicense(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public DataFeed.Builder addLicense(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public DataFeed.Builder addLicense(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public DataFeed.Builder addLicense(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public DataFeed.Builder addLocationCreated(Place value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public DataFeed.Builder addLocationCreated(Place.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public DataFeed.Builder addLocationCreated(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public DataFeed.Builder addMainEntity(Thing value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public DataFeed.Builder addMainEntity(Thing.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public DataFeed.Builder addMainEntity(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public DataFeed.Builder addMainEntityOfPage(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataFeed.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DataFeed.Builder addMainEntityOfPage(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataFeed.Builder addMainEntityOfPage(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DataFeed.Builder addMentions(Thing value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public DataFeed.Builder addMentions(Thing.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public DataFeed.Builder addMentions(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public DataFeed.Builder addName(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DataFeed.Builder addName(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DataFeed.Builder addOffers(Offer value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public DataFeed.Builder addOffers(Offer.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public DataFeed.Builder addOffers(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public DataFeed.Builder addPosition(Integer value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public DataFeed.Builder addPosition(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public DataFeed.Builder addPosition(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public DataFeed.Builder addPotentialAction(Action value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DataFeed.Builder addPotentialAction(Action.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DataFeed.Builder addPotentialAction(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DataFeed.Builder addProducer(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public DataFeed.Builder addProducer(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public DataFeed.Builder addProducer(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public DataFeed.Builder addProducer(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public DataFeed.Builder addProducer(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public DataFeed.Builder addProvider(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public DataFeed.Builder addProvider(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public DataFeed.Builder addProvider(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public DataFeed.Builder addProvider(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public DataFeed.Builder addProvider(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public DataFeed.Builder addPublication(PublicationEvent value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public DataFeed.Builder addPublication(PublicationEvent.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public DataFeed.Builder addPublication(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public DataFeed.Builder addPublisher(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public DataFeed.Builder addPublisher(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public DataFeed.Builder addPublisher(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public DataFeed.Builder addPublisher(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public DataFeed.Builder addPublisher(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public DataFeed.Builder addPublishingPrinciples(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public DataFeed.Builder addPublishingPrinciples(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public DataFeed.Builder addRecordedAt(Event value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public DataFeed.Builder addRecordedAt(Event.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public DataFeed.Builder addRecordedAt(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public DataFeed.Builder addReleasedEvent(PublicationEvent value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public DataFeed.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public DataFeed.Builder addReleasedEvent(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public DataFeed.Builder addReview(Review value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public DataFeed.Builder addReview(Review.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public DataFeed.Builder addReview(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public DataFeed.Builder addReviews(Review value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public DataFeed.Builder addReviews(Review.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public DataFeed.Builder addReviews(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public DataFeed.Builder addSameAs(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DataFeed.Builder addSameAs(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DataFeed.Builder addSchemaVersion(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public DataFeed.Builder addSchemaVersion(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public DataFeed.Builder addSchemaVersion(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public DataFeed.Builder addSourceOrganization(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public DataFeed.Builder addSourceOrganization(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public DataFeed.Builder addSourceOrganization(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public DataFeed.Builder addSpatial(Place value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/spatial", value);
        }

        @Override
        public DataFeed.Builder addSpatial(Place.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/spatial", value.build());
        }

        @Override
        public DataFeed.Builder addSpatial(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/spatial", Text.of(value));
        }

        @Override
        public DataFeed.Builder addTemporal(DateTime value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/temporal", value);
        }

        @Override
        public DataFeed.Builder addTemporal(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/temporal", Text.of(value));
        }

        @Override
        public DataFeed.Builder addText(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public DataFeed.Builder addText(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public DataFeed.Builder addThumbnailUrl(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public DataFeed.Builder addThumbnailUrl(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public DataFeed.Builder addTimeRequired(Duration value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public DataFeed.Builder addTimeRequired(Duration.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public DataFeed.Builder addTimeRequired(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public DataFeed.Builder addTranslator(Organization value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public DataFeed.Builder addTranslator(Organization.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public DataFeed.Builder addTranslator(Person value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public DataFeed.Builder addTranslator(Person.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public DataFeed.Builder addTranslator(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public DataFeed.Builder addTypicalAgeRange(Text value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public DataFeed.Builder addTypicalAgeRange(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public DataFeed.Builder addUrl(URL value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DataFeed.Builder addUrl(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DataFeed.Builder addVersion(Number value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public DataFeed.Builder addVersion(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public DataFeed.Builder addVideo(VideoObject value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public DataFeed.Builder addVideo(VideoObject.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public DataFeed.Builder addVideo(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public DataFeed.Builder addWorkExample(CreativeWork value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public DataFeed.Builder addWorkExample(CreativeWork.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public DataFeed.Builder addWorkExample(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public DataFeed.Builder addDetailedDescription(Article value) {
            return (DataFeed.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DataFeed.Builder addDetailedDescription(Article.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DataFeed.Builder addDetailedDescription(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DataFeed.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DataFeed.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DataFeed.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DataFeed.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DataFeed.Builder addPopularityScore(String value) {
            return (DataFeed.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DataFeed build() {
            return new DataFeedImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

