/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DataFeedItem;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DataFeedItemImpl
extends IntangibleImpl
implements DataFeedItem {
    private static final ImmutableSet<String> PROPERTY_SET = DataFeedItemImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateDeleted");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/item");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DataFeedItemImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DataFeedItem";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDateCreatedList() {
        return this.getProperty("http://schema.org/dateCreated");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDateDeletedList() {
        return this.getProperty("http://schema.org/dateDeleted");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDateModifiedList() {
        return this.getProperty("http://schema.org/dateModified");
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemList() {
        return this.getProperty("http://schema.org/item");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DataFeedItem.Builder>
    implements DataFeedItem.Builder {
        BuilderImpl() {
        }

        @Override
        public DataFeedItem.Builder addAdditionalType(URL value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DataFeedItem.Builder addAdditionalType(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addAlternateName(Text value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DataFeedItem.Builder addAlternateName(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addDateCreated(Date value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataFeedItem.Builder addDateCreated(DateTime value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataFeedItem.Builder addDateCreated(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addDateDeleted(DateTime value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateDeleted", value);
        }

        @Override
        public DataFeedItem.Builder addDateDeleted(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateDeleted", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addDateModified(Date value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataFeedItem.Builder addDateModified(DateTime value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataFeedItem.Builder addDateModified(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addDescription(Text value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DataFeedItem.Builder addDescription(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addImage(ImageObject value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataFeedItem.Builder addImage(ImageObject.Builder value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DataFeedItem.Builder addImage(URL value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataFeedItem.Builder addImage(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addItem(Thing value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/item", value);
        }

        @Override
        public DataFeedItem.Builder addItem(Thing.Builder value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/item", value.build());
        }

        @Override
        public DataFeedItem.Builder addItem(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/item", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addMainEntityOfPage(CreativeWork value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataFeedItem.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DataFeedItem.Builder addMainEntityOfPage(URL value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataFeedItem.Builder addMainEntityOfPage(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addName(Text value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DataFeedItem.Builder addName(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addPotentialAction(Action value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DataFeedItem.Builder addPotentialAction(Action.Builder value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DataFeedItem.Builder addPotentialAction(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addSameAs(URL value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DataFeedItem.Builder addSameAs(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addUrl(URL value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DataFeedItem.Builder addUrl(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addDetailedDescription(Article value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DataFeedItem.Builder addDetailedDescription(Article.Builder value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DataFeedItem.Builder addDetailedDescription(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DataFeedItem.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DataFeedItem.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DataFeedItem.Builder addPopularityScore(String value) {
            return (DataFeedItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DataFeedItem build() {
            return new DataFeedItemImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

