/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DoseSchedule;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.DrugClass;
import com.google.schemaorg.core.DrugCost;
import com.google.schemaorg.core.DrugLegalStatus;
import com.google.schemaorg.core.DrugPregnancyCategory;
import com.google.schemaorg.core.DrugPrescriptionStatus;
import com.google.schemaorg.core.DrugStrength;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicalTherapyImpl;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DrugImpl
extends MedicalTherapyImpl
implements Drug {
    private static final ImmutableSet<String> PROPERTY_SET = DrugImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/activeIngredient");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/administrationRoute");
        builder.add((Object)"http://schema.org/adverseOutcome");
        builder.add((Object)"http://schema.org/alcoholWarning");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/availableStrength");
        builder.add((Object)"http://schema.org/breastfeedingWarning");
        builder.add((Object)"http://schema.org/clincalPharmacology");
        builder.add((Object)"http://schema.org/clinicalPharmacology");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/contraindication");
        builder.add((Object)"http://schema.org/cost");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/dosageForm");
        builder.add((Object)"http://schema.org/doseSchedule");
        builder.add((Object)"http://schema.org/drugClass");
        builder.add((Object)"http://schema.org/duplicateTherapy");
        builder.add((Object)"http://schema.org/foodWarning");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/indication");
        builder.add((Object)"http://schema.org/interactingDrug");
        builder.add((Object)"http://schema.org/isAvailableGenerically");
        builder.add((Object)"http://schema.org/isProprietary");
        builder.add((Object)"http://schema.org/labelDetails");
        builder.add((Object)"http://schema.org/legalStatus");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/manufacturer");
        builder.add((Object)"http://schema.org/mechanismOfAction");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/nonProprietaryName");
        builder.add((Object)"http://schema.org/overdosage");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/pregnancyCategory");
        builder.add((Object)"http://schema.org/pregnancyWarning");
        builder.add((Object)"http://schema.org/prescribingInfo");
        builder.add((Object)"http://schema.org/prescriptionStatus");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedDrug");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seriousAdverseOutcome");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/warning");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DrugImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Drug";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActiveIngredientList() {
        return this.getProperty("http://schema.org/activeIngredient");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAdministrationRouteList() {
        return this.getProperty("http://schema.org/administrationRoute");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlcoholWarningList() {
        return this.getProperty("http://schema.org/alcoholWarning");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAvailableStrengthList() {
        return this.getProperty("http://schema.org/availableStrength");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBreastfeedingWarningList() {
        return this.getProperty("http://schema.org/breastfeedingWarning");
    }

    @Override
    public ImmutableList<SchemaOrgType> getClincalPharmacologyList() {
        return this.getProperty("http://schema.org/clincalPharmacology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getClinicalPharmacologyList() {
        return this.getProperty("http://schema.org/clinicalPharmacology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCostList() {
        return this.getProperty("http://schema.org/cost");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDosageFormList() {
        return this.getProperty("http://schema.org/dosageForm");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDoseScheduleList() {
        return this.getProperty("http://schema.org/doseSchedule");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDrugClassList() {
        return this.getProperty("http://schema.org/drugClass");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFoodWarningList() {
        return this.getProperty("http://schema.org/foodWarning");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInteractingDrugList() {
        return this.getProperty("http://schema.org/interactingDrug");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsAvailableGenericallyList() {
        return this.getProperty("http://schema.org/isAvailableGenerically");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsProprietaryList() {
        return this.getProperty("http://schema.org/isProprietary");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLabelDetailsList() {
        return this.getProperty("http://schema.org/labelDetails");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLegalStatusList() {
        return this.getProperty("http://schema.org/legalStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getManufacturerList() {
        return this.getProperty("http://schema.org/manufacturer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMechanismOfActionList() {
        return this.getProperty("http://schema.org/mechanismOfAction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNonProprietaryNameList() {
        return this.getProperty("http://schema.org/nonProprietaryName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOverdosageList() {
        return this.getProperty("http://schema.org/overdosage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPregnancyCategoryList() {
        return this.getProperty("http://schema.org/pregnancyCategory");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPregnancyWarningList() {
        return this.getProperty("http://schema.org/pregnancyWarning");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrescribingInfoList() {
        return this.getProperty("http://schema.org/prescribingInfo");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrescriptionStatusList() {
        return this.getProperty("http://schema.org/prescriptionStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedDrugList() {
        return this.getProperty("http://schema.org/relatedDrug");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWarningList() {
        return this.getProperty("http://schema.org/warning");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Drug.Builder>
    implements Drug.Builder {
        BuilderImpl() {
        }

        @Override
        public Drug.Builder addActiveIngredient(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/activeIngredient", value);
        }

        @Override
        public Drug.Builder addActiveIngredient(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/activeIngredient", Text.of(value));
        }

        @Override
        public Drug.Builder addAdditionalType(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Drug.Builder addAdditionalType(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Drug.Builder addAdministrationRoute(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/administrationRoute", value);
        }

        @Override
        public Drug.Builder addAdministrationRoute(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/administrationRoute", Text.of(value));
        }

        @Override
        public Drug.Builder addAdverseOutcome(MedicalEntity value) {
            return (Drug.Builder)this.addProperty("http://schema.org/adverseOutcome", value);
        }

        @Override
        public Drug.Builder addAdverseOutcome(MedicalEntity.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/adverseOutcome", value.build());
        }

        @Override
        public Drug.Builder addAdverseOutcome(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/adverseOutcome", Text.of(value));
        }

        @Override
        public Drug.Builder addAlcoholWarning(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/alcoholWarning", value);
        }

        @Override
        public Drug.Builder addAlcoholWarning(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/alcoholWarning", Text.of(value));
        }

        @Override
        public Drug.Builder addAlternateName(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Drug.Builder addAlternateName(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Drug.Builder addAvailableStrength(DrugStrength value) {
            return (Drug.Builder)this.addProperty("http://schema.org/availableStrength", value);
        }

        @Override
        public Drug.Builder addAvailableStrength(DrugStrength.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/availableStrength", value.build());
        }

        @Override
        public Drug.Builder addAvailableStrength(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/availableStrength", Text.of(value));
        }

        @Override
        public Drug.Builder addBreastfeedingWarning(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/breastfeedingWarning", value);
        }

        @Override
        public Drug.Builder addBreastfeedingWarning(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/breastfeedingWarning", Text.of(value));
        }

        @Override
        public Drug.Builder addClincalPharmacology(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/clincalPharmacology", value);
        }

        @Override
        public Drug.Builder addClincalPharmacology(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/clincalPharmacology", Text.of(value));
        }

        @Override
        public Drug.Builder addClinicalPharmacology(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/clinicalPharmacology", value);
        }

        @Override
        public Drug.Builder addClinicalPharmacology(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/clinicalPharmacology", Text.of(value));
        }

        @Override
        public Drug.Builder addCode(MedicalCode value) {
            return (Drug.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Drug.Builder addCode(MedicalCode.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Drug.Builder addCode(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Drug.Builder addContraindication(MedicalContraindication value) {
            return (Drug.Builder)this.addProperty("http://schema.org/contraindication", value);
        }

        @Override
        public Drug.Builder addContraindication(MedicalContraindication.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/contraindication", value.build());
        }

        @Override
        public Drug.Builder addContraindication(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/contraindication", Text.of(value));
        }

        @Override
        public Drug.Builder addCost(DrugCost value) {
            return (Drug.Builder)this.addProperty("http://schema.org/cost", value);
        }

        @Override
        public Drug.Builder addCost(DrugCost.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/cost", value.build());
        }

        @Override
        public Drug.Builder addCost(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/cost", Text.of(value));
        }

        @Override
        public Drug.Builder addDescription(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Drug.Builder addDescription(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Drug.Builder addDosageForm(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/dosageForm", value);
        }

        @Override
        public Drug.Builder addDosageForm(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/dosageForm", Text.of(value));
        }

        @Override
        public Drug.Builder addDoseSchedule(DoseSchedule value) {
            return (Drug.Builder)this.addProperty("http://schema.org/doseSchedule", value);
        }

        @Override
        public Drug.Builder addDoseSchedule(DoseSchedule.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/doseSchedule", value.build());
        }

        @Override
        public Drug.Builder addDoseSchedule(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/doseSchedule", Text.of(value));
        }

        @Override
        public Drug.Builder addDrugClass(DrugClass value) {
            return (Drug.Builder)this.addProperty("http://schema.org/drugClass", value);
        }

        @Override
        public Drug.Builder addDrugClass(DrugClass.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/drugClass", value.build());
        }

        @Override
        public Drug.Builder addDrugClass(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/drugClass", Text.of(value));
        }

        @Override
        public Drug.Builder addDuplicateTherapy(MedicalTherapy value) {
            return (Drug.Builder)this.addProperty("http://schema.org/duplicateTherapy", value);
        }

        @Override
        public Drug.Builder addDuplicateTherapy(MedicalTherapy.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/duplicateTherapy", value.build());
        }

        @Override
        public Drug.Builder addDuplicateTherapy(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/duplicateTherapy", Text.of(value));
        }

        @Override
        public Drug.Builder addFoodWarning(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/foodWarning", value);
        }

        @Override
        public Drug.Builder addFoodWarning(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/foodWarning", Text.of(value));
        }

        @Override
        public Drug.Builder addGuideline(MedicalGuideline value) {
            return (Drug.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Drug.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Drug.Builder addGuideline(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Drug.Builder addImage(ImageObject value) {
            return (Drug.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Drug.Builder addImage(ImageObject.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Drug.Builder addImage(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Drug.Builder addImage(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Drug.Builder addIndication(MedicalIndication value) {
            return (Drug.Builder)this.addProperty("http://schema.org/indication", value);
        }

        @Override
        public Drug.Builder addIndication(MedicalIndication.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/indication", value.build());
        }

        @Override
        public Drug.Builder addIndication(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/indication", Text.of(value));
        }

        @Override
        public Drug.Builder addInteractingDrug(Drug value) {
            return (Drug.Builder)this.addProperty("http://schema.org/interactingDrug", value);
        }

        @Override
        public Drug.Builder addInteractingDrug(Drug.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/interactingDrug", value.build());
        }

        @Override
        public Drug.Builder addInteractingDrug(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/interactingDrug", Text.of(value));
        }

        @Override
        public Drug.Builder addIsAvailableGenerically(Boolean value) {
            return (Drug.Builder)this.addProperty("http://schema.org/isAvailableGenerically", value);
        }

        @Override
        public Drug.Builder addIsAvailableGenerically(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/isAvailableGenerically", Text.of(value));
        }

        @Override
        public Drug.Builder addIsProprietary(Boolean value) {
            return (Drug.Builder)this.addProperty("http://schema.org/isProprietary", value);
        }

        @Override
        public Drug.Builder addIsProprietary(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/isProprietary", Text.of(value));
        }

        @Override
        public Drug.Builder addLabelDetails(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/labelDetails", value);
        }

        @Override
        public Drug.Builder addLabelDetails(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/labelDetails", Text.of(value));
        }

        @Override
        public Drug.Builder addLegalStatus(DrugLegalStatus value) {
            return (Drug.Builder)this.addProperty("http://schema.org/legalStatus", value);
        }

        @Override
        public Drug.Builder addLegalStatus(DrugLegalStatus.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/legalStatus", value.build());
        }

        @Override
        public Drug.Builder addLegalStatus(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/legalStatus", Text.of(value));
        }

        @Override
        public Drug.Builder addMainEntityOfPage(CreativeWork value) {
            return (Drug.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Drug.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Drug.Builder addMainEntityOfPage(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Drug.Builder addMainEntityOfPage(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Drug.Builder addManufacturer(Organization value) {
            return (Drug.Builder)this.addProperty("http://schema.org/manufacturer", value);
        }

        @Override
        public Drug.Builder addManufacturer(Organization.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/manufacturer", value.build());
        }

        @Override
        public Drug.Builder addManufacturer(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/manufacturer", Text.of(value));
        }

        @Override
        public Drug.Builder addMechanismOfAction(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/mechanismOfAction", value);
        }

        @Override
        public Drug.Builder addMechanismOfAction(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/mechanismOfAction", Text.of(value));
        }

        @Override
        public Drug.Builder addMedicineSystem(MedicineSystem value) {
            return (Drug.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Drug.Builder addMedicineSystem(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Drug.Builder addName(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Drug.Builder addName(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Drug.Builder addNonProprietaryName(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/nonProprietaryName", value);
        }

        @Override
        public Drug.Builder addNonProprietaryName(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/nonProprietaryName", Text.of(value));
        }

        @Override
        public Drug.Builder addOverdosage(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/overdosage", value);
        }

        @Override
        public Drug.Builder addOverdosage(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/overdosage", Text.of(value));
        }

        @Override
        public Drug.Builder addPotentialAction(Action value) {
            return (Drug.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Drug.Builder addPotentialAction(Action.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Drug.Builder addPotentialAction(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Drug.Builder addPregnancyCategory(DrugPregnancyCategory value) {
            return (Drug.Builder)this.addProperty("http://schema.org/pregnancyCategory", value);
        }

        @Override
        public Drug.Builder addPregnancyCategory(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/pregnancyCategory", Text.of(value));
        }

        @Override
        public Drug.Builder addPregnancyWarning(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/pregnancyWarning", value);
        }

        @Override
        public Drug.Builder addPregnancyWarning(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/pregnancyWarning", Text.of(value));
        }

        @Override
        public Drug.Builder addPrescribingInfo(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/prescribingInfo", value);
        }

        @Override
        public Drug.Builder addPrescribingInfo(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/prescribingInfo", Text.of(value));
        }

        @Override
        public Drug.Builder addPrescriptionStatus(DrugPrescriptionStatus value) {
            return (Drug.Builder)this.addProperty("http://schema.org/prescriptionStatus", value);
        }

        @Override
        public Drug.Builder addPrescriptionStatus(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/prescriptionStatus", Text.of(value));
        }

        @Override
        public Drug.Builder addRecognizingAuthority(Organization value) {
            return (Drug.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Drug.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Drug.Builder addRecognizingAuthority(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Drug.Builder addRelatedDrug(Drug value) {
            return (Drug.Builder)this.addProperty("http://schema.org/relatedDrug", value);
        }

        @Override
        public Drug.Builder addRelatedDrug(Drug.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/relatedDrug", value.build());
        }

        @Override
        public Drug.Builder addRelatedDrug(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/relatedDrug", Text.of(value));
        }

        @Override
        public Drug.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Drug.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Drug.Builder addRelevantSpecialty(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Drug.Builder addSameAs(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Drug.Builder addSameAs(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Drug.Builder addSeriousAdverseOutcome(MedicalEntity value) {
            return (Drug.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value);
        }

        @Override
        public Drug.Builder addSeriousAdverseOutcome(MedicalEntity.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value.build());
        }

        @Override
        public Drug.Builder addSeriousAdverseOutcome(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", Text.of(value));
        }

        @Override
        public Drug.Builder addStudy(MedicalStudy value) {
            return (Drug.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Drug.Builder addStudy(MedicalStudy.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Drug.Builder addStudy(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Drug.Builder addUrl(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Drug.Builder addUrl(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Drug.Builder addWarning(Text value) {
            return (Drug.Builder)this.addProperty("http://schema.org/warning", value);
        }

        @Override
        public Drug.Builder addWarning(URL value) {
            return (Drug.Builder)this.addProperty("http://schema.org/warning", value);
        }

        @Override
        public Drug.Builder addWarning(String value) {
            return (Drug.Builder)this.addProperty("http://schema.org/warning", Text.of(value));
        }

        @Override
        public Drug.Builder addDetailedDescription(Article value) {
            return (Drug.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Drug.Builder addDetailedDescription(Article.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Drug.Builder addDetailedDescription(String value) {
            return (Drug.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Drug.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Drug.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Drug.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Drug.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Drug.Builder addPopularityScore(String value) {
            return (Drug.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Drug build() {
            return new DrugImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

