/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Airport;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BoardingPolicyType;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Distance;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Flight;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.Vehicle;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class FlightImpl
extends IntangibleImpl
implements Flight {
    private static final ImmutableSet<String> PROPERTY_SET = FlightImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aircraft");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/arrivalAirport");
        builder.add((Object)"http://schema.org/arrivalGate");
        builder.add((Object)"http://schema.org/arrivalTerminal");
        builder.add((Object)"http://schema.org/arrivalTime");
        builder.add((Object)"http://schema.org/boardingPolicy");
        builder.add((Object)"http://schema.org/carrier");
        builder.add((Object)"http://schema.org/departureAirport");
        builder.add((Object)"http://schema.org/departureGate");
        builder.add((Object)"http://schema.org/departureTerminal");
        builder.add((Object)"http://schema.org/departureTime");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/estimatedFlightDuration");
        builder.add((Object)"http://schema.org/flightDistance");
        builder.add((Object)"http://schema.org/flightNumber");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mealService");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seller");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/webCheckinTime");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public FlightImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Flight";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAircraftList() {
        return this.getProperty("http://schema.org/aircraft");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalAirportList() {
        return this.getProperty("http://schema.org/arrivalAirport");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalGateList() {
        return this.getProperty("http://schema.org/arrivalGate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalTerminalList() {
        return this.getProperty("http://schema.org/arrivalTerminal");
    }

    @Override
    public ImmutableList<SchemaOrgType> getArrivalTimeList() {
        return this.getProperty("http://schema.org/arrivalTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBoardingPolicyList() {
        return this.getProperty("http://schema.org/boardingPolicy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCarrierList() {
        return this.getProperty("http://schema.org/carrier");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureAirportList() {
        return this.getProperty("http://schema.org/departureAirport");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureGateList() {
        return this.getProperty("http://schema.org/departureGate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureTerminalList() {
        return this.getProperty("http://schema.org/departureTerminal");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDepartureTimeList() {
        return this.getProperty("http://schema.org/departureTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEstimatedFlightDurationList() {
        return this.getProperty("http://schema.org/estimatedFlightDuration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFlightDistanceList() {
        return this.getProperty("http://schema.org/flightDistance");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFlightNumberList() {
        return this.getProperty("http://schema.org/flightNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMealServiceList() {
        return this.getProperty("http://schema.org/mealService");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSellerList() {
        return this.getProperty("http://schema.org/seller");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWebCheckinTimeList() {
        return this.getProperty("http://schema.org/webCheckinTime");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Flight.Builder>
    implements Flight.Builder {
        BuilderImpl() {
        }

        @Override
        public Flight.Builder addAdditionalType(URL value) {
            return (Flight.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Flight.Builder addAdditionalType(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Flight.Builder addAircraft(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/aircraft", value);
        }

        @Override
        public Flight.Builder addAircraft(Vehicle value) {
            return (Flight.Builder)this.addProperty("http://schema.org/aircraft", value);
        }

        @Override
        public Flight.Builder addAircraft(Vehicle.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/aircraft", value.build());
        }

        @Override
        public Flight.Builder addAircraft(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/aircraft", Text.of(value));
        }

        @Override
        public Flight.Builder addAlternateName(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Flight.Builder addAlternateName(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Flight.Builder addArrivalAirport(Airport value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalAirport", value);
        }

        @Override
        public Flight.Builder addArrivalAirport(Airport.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalAirport", value.build());
        }

        @Override
        public Flight.Builder addArrivalAirport(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalAirport", Text.of(value));
        }

        @Override
        public Flight.Builder addArrivalGate(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalGate", value);
        }

        @Override
        public Flight.Builder addArrivalGate(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalGate", Text.of(value));
        }

        @Override
        public Flight.Builder addArrivalTerminal(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalTerminal", value);
        }

        @Override
        public Flight.Builder addArrivalTerminal(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalTerminal", Text.of(value));
        }

        @Override
        public Flight.Builder addArrivalTime(DateTime value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalTime", value);
        }

        @Override
        public Flight.Builder addArrivalTime(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/arrivalTime", Text.of(value));
        }

        @Override
        public Flight.Builder addBoardingPolicy(BoardingPolicyType value) {
            return (Flight.Builder)this.addProperty("http://schema.org/boardingPolicy", value);
        }

        @Override
        public Flight.Builder addBoardingPolicy(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/boardingPolicy", Text.of(value));
        }

        @Override
        public Flight.Builder addCarrier(Organization value) {
            return (Flight.Builder)this.addProperty("http://schema.org/carrier", value);
        }

        @Override
        public Flight.Builder addCarrier(Organization.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/carrier", value.build());
        }

        @Override
        public Flight.Builder addCarrier(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/carrier", Text.of(value));
        }

        @Override
        public Flight.Builder addDepartureAirport(Airport value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureAirport", value);
        }

        @Override
        public Flight.Builder addDepartureAirport(Airport.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureAirport", value.build());
        }

        @Override
        public Flight.Builder addDepartureAirport(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureAirport", Text.of(value));
        }

        @Override
        public Flight.Builder addDepartureGate(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureGate", value);
        }

        @Override
        public Flight.Builder addDepartureGate(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureGate", Text.of(value));
        }

        @Override
        public Flight.Builder addDepartureTerminal(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureTerminal", value);
        }

        @Override
        public Flight.Builder addDepartureTerminal(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureTerminal", Text.of(value));
        }

        @Override
        public Flight.Builder addDepartureTime(DateTime value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureTime", value);
        }

        @Override
        public Flight.Builder addDepartureTime(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/departureTime", Text.of(value));
        }

        @Override
        public Flight.Builder addDescription(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Flight.Builder addDescription(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Flight.Builder addEstimatedFlightDuration(Duration value) {
            return (Flight.Builder)this.addProperty("http://schema.org/estimatedFlightDuration", value);
        }

        @Override
        public Flight.Builder addEstimatedFlightDuration(Duration.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/estimatedFlightDuration", value.build());
        }

        @Override
        public Flight.Builder addEstimatedFlightDuration(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/estimatedFlightDuration", value);
        }

        @Override
        public Flight.Builder addEstimatedFlightDuration(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/estimatedFlightDuration", Text.of(value));
        }

        @Override
        public Flight.Builder addFlightDistance(Distance value) {
            return (Flight.Builder)this.addProperty("http://schema.org/flightDistance", value);
        }

        @Override
        public Flight.Builder addFlightDistance(Distance.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/flightDistance", value.build());
        }

        @Override
        public Flight.Builder addFlightDistance(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/flightDistance", value);
        }

        @Override
        public Flight.Builder addFlightDistance(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/flightDistance", Text.of(value));
        }

        @Override
        public Flight.Builder addFlightNumber(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/flightNumber", value);
        }

        @Override
        public Flight.Builder addFlightNumber(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/flightNumber", Text.of(value));
        }

        @Override
        public Flight.Builder addImage(ImageObject value) {
            return (Flight.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Flight.Builder addImage(ImageObject.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Flight.Builder addImage(URL value) {
            return (Flight.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Flight.Builder addImage(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Flight.Builder addMainEntityOfPage(CreativeWork value) {
            return (Flight.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Flight.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Flight.Builder addMainEntityOfPage(URL value) {
            return (Flight.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Flight.Builder addMainEntityOfPage(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Flight.Builder addMealService(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/mealService", value);
        }

        @Override
        public Flight.Builder addMealService(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/mealService", Text.of(value));
        }

        @Override
        public Flight.Builder addName(Text value) {
            return (Flight.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Flight.Builder addName(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Flight.Builder addPotentialAction(Action value) {
            return (Flight.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Flight.Builder addPotentialAction(Action.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Flight.Builder addPotentialAction(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Flight.Builder addProvider(Organization value) {
            return (Flight.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Flight.Builder addProvider(Organization.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Flight.Builder addProvider(Person value) {
            return (Flight.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Flight.Builder addProvider(Person.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Flight.Builder addProvider(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Flight.Builder addSameAs(URL value) {
            return (Flight.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Flight.Builder addSameAs(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Flight.Builder addSeller(Organization value) {
            return (Flight.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Flight.Builder addSeller(Organization.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Flight.Builder addSeller(Person value) {
            return (Flight.Builder)this.addProperty("http://schema.org/seller", value);
        }

        @Override
        public Flight.Builder addSeller(Person.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.org/seller", value.build());
        }

        @Override
        public Flight.Builder addSeller(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/seller", Text.of(value));
        }

        @Override
        public Flight.Builder addUrl(URL value) {
            return (Flight.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Flight.Builder addUrl(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Flight.Builder addWebCheckinTime(DateTime value) {
            return (Flight.Builder)this.addProperty("http://schema.org/webCheckinTime", value);
        }

        @Override
        public Flight.Builder addWebCheckinTime(String value) {
            return (Flight.Builder)this.addProperty("http://schema.org/webCheckinTime", Text.of(value));
        }

        @Override
        public Flight.Builder addDetailedDescription(Article value) {
            return (Flight.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Flight.Builder addDetailedDescription(Article.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Flight.Builder addDetailedDescription(String value) {
            return (Flight.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Flight.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Flight.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Flight.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Flight.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Flight.Builder addPopularityScore(String value) {
            return (Flight.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Flight build() {
            return new FlightImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

